

PORT NUMBERS

The port numbers are divided into three ranges: the Well Known Ports,
the Registered Ports, and the Dynamic and/or Private Ports.

The Well Known Ports are those from 0 through 1023.

The Registered Ports are those from 1024 through 49151

The Dynamic and/or Private Ports are those from 49152 through 65535

	
WELL KNOWN PORT NUMBERS

The Well Known Ports are assigned by the IANA and on most systems can
only be used by system (or root) processes or by programs executed by
privileged users.

Ports are used in the TCP [RFC793] to name the ends of logical
connections which carry long term conversations.  For the purpose of
providing services to unknown callers, a service contact port is
defined.  This list specifies the port used by the server process as
its contact port.  The contact port is sometimes called the
"well-known port".

To the extent possible, these same port assignments are used with the
UDP [RFC768].

The assigned ports use a small portion of the possible port numbers.
For many years the assigned ports were in the range 0-255.  Recently,
the range for assigned ports managed by the IANA has been expanded to
the range 0-1023.

Port Assignments:

Keyword         Decimal    Description                     References
-------         -------    -----------                     ----------
                  0/tcp    Reserved
                  0/udp    Reserved
#                          Jon Postel <postel@isi.edu>
tcpmux            1/tcp    TCP Port Service Multiplexer
tcpmux            1/udp    TCP Port Service Multiplexer
#                          Mark Lottor <MKL@nisc.sri.com>
compressnet       2/tcp    Management Utility
compressnet       2/udp    Management Utility
compressnet       3/tcp    Compression Process
compressnet       3/udp    Compression Process
#                          Bernie Volz <VOLZ@PROCESS.COM>
#                 4/tcp    Unassigned
#                 4/udp    Unassigned
rje               5/tcp    Remote Job Entry
rje               5/udp    Remote Job Entry
#                          Jon Postel <postel@isi.edu>
#                 6/tcp    Unassigned
#                 6/udp    Unassigned
echo              7/tcp    Echo
echo              7/udp    Echo
#                          Jon Postel <postel@isi.edu>
#                 8/tcp    Unassigned
#                 8/udp    Unassigned
discard           9/tcp    Discard
discard           9/udp    Discard
#                          Jon Postel <postel@isi.edu>
#                10/tcp    Unassigned
#                10/udp    Unassigned
systat           11/tcp    Active Users
systat           11/udp    Active Users
#                          Jon Postel <postel@isi.edu>
#                12/tcp    Unassigned
#                12/udp    Unassigned
daytime          13/tcp    Daytime
daytime          13/udp    Daytime
#                          Jon Postel <postel@isi.edu>
#                14/tcp    Unassigned
#                14/udp    Unassigned
#                15/tcp    Unassigned [was netstat]
#                15/udp    Unassigned
#                16/tcp    Unassigned
#                16/udp    Unassigned
qotd             17/tcp    Quote of the Day
qotd             17/udp    Quote of the Day
#                          Jon Postel <postel@isi.edu>
msp              18/tcp    Message Send Protocol
msp              18/udp    Message Send Protocol
#                          Rina Nethaniel <---none--->
chargen          19/tcp    Character Generator
chargen          19/udp    Character Generator
ftp-data         20/tcp    File Transfer [Default Data]
ftp-data         20/udp    File Transfer [Default Data]
ftp              21/tcp    File Transfer [Control]
ftp              21/udp    File Transfer [Control]
#                          Jon Postel <postel@isi.edu>
ssh              22/tcp    SSH Remote Login Protocol
ssh              22/udp    SSH Remote Login Protocol
#                          Tatu Ylonen <ylo@cs.hut.fi>
telnet           23/tcp    Telnet
telnet           23/udp    Telnet
#                          Jon Postel <postel@isi.edu>
                 24/tcp    any private mail system
                 24/udp    any private mail system
#                          Rick Adams <rick@UUNET.UU.NET>
smtp             25/tcp    Simple Mail Transfer
smtp             25/udp    Simple Mail Transfer
#                          Jon Postel <postel@isi.edu>
#                26/tcp    Unassigned
#                26/udp    Unassigned
nsw-fe           27/tcp    NSW User System FE
nsw-fe           27/udp    NSW User System FE
#                          Robert Thomas <BThomas@F.BBN.COM>
#                28/tcp    Unassigned
#                28/udp    Unassigned
msg-icp          29/tcp    MSG ICP
msg-icp          29/udp    MSG ICP
#                          Robert Thomas <BThomas@F.BBN.COM>
#                30/tcp    Unassigned
#                30/udp    Unassigned
msg-auth         31/tcp    MSG Authentication
msg-auth         31/udp    MSG Authentication
#                          Robert Thomas <BThomas@F.BBN.COM>
#                32/tcp    Unassigned
#                32/udp    Unassigned
dsp              33/tcp    Display Support Protocol
dsp              33/udp    Display Support Protocol
#                          Ed Cain <cain@edn-unix.dca.mil>
#                34/tcp    Unassigned
#                34/udp    Unassigned
                 35/tcp    any private printer server
                 35/udp    any private printer server
#                          Jon Postel <postel@isi.edu>
#                36/tcp    Unassigned
#                36/udp    Unassigned
time             37/tcp    Time
time             37/udp    Time
#                          Jon Postel <postel@isi.edu>
rap              38/tcp    Route Access Protocol
rap              38/udp    Route Access Protocol
#                          Robert Ullmann <ariel@world.std.com>
rlp              39/tcp    Resource Location Protocol
rlp              39/udp    Resource Location Protocol
#                          Mike Accetta <MIKE.ACCETTA@CMU-CS-A.EDU>
#                40/tcp    Unassigned
#                40/udp    Unassigned
graphics         41/tcp    Graphics
graphics         41/udp    Graphics
name             42/tcp    Host Name Server
name             42/udp    Host Name Server
nameserver       42/tcp    Host Name Server
nameserver       42/udp    Host Name Server
nicname          43/tcp    Who Is
nicname          43/udp    Who Is
mpm-flags        44/tcp    MPM FLAGS Protocol
mpm-flags        44/udp    MPM FLAGS Protocol
mpm              45/tcp    Message Processing Module [recv]
mpm              45/udp    Message Processing Module [recv]
mpm-snd          46/tcp    MPM [default send]
mpm-snd          46/udp    MPM [default send]
#                          Jon Postel <postel@isi.edu>
ni-ftp           47/tcp    NI FTP
ni-ftp           47/udp    NI FTP
#                          Steve Kille <S.Kille@isode.com>
auditd           48/tcp    Digital Audit Daemon
auditd           48/udp    Digital Audit Daemon
#                          Larry Scott <scott@zk3.dec.com>
tacacs           49/tcp    Login Host Protocol (TACACS)
tacacs           49/udp    Login Host Protocol (TACACS)
#                          Pieter Ditmars <pditmars@BBN.COM>
re-mail-ck       50/tcp    Remote Mail Checking Protocol
re-mail-ck       50/udp    Remote Mail Checking Protocol
#                          Steve Dorner <s-dorner@UIUC.EDU>
la-maint         51/tcp    IMP Logical Address Maintenance
la-maint         51/udp    IMP Logical Address Maintenance
#                          Andy Malis <malis_a@timeplex.com>
xns-time         52/tcp    XNS Time Protocol
xns-time         52/udp    XNS Time Protocol
#                          Susie Armstrong <Armstrong.wbst128@XEROX>
domain           53/tcp    Domain Name Server
domain           53/udp    Domain Name Server
#                          Paul Mockapetris <PVM@ISI.EDU>
xns-ch           54/tcp    XNS Clearinghouse
xns-ch           54/udp    XNS Clearinghouse
#                          Susie Armstrong <Armstrong.wbst128@XEROX>
isi-gl           55/tcp    ISI Graphics Language
isi-gl           55/udp    ISI Graphics Language
xns-auth         56/tcp    XNS Authentication
xns-auth         56/udp    XNS Authentication
#                          Susie Armstrong <Armstrong.wbst128@XEROX>
                 57/tcp    any private terminal access
                 57/udp    any private terminal access
#                          Jon Postel <postel@isi.edu>
xns-mail         58/tcp    XNS Mail
xns-mail         58/udp    XNS Mail
#                          Susie Armstrong <Armstrong.wbst128@XEROX>
                 59/tcp    any private file service
                 59/udp    any private file service
#                          Jon Postel <postel@isi.edu>
                 60/tcp    Unassigned
                 60/udp    Unassigned
ni-mail          61/tcp    NI MAIL
ni-mail          61/udp    NI MAIL
#                          Steve Kille <S.Kille@isode.com>
acas             62/tcp    ACA Services
acas             62/udp    ACA Services
#                          E. Wald <ewald@via.enet.dec.com>
whois++          63/tcp    whois++
whois++          63/udp    whois++
#                          Rickard Schoultz <schoultz@sunet.se>
covia            64/tcp    Communications Integrator (CI)
covia            64/udp    Communications Integrator (CI)
#                          "Tundra" Tim Daneliuk
#                          <tundraix!tundra@clout.chi.il.us>
tacacs-ds        65/tcp    TACACS-Database Service
tacacs-ds        65/udp    TACACS-Database Service
#                          Kathy Huber <khuber@bbn.com>
sql*net          66/tcp    Oracle SQL*NET
sql*net          66/udp    Oracle SQL*NET
#                          Jack Haverty <jhaverty@ORACLE.COM>
bootps           67/tcp    Bootstrap Protocol Server
bootps           67/udp    Bootstrap Protocol Server
bootpc           68/tcp    Bootstrap Protocol Client
bootpc           68/udp    Bootstrap Protocol Client
#                          Bill Croft <Croft@SUMEX-AIM.STANFORD.EDU>
tftp             69/tcp    Trivial File Transfer
tftp             69/udp    Trivial File Transfer
#                          David Clark <ddc@LCS.MIT.EDU>
gopher           70/tcp    Gopher
gopher           70/udp    Gopher
#                          Mark McCahill <mpm@boombox.micro.umn.edu>
netrjs-1         71/tcp    Remote Job Service
netrjs-1         71/udp    Remote Job Service
netrjs-2         72/tcp    Remote Job Service
netrjs-2         72/udp    Remote Job Service
netrjs-3         73/tcp    Remote Job Service
netrjs-3         73/udp    Remote Job Service
netrjs-4         74/tcp    Remote Job Service
netrjs-4         74/udp    Remote Job Service
#                          Bob Braden <Braden@ISI.EDU>
                 75/tcp    any private dial out service
                 75/udp    any private dial out service
#                          Jon Postel <postel@isi.edu>
deos             76/tcp    Distributed External Object Store
deos             76/udp    Distributed External Object Store
#                          Robert Ullmann <ariel@world.std.com>
                 77/tcp    any private RJE service
                 77/udp    any private RJE service
#                          Jon Postel <postel@isi.edu>
vettcp           78/tcp    vettcp
vettcp           78/udp    vettcp
#                          Christopher Leong <leong@kolmod.mlo.dec.com>
finger           79/tcp    Finger
finger           79/udp    Finger
#                          David Zimmerman <dpz@RUTGERS.EDU>
http             80/tcp    World Wide Web HTTP
http             80/udp    World Wide Web HTTP
www              80/tcp    World Wide Web HTTP
www              80/udp    World Wide Web HTTP
www-http         80/tcp    World Wide Web HTTP
www-http         80/udp    World Wide Web HTTP
#                          Tim Berners-Lee <timbl@W3.org>
hosts2-ns        81/tcp    HOSTS2 Name Server
hosts2-ns        81/udp    HOSTS2 Name Server
#                          Earl Killian <EAK@MORDOR.S1.GOV>
xfer             82/tcp    XFER Utility
xfer             82/udp    XFER Utility
#                          Thomas M. Smith <tmsmith@esc.syr.ge.com>
mit-ml-dev       83/tcp    MIT ML Device
mit-ml-dev       83/udp    MIT ML Device
#                          David Reed <--none--->
ctf              84/tcp    Common Trace Facility
ctf              84/udp    Common Trace Facility
#                          Hugh Thomas <thomas@oils.enet.dec.com>
mit-ml-dev       85/tcp    MIT ML Device
mit-ml-dev       85/udp    MIT ML Device
#                          David Reed <--none--->
mfcobol          86/tcp    Micro Focus Cobol
mfcobol          86/udp    Micro Focus Cobol
#                          Simon Edwards <--none--->
                 87/tcp    any private terminal link
                 87/udp    any private terminal link
#                          Jon Postel <postel@isi.edu>
kerberos         88/tcp    Kerberos
kerberos         88/udp    Kerberos
#                          B. Clifford Neuman <bcn@isi.edu>
su-mit-tg        89/tcp    SU/MIT Telnet Gateway
su-mit-tg        89/udp    SU/MIT Telnet Gateway
#                          Mark Crispin <MRC@PANDA.COM>
########### PORT 90 also being used unofficially by Pointcast #########
dnsix            90/tcp    DNSIX Securit Attribute Token Map
dnsix            90/udp    DNSIX Securit Attribute Token Map
#                          Charles Watt <watt@sware.com>
mit-dov          91/tcp    MIT Dover Spooler
mit-dov          91/udp    MIT Dover Spooler
#                          Eliot Moss <EBM@XX.LCS.MIT.EDU>
npp              92/tcp    Network Printing Protocol
npp              92/udp    Network Printing Protocol
#                          Louis Mamakos <louie@sayshell.umd.edu>
dcp              93/tcp    Device Control Protocol
dcp              93/udp    Device Control Protocol
#                          Daniel Tappan <Tappan@BBN.COM>
objcall          94/tcp    Tivoli Object Dispatcher
objcall          94/udp    Tivoli Object Dispatcher
#                          Tom Bereiter <--none--->
supdup           95/tcp    SUPDUP
supdup           95/udp    SUPDUP
#                          Mark Crispin <MRC@PANDA.COM>
dixie            96/tcp    DIXIE Protocol Specification
dixie            96/udp    DIXIE Protocol Specification
#                Tim Howes <Tim.Howes@terminator.cc.umich.edu>
swift-rvf        97/tcp    Swift Remote Virtural File Protocol
swift-rvf        97/udp    Swift Remote Virtural File Protocol
#                          Maurice R. Turcotte
#                <mailrus!uflorida!rm1!dnmrt%rmatl@uunet.UU.NET> 
tacnews          98/tcp    TAC News
tacnews          98/udp    TAC News
#                          Jon Postel <postel@isi.edu>
metagram         99/tcp    Metagram Relay
metagram         99/udp    Metagram Relay
#                          Geoff Goodfellow <Geoff@FERNWOOD.MPK.CA.U>
newacct         100/tcp    [unauthorized use]
hostname        101/tcp    NIC Host Name Server
hostname        101/udp    NIC Host Name Server
#                          Jon Postel <postel@isi.edu>
iso-tsap        102/tcp    ISO-TSAP Class 0
iso-tsap        102/udp    ISO-TSAP Class 0
#                          Marshall Rose <mrose@dbc.mtview.ca.us>
gppitnp         103/tcp    Genesis Point-to-Point Trans Net
gppitnp         103/udp    Genesis Point-to-Point Trans Net
acr-nema        104/tcp    ACR-NEMA Digital Imag. & Comm. 300
acr-nema        104/udp    ACR-NEMA Digital Imag. & Comm. 300
#                          Patrick McNamee <--none--->
cso             105/tcp    CCSO name server protocol
cso             105/tcp    CCSO name server protocol
#                          Martin Hamilton <martin@mrrl.lut.as.uk>           
csnet-ns        105/tcp    Mailbox Name Nameserver
csnet-ns        105/udp    Mailbox Name Nameserver
#                          Marvin Solomon <solomon@CS.WISC.EDU>
3com-tsmux      106/tcp    3COM-TSMUX
3com-tsmux      106/udp    3COM-TSMUX
#                          Jeremy Siegel <jzs@NSD.3Com.COM>
rtelnet         107/tcp    Remote Telnet Service
rtelnet         107/udp    Remote Telnet Service
#                          Jon Postel <postel@isi.edu>
snagas          108/tcp    SNA Gateway Access Server
snagas          108/udp    SNA Gateway Access Server
#                          Kevin Murphy <murphy@sevens.lkg.dec.com>
pop2            109/tcp    Post Office Protocol - Version 2
pop2            109/udp    Post Office Protocol - Version 2
#                          Joyce K. Reynolds <jkrey@isi.edu>
pop3            110/tcp    Post Office Protocol - Version 3
pop3            110/udp    Post Office Protocol - Version 3
#                          Marshall Rose <mrose@dbc.mtview.ca.us>
sunrpc          111/tcp    SUN Remote Procedure Call
sunrpc          111/udp    SUN Remote Procedure Call
#                          Chuck McManis <cmcmanis@freegate.net>
mcidas          112/tcp    McIDAS Data Transmission Protocol
mcidas          112/udp    McIDAS Data Transmission Protocol
#                          Glenn Davis <davis@unidata.ucar.edu>
ident           113/tcp    
auth            113/tcp    Authentication Service
auth            113/udp    Authentication Service
#                          Mike St. Johns <stjohns@arpa.mil>
audionews       114/tcp    Audio News Multicast
audionews       114/udp    Audio News Multicast
#                          Martin Forssen <maf@dtek.chalmers.se>
sftp            115/tcp    Simple File Transfer Protocol
sftp            115/udp    Simple File Transfer Protocol
#                          Mark Lottor <MKL@nisc.sri.com>
ansanotify      116/tcp    ANSA REX Notify
ansanotify      116/udp    ANSA REX Notify
#                          Nicola J. Howarth <njh@ansa.co.uk>
uucp-path       117/tcp    UUCP Path Service
uucp-path       117/udp    UUCP Path Service
sqlserv         118/tcp    SQL Services
sqlserv         118/udp    SQL Services
#                          Larry Barnes <barnes@broke.enet.dec.com>
nntp            119/tcp    Network News Transfer Protocol
nntp            119/udp    Network News Transfer Protocol
#                          Phil Lapsley <phil@UCBARPA.BERKELEY.EDU>
cfdptkt         120/tcp    CFDPTKT
cfdptkt         120/udp    CFDPTKT
#                          John Ioannidis <ji@close.cs.columbia.ed>
erpc            121/tcp    Encore Expedited Remote Pro.Call
erpc            121/udp    Encore Expedited Remote Pro.Call
#                          Jack O'Neil <---none--->
smakynet        122/tcp    SMAKYNET
smakynet        122/udp    SMAKYNET
#                          Mike O'Dowd <odowd@ltisun8.epfl.ch>
ntp             123/tcp    Network Time Protocol
ntp             123/udp    Network Time Protocol
#                          Dave Mills <Mills@HUEY.UDEL.EDU>
ansatrader      124/tcp    ANSA REX Trader
ansatrader      124/udp    ANSA REX Trader
#                          Nicola J. Howarth <njh@ansa.co.uk>
locus-map       125/tcp    Locus PC-Interface Net Map Ser
locus-map       125/udp    Locus PC-Interface Net Map Ser
#                          Eric Peterson <lcc.eric@SEAS.UCLA.EDU>
unitary         126/tcp    Unisys Unitary Login
unitary         126/udp    Unisys Unitary Login
#                          <feil@kronos.nisd.cam.unisys.com>
locus-con       127/tcp    Locus PC-Interface Conn Server
locus-con       127/udp    Locus PC-Interface Conn Server
#                          Eric Peterson <lcc.eric@SEAS.UCLA.EDU>
gss-xlicen      128/tcp    GSS X License Verification
gss-xlicen      128/udp    GSS X License Verification
#                          John Light <johnl@gssc.gss.com>
pwdgen          129/tcp    Password Generator Protocol
pwdgen          129/udp    Password Generator Protocol
#               Frank J. Wacho <WANCHO@WSMR-SIMTEL20.ARMY.MIL>
cisco-fna       130/tcp    cisco FNATIVE
cisco-fna       130/udp    cisco FNATIVE
cisco-tna       131/tcp    cisco TNATIVE
cisco-tna       131/udp    cisco TNATIVE
cisco-sys       132/tcp    cisco SYSMAINT
cisco-sys       132/udp    cisco SYSMAINT
statsrv         133/tcp    Statistics Service
statsrv         133/udp    Statistics Service
#                          Dave Mills <Mills@HUEY.UDEL.EDU>
ingres-net      134/tcp    INGRES-NET Service
ingres-net      134/udp    INGRES-NET Service
#                          Mike Berrow <---none--->
epmap           135/tcp    DCE endpoint resolution
epmap           135/udp    DCE endpoint resolution
#                          Joe Pato <pato@apollo.hp.com>
profile         136/tcp    PROFILE Naming System           
profile         136/udp    PROFILE Naming System           
#                          Larry Peterson <llp@ARIZONA.EDU>
netbios-ns      137/tcp    NETBIOS Name Service    
netbios-ns      137/udp    NETBIOS Name Service    
netbios-dgm     138/tcp    NETBIOS Datagram Service
netbios-dgm     138/udp    NETBIOS Datagram Service
netbios-ssn     139/tcp    NETBIOS Session Service
netbios-ssn     139/udp    NETBIOS Session Service
#                          Jon Postel <postel@isi.edu>
emfis-data      140/tcp    EMFIS Data Service
emfis-data      140/udp    EMFIS Data Service
emfis-cntl      141/tcp    EMFIS Control Service
emfis-cntl      141/udp    EMFIS Control Service
#                          Gerd Beling <GBELING@ISI.EDU>
bl-idm          142/tcp    Britton-Lee IDM           
bl-idm          142/udp    Britton-Lee IDM           
#                          Susie Snitzer <---none--->
imap            143/tcp    Internet Message Access Protocol
imap            143/udp    Internet Message Access Protocol
#                          Mark Crispin <MRC@CAC.Washington.EDU>
#		144	   Unassigned
uaac            145/tcp    UAAC Protocol             
uaac            145/udp    UAAC Protocol             
#               David A. Gomberg <gomberg@GATEWAY.MITRE.ORG>
iso-tp0         146/tcp    ISO-IP0
iso-tp0         146/udp    ISO-IP0
iso-ip          147/tcp    ISO-IP
iso-ip          147/udp    ISO-IP
#                          Marshall Rose <mrose@dbc.mtview.ca.us>
jargon          148/tcp    Jargon
jargon          148/udp    Jargon
#			   Bill Weinman <wew@bearnet.com>
aed-512         149/tcp    AED 512 Emulation Service           
aed-512         149/udp    AED 512 Emulation Service           
#               Albert G. Broscius <broscius@DSL.CIS.UPENN.EDU>
sql-net         150/tcp    SQL-NET                    
sql-net         150/udp    SQL-NET                    
#                          Martin Picard <<---none--->
hems            151/tcp    HEMS                              
hems            151/udp    HEMS                              
bftp            152/tcp    Background File Transfer Program 
bftp            152/udp    Background File Transfer Program 
#                          Annette DeSchon <DESCHON@ISI.EDU>
sgmp            153/tcp    SGMP                    
sgmp            153/udp    SGMP                    
#                          Marty Schoffstahl <schoff@NISC.NYSER.NET>
netsc-prod      154/tcp    NETSC                             
netsc-prod      154/udp    NETSC                             
netsc-dev       155/tcp    NETSC                             
netsc-dev       155/udp    NETSC                             
#                          Sergio Heker <heker@JVNCC.CSC.ORG>
sqlsrv          156/tcp    SQL Service                  
sqlsrv          156/udp    SQL Service                  
#                          Craig Rogers <Rogers@ISI.EDU>
knet-cmp        157/tcp    KNET/VM Command/Message Protocol
knet-cmp        157/udp    KNET/VM Command/Message Protocol
#                          Gary S. Malkin <GMALKIN@XYLOGICS.COM>
pcmail-srv      158/tcp    PCMail Server                 
pcmail-srv      158/udp    PCMail Server                 
#                          Mark L. Lambert <markl@PTT.LCS.MIT.EDU>
nss-routing     159/tcp    NSS-Routing                  
nss-routing     159/udp    NSS-Routing                  
#                          Yakov Rekhter <Yakov@IBM.COM>
sgmp-traps      160/tcp    SGMP-TRAPS                
sgmp-traps      160/udp    SGMP-TRAPS                
#                          Marty Schoffstahl <schoff@NISC.NYSER.NET>
snmp            161/tcp    SNMP
snmp            161/udp    SNMP
snmptrap        162/tcp    SNMPTRAP
snmptrap        162/udp    SNMPTRAP
#                          Marshall Rose <mrose@dbc.mtview.ca.us>
cmip-man        163/tcp    CMIP/TCP Manager   
cmip-man        163/udp    CMIP/TCP Manager   
cmip-agent      164/tcp    CMIP/TCP Agent     
smip-agent      164/udp    CMIP/TCP Agent     
#                          Amatzia Ben-Artzi <---none--->
xns-courier     165/tcp    Xerox                          
xns-courier     165/udp    Xerox                          
#                          Susie Armstrong <Armstrong.wbst128@XEROX.COM>
s-net           166/tcp    Sirius Systems          
s-net           166/udp    Sirius Systems          
#                          Brian Lloyd <brian@lloyd.com>
namp            167/tcp    NAMP                    
namp            167/udp    NAMP                    
#                          Marty Schoffstahl <schoff@NISC.NYSER.NET>
rsvd            168/tcp    RSVD                              
rsvd            168/udp    RSVD                              
#                          Neil Todd <mcvax!ist.co.uk!neil@UUNET.UU.NET>
send            169/tcp    SEND                              
send            169/udp    SEND                              
#               William D. Wisner <wisner@HAYES.FAI.ALASKA.EDU>
print-srv       170/tcp    Network PostScript              
print-srv       170/udp    Network PostScript              
#                          Brian Reid <reid@DECWRL.DEC.COM>
multiplex       171/tcp    Network Innovations Multiplex
multiplex       171/udp    Network Innovations Multiplex
cl/1            172/tcp    Network Innovations CL/1     
cl/1            172/udp    Network Innovations CL/1     
#                          Kevin DeVault <<---none--->
xyplex-mux      173/tcp    Xyplex                          
xyplex-mux      173/udp    Xyplex                          
#                          Bob Stewart <STEWART@XYPLEX.COM>
mailq           174/tcp    MAILQ                               
mailq           174/udp    MAILQ                               
#                          Rayan Zachariassen <rayan@AI.TORONTO.EDU>
vmnet           175/tcp    VMNET                                
vmnet           175/udp    VMNET  
#                          Christopher Tengi <tengi@Princeton.EDU>
genrad-mux      176/tcp    GENRAD-MUX                      
genrad-mux      176/udp    GENRAD-MUX                      
#                          Ron Thornton <thornton@qm7501.genrad.com>
xdmcp           177/tcp    X Display Manager Control Protocol  
xdmcp           177/udp    X Display Manager Control Protocol  
#                          Robert W. Scheifler <RWS@XX.LCS.MIT.EDU>
nextstep        178/tcp    NextStep Window Server     
NextStep        178/udp    NextStep Window Server     
#                          Leo Hourvitz <leo@NEXT.COM>
bgp             179/tcp    Border Gateway Protocol             
bgp             179/udp    Border Gateway Protocol             
#                          Kirk Lougheed <LOUGHEED@MATHOM.CISCO.COM>
ris             180/tcp    Intergraph                         
ris             180/udp    Intergraph                         
#                          Dave Buehmann <ingr!daveb@UUNET.UU.NET>
unify           181/tcp    Unify                  
unify           181/udp    Unify                  
#                          Vinod Singh <--none--->
audit           182/tcp    Unisys Audit SITP                  
audit           182/udp    Unisys Audit SITP                  
#                          Gil Greenbaum <gcole@nisd.cam.unisys.com>
ocbinder        183/tcp    OCBinder                     
ocbinder        183/udp    OCBinder                     
ocserver        184/tcp    OCServer                     
ocserver        184/udp    OCServer                     
#                          Jerrilynn Okamura <--none--->
remote-kis      185/tcp    Remote-KIS                        
remote-kis      185/udp    Remote-KIS                        
kis             186/tcp    KIS Protocol                      
kis             186/udp    KIS Protocol                      
#                          Ralph Droms <rdroms@NRI.RESTON.VA.US>
aci             187/tcp    Application Communication Interface
aci             187/udp    Application Communication Interface
#                          Rick Carlos <rick.ticipa.csc.ti.com>
mumps           188/tcp    Plus Five's MUMPS            
mumps           188/udp    Plus Five's MUMPS            
#                          Hokey Stenn <hokey@PLUS5.COM>
qft             189/tcp    Queued File Transport        
qft             189/udp    Queued File Transport        
#                          Wayne Schroeder <schroeder@SDS.SDSC.EDU>
gacp            190/tcp    Gateway Access Control Protocol
gacp            190/udp    Gateway Access Control Protocol
#                          C. Philip Wood <cpw@LANL.GOV>
prospero        191/tcp    Prospero Directory Service      
prospero        191/udp    Prospero Directory Service      
#                          B. Clifford Neuman <bcn@isi.edu>
osu-nms         192/tcp    OSU Network Monitoring System       
osu-nms         192/udp    OSU Network Monitoring System       
#               Doug Karl <KARL-D@OSU-20.IRCC.OHIO-STATE.EDU>
srmp            193/tcp    Spider Remote Monitoring Protocol 
srmp            193/udp    Spider Remote Monitoring Protocol 
#                          Ted J. Socolofsky <Teds@SPIDER.CO.UK>
irc             194/tcp    Internet Relay Chat Protocol        
irc             194/udp    Internet Relay Chat Protocol        
#                          Jarkko Oikarinen <jto@TOLSUN.OULU.FI>
dn6-nlm-aud     195/tcp    DNSIX Network Level Module Audit    
dn6-nlm-aud     195/udp    DNSIX Network Level Module Audit    
dn6-smm-red     196/tcp    DNSIX Session Mgt Module Audit Redir
dn6-smm-red     196/udp    DNSIX Session Mgt Module Audit Redir
#                          Lawrence Lebahn <DIA3@PAXRV-NES.NAVY.MIL>
dls             197/tcp    Directory Location Service        
dls             197/udp    Directory Location Service        
dls-mon         198/tcp    Directory Location Service Monitor
dls-mon         198/udp    Directory Location Service Monitor
#                          Scott Bellew <smb@cs.purdue.edu>
smux            199/tcp    SMUX
smux            199/udp    SMUX
#                          Marshall Rose <mrose@dbc.mtview.ca.us>
src             200/tcp    IBM System Resource Controller
src             200/udp    IBM System Resource Controller
#                          Gerald McBrearty <---none--->
at-rtmp         201/tcp    AppleTalk Routing Maintenance       
at-rtmp         201/udp    AppleTalk Routing Maintenance       
at-nbp          202/tcp    AppleTalk Name Binding              
at-nbp          202/udp    AppleTalk Name Binding              
at-3            203/tcp    AppleTalk Unused                    
at-3            203/udp    AppleTalk Unused                    
at-echo         204/tcp    AppleTalk Echo                      
at-echo         204/udp    AppleTalk Echo                      
at-5            205/tcp    AppleTalk Unused                    
at-5            205/udp    AppleTalk Unused                    
at-zis          206/tcp    AppleTalk Zone Information          
at-zis          206/udp    AppleTalk Zone Information          
at-7            207/tcp    AppleTalk Unused                    
at-7            207/udp    AppleTalk Unused                    
at-8            208/tcp    AppleTalk Unused                    
at-8            208/udp    AppleTalk Unused                    
#                          Rob Chandhok <chandhok@gnome.cs.cmu.edu>
qmtp            209/tcp    The Quick Mail Transfer Protocol
qmtp            209/udp    The Quick Mail Transfer Protocol
#               Dan Bernstein <djb@silverton.berkeley.edu>
z39.50          210/tcp    ANSI Z39.50
z39.50          210/udp    ANSI Z39.50
#                          Mark Needleman
#                         <mhnur%uccmvsa.bitnet@cornell.cit.cornell.edu> 
914c/g          211/tcp    Texas Instruments 914C/G Terminal
914c/g          211/udp    Texas Instruments 914C/G Terminal
#                          Bill Harrell <---none--->
anet            212/tcp    ATEXSSTR   
anet            212/udp    ATEXSSTR   
#                          Jim Taylor <taylor@heart.epps.kodak.com>
ipx             213/tcp    IPX         	                      
ipx             213/udp    IPX                                
#                          Don Provan <donp@xlnvax.novell.com>
vmpwscs         214/tcp    VM PWSCS                         
vmpwscs         214/udp    VM PWSCS                         
#                          Dan Shia <dset!shia@uunet.UU.NET>
softpc          215/tcp    Insignia Solutions
softpc          215/udp    Insignia Solutions
#                          Martyn Thomas <---none--->
CAIlic          216/tcp    Computer Associates Int'l License Server
CAIlic          216/udp    Computer Associates Int'l License Server
#                          Chuck Spitz <spich04@cai.com>
dbase           217/tcp    dBASE Unix
dbase           217/udp    dBASE Unix
#                          Don Gibson
#            <sequent!aero!twinsun!ashtate.A-T.COM!dong@uunet.UU.NET> 
mpp             218/tcp    Netix Message Posting Protocol
mpp             218/udp    Netix Message Posting Protocol
#                          Shannon Yeh <yeh@netix.com>
uarps           219/tcp    Unisys ARPs               
uarps           219/udp    Unisys ARPs               
#                          Ashok Marwaha <---none--->
imap3           220/tcp    Interactive Mail Access Protocol v3
imap3           220/udp    Interactive Mail Access Protocol v3
#                          James Rice <RICE@SUMEX-AIM.STANFORD.EDU>
fln-spx         221/tcp    Berkeley rlogind with SPX auth   
fln-spx         221/udp    Berkeley rlogind with SPX auth   
rsh-spx         222/tcp    Berkeley rshd with SPX auth      
rsh-spx         222/udp    Berkeley rshd with SPX auth      
cdc             223/tcp    Certificate Distribution Center  
cdc             223/udp    Certificate Distribution Center  
#               Kannan Alagappan <kannan@sejour.enet.dec.com>
#               224-241    Reserved
#                          Jon Postel <postel@isi.edu>
direct          242/tcp    Direct
direct          242/udp    Direct
#                          Herb Sutter <HerbS@cntc.com>
sur-meas        243/tcp    Survey Measurement          
sur-meas        243/udp    Survey Measurement          
#                          Dave Clark <ddc@LCS.MIT.EDU>
dayna           244/tcp    Dayna
dayna           244/udp    Dayna
#			   Steve Bateman <SBATEMAN@dayna.com>
link            245/tcp    LINK
link            245/udp    LINK
dsp3270         246/tcp    Display Systems Protocol        
dsp3270         246/udp    Display Systems Protocol        
#                          Weldon J. Showalter <Gamma@MINTAKA.DCA.MIL>
subntbcst_tftp  247/tcp    SUBNTBCST_TFTP
subntbcst_tftp  247/udp    SUBNTBCST_TFTP
#			   John Fake <fake@us.ibm.com>
bhfhs		248/tcp    bhfhs
bhfhs		248/udp    bhfhs
#			   John Kelly <johnk@bellhow.com>
#               249-255    Reserved
#                          Jon Postel <postel@isi.edu>
rap             256/tcp    RAP
rap             256/udp    RAP
#                          J.S. Greenfield <greeny@raleigh.ibm.com>
set             257/tcp    Secure Electronic Transaction
set             257/udp    Secure Electronic Transaction
#                          Donald Eastlake <dee@cybercash.com>
yak-chat        258/tcp    Yak Winsock Personal Chat
yak-chat        258/udp    Yak Winsock Personal Chat
#                          Brian Bandy <brian@yakchat.com>
esro-gen        259/tcp    Efficient Short Remote Operations
esro-gen        259/udp    Efficient Short Remote Operations
#                          Mohsen Banan <mohsen@rostam.neda.com>
openport        260/tcp    Openport
openport        260/udp    Openport
#                          John Marland <jmarland@dean.openport.com>
nsiiops 	261/tcp    IIOP Name Service over TLS/SSL
nsiiops		261/udp    IIOP Name Service over TLS/SSL
#                          Jeff Stewart <jstewart@netscape.com>
arcisdms	262/tcp    Arcisdms
arcisdms	262/udp	   Arcisdms
#			   Russell Crook (rmc@sni.ca>
hdap		263/tcp    HDAP
hdap		263/udp    HDAP
#			   Troy Gau <troy@zyxel.com>
#               264-279    Unassigned
http-mgmt       280/tcp    http-mgmt
http-mgmt       280/udp    http-mgmt
#                          Adrian Pell
#                          <PELL_ADRIAN/HP-UnitedKingdom_om6@hplb.hpl.hp.com>
personal-link   281/tcp	   Personal Link
personal-link	281/udp    Personal Link
#			   Dan Cummings <doc@cnr.com>
cableport-ax	282/tcp    Cable Port A/X
cableport-ax	282/udp    Cable Port A/X
#			   Craig Langfahl <Craig_J_Langfahl@ccm.ch.intel.com>
#               283-308    Unassigned
entrusttime     309/tcp    EntrustTime    
entrusttime     309/udp    EntrustTime    
#                          Peter Whittaker <pww@entrust.com>
bhmds		310/tcp    bhmds
bhmds 		310/udp    bhmds
#			   John Kelly <johnk@bellhow.com>
asip-webadmin	311/tcp    AppleShare IP WebAdmin
asip-webadmin	311/udp    AppleShare IP WebAdmin
#			   Ann Huang <annhuang@apple.com>
vslmp		312/tcp    VSLMP
vslmp		312/udp    VSLMP
#			   Gerben Wierda <Gerben_Wierda@RnA.nl>
netfusion	313/tcp    Net Fusion
netfusion	313/udp	   Net Fusion
#			   Karl Rousseau <kr@netfusion.co.uk>
opalis-robot	314/tcp    Opalis Robot
opalis-robot	314/udp    Opalis Robot
#			   Laurent Domenech, Opalis <laurent@opalis.com>
dpsi		315/tcp    DPSI
dpsi		315/udp    DPSI
#			   Tony Scamurra <Tony@DesktopPaging.com>
decauth		316/tcp    decAuth
decauth		316/udp    decAuth
#			   Michael Agishtein <misha@unx.dec.com>
zannet		317/tcp    Zannet
zannet		317/udp    Zannet
#			   Zan Oliphant <zan@accessone.com>
#               318-343    Unassigned
pdap            344/tcp    Prospero Data Access Protocol
pdap            344/udp    Prospero Data Access Protocol
#                          B. Clifford Neuman <bcn@isi.edu>
pawserv         345/tcp    Perf Analysis Workbench
pawserv         345/udp    Perf Analysis Workbench
zserv           346/tcp    Zebra server
zserv           346/udp    Zebra server
fatserv         347/tcp    Fatmen Server
fatserv         347/udp    Fatmen Server
csi-sgwp        348/tcp    Cabletron Management Protocol
csi-sgwp        348/udp    Cabletron Management Protocol
mftp            349/tcp    mftp
mftp            349/udp    mftp
#                          Dave Feinleib <davefe@microsoft.com>
matip-type-a    350/tcp    MATIP Type A
matip-type-a	350/udp    MATIP Type A
matip-type-b    351/tcp    MATIP Type B
matip-type-b    351/udp    MATIP Type B
#			   Alain Robert <arobert@par.sita.int>
# The following entry records an unassigned but widespread use
bhoetty		351/tcp	   bhoetty (added 5/21/97)
bhoetty		351/udp    bhoetty
#			   John Kelly <johnk@bellhow.com>
dtag-ste-sb	352/tcp	   DTAG (assigned long ago)
dtag-ste-sb	352/udp	   DTAG
#			   Ruediger Wald <wald@ez-darmstadt.telekom.de>
# The following entry records an unassigned but widespread use
bhoedap4	352/tcp    bhoedap4 (added 5/21/97)
bhoedap4	352/udp    bhoedap4
#			   John Kelly <johnk@bellhow.com>
ndsauth		353/tcp    NDSAUTH
ndsauth		353/udp    NDSAUTH
#			   Jayakumar Ramalingam <jayakumar@novell.com>
bh611		354/tcp	   bh611
bh611		354/udp    bh611
#			   John Kelly <johnk@bellhow.com>
datex-asn	355/tcp	   DATEX-ASN
datex-asn	355/udp    DATEX-ASN
#			   Kenneth Vaughn <kvaughn@mail.viggen.com>
cloanto-net-1	356/tcp    Cloanto Net 1
cloanto-net-1	356/udp    Cloanto Net 1
#			   Michael Battilana <mcb@cloanto.com>
bhevent		357/tcp	   bhevent
bhevent		357/udp    bhevent
#			   John Kelly <johnk@bellhow.com>
shrinkwrap	358/tcp    Shrinkwrap
shrinkwrap	358/udp    Shrinkwrap
#			   Bill Simpson <wsimpson@greendragon.com>
tenebris_nts	359/tcp    Tenebris Network Trace Service
tenebris_nts	359/udp    Tenebris Network Trace Service
#			   Eric Jacksch <jacksch@tenebris.ca>
scoi2odialog	360/tcp    scoi2odialog
scoi2odialog	360/udp    scoi2odialog
#			   Keith Petley <keithp@sco.COM>
semantix	361/tcp    Semantix
semantix	361/udp    Semantix
#		   	   Semantix <xsSupport@semantix.com>
srssend		362/tcp    SRS Send
srssend		362/udp    SRS Send
#			   Curt Mayer <curt@emergent.com>
rsvp_tunnel	363/tcp    RSVP Tunnel
rsvp_tunnel	363/udp    RSVP Tunnel
#			   Andreas Terzis <terzis@cs.ucla.edu>
#		364-370    Unassigned
clearcase       371/tcp    Clearcase
clearcase       371/udp    Clearcase
#                          Dave LeBlang <leglang@atria.com>
ulistproc       372/tcp    ListProcessor
ulistproc       372/udp    ListProcessor
#                          Anastasios Kotsikonas <tasos@cs.bu.edu>
legent-1        373/tcp    Legent Corporation
legent-1        373/udp    Legent Corporation
legent-2        374/tcp    Legent Corporation
legent-2        374/udp    Legent Corporation
#                          Keith Boyce <---none--->
hassle          375/tcp    Hassle
hassle          375/udp    Hassle
#                          Reinhard Doelz <doelz@comp.bioz.unibas.ch>
nip             376/tcp    Amiga Envoy Network Inquiry Proto   
nip             376/udp    Amiga Envoy Network Inquiry Proto
#                          Heinz Wrobel <heinz@iam.com>
#                          Dale L. Larson <dale@iam.com>
tnETOS          377/tcp    NEC Corporation
tnETOS          377/udp    NEC Corporation
dsETOS          378/tcp    NEC Corporation
dsETOS          378/udp    NEC Corporation
#                          Tomoo Fujita <tf@arc.bs1.fc.nec.co.jp>
is99c           379/tcp    TIA/EIA/IS-99 modem client
is99c           379/udp    TIA/EIA/IS-99 modem client
is99s           380/tcp    TIA/EIA/IS-99 modem server
is99s           380/udp    TIA/EIA/IS-99 modem server
#                          Frank Quick <fquick@qualcomm.com>
hp-collector    381/tcp    hp performance data collector
hp-collector    381/udp    hp performance data collector
hp-managed-node 382/tcp    hp performance data managed node
hp-managed-node 382/udp    hp performance data managed node
hp-alarm-mgr    383/tcp    hp performance data alarm manager
hp-alarm-mgr    383/udp    hp performance data alarm manager
#                          Frank Blakely <frankb@hpptc16.rose.hp.com>
arns            384/tcp    A Remote Network Server System
arns            384/udp    A Remote Network Server System
#                          David Hornsby <djh@munnari.OZ.AU>
ibm-app         385/tcp    IBM Application
ibm-app         385/udp    IBM Application
#                          Lisa Tomita <---none--->
asa             386/tcp    ASA Message Router Object Def.
asa             386/udp    ASA Message Router Object Def.
#                          Steve Laitinen <laitinen@brutus.aa.ab.com>
aurp            387/tcp    Appletalk Update-Based Routing Pro.
aurp            387/udp    Appletalk Update-Based Routing Pro.
#                          Chris Ranch <cranch@novell.com>
unidata-ldm     388/tcp    Unidata LDM Version 4
unidata-ldm     388/udp    Unidata LDM Version 4
#                          Glenn Davis <davis@unidata.ucar.edu>
ldap            389/tcp    Lightweight Directory Access Protocol
ldap            389/udp    Lightweight Directory Access Protocol
#                          Tim Howes <Tim.Howes@terminator.cc.umich.edu>
uis             390/tcp    UIS
uis             390/udp    UIS
#                          Ed Barron <---none---> 
synotics-relay  391/tcp    SynOptics SNMP Relay Port
synotics-relay  391/udp    SynOptics SNMP Relay Port
synotics-broker 392/tcp    SynOptics Port Broker Port
synotics-broker 392/udp    SynOptics Port Broker Port
#                          Illan Raab <iraab@synoptics.com>
dis             393/tcp    Data Interpretation System
dis             393/udp    Data Interpretation System
#                          Paul Stevens <pstevens@chinacat.Metaphor.COM>
embl-ndt        394/tcp    EMBL Nucleic Data Transfer
embl-ndt        394/udp    EMBL Nucleic Data Transfer
#                          Peter Gad <peter@bmc.uu.se>
netcp           395/tcp    NETscout Control Protocol
netcp           395/udp    NETscout Control Protocol
#                          Anil Singhal <---none--->
netware-ip      396/tcp    Novell Netware over IP
netware-ip      396/udp    Novell Netware over IP
mptn            397/tcp    Multi Protocol Trans. Net.
mptn            397/udp    Multi Protocol Trans. Net.
#                          Soumitra Sarkar <sarkar@vnet.ibm.com>
kryptolan       398/tcp    Kryptolan
kryptolan       398/udp    Kryptolan
#                          Peter de Laval <pdl@sectra.se>
iso-tsap-c2     399/tcp    ISO Transport Class 2 Non-Control over TCP
iso-tsap-c2     399/udp    ISO Transport Class 2 Non-Control over TCP
#               Yanick Pouffary <pouffary@taec.enet.dec.com>
work-sol        400/tcp    Workstation Solutions
work-sol        400/udp    Workstation Solutions
#                          Jim Ward <jimw@worksta.com>
ups             401/tcp    Uninterruptible Power Supply
ups             401/udp    Uninterruptible Power Supply
#                          Charles Bennett <chuck@benatong.com>
genie           402/tcp    Genie Protocol
genie           402/udp    Genie Protocol
#                          Mark Hankin <---none--->
decap           403/tcp    decap
decap           403/udp    decap
nced            404/tcp    nced
nced            404/udp    nced
ncld            405/tcp    ncld
ncld            405/udp    ncld
#                          Richard Jones <---none--->
imsp            406/tcp    Interactive Mail Support Protocol
imsp            406/udp    Interactive Mail Support Protocol
#                          John Myers <jgm+@cmu.edu>
timbuktu        407/tcp    Timbuktu
timbuktu        407/udp    Timbuktu
#                          Marc Epard <marc@waygate.farallon.com>
prm-sm          408/tcp    Prospero Resource Manager Sys. Man.
prm-sm          408/udp    Prospero Resource Manager Sys. Man.
prm-nm          409/tcp    Prospero Resource Manager Node Man.
prm-nm          409/udp    Prospero Resource Manager Node Man.
#                          B. Clifford Neuman <bcn@isi.edu>
decladebug      410/tcp    DECLadebug Remote Debug Protocol
decladebug      410/udp    DECLadebug Remote Debug Protocol
#                          Anthony Berent <anthony.berent@reo.mts.dec.com>
rmt             411/tcp    Remote MT Protocol
rmt             411/udp    Remote MT Protocol
#                          Peter Eriksson <pen@lysator.liu.se>
synoptics-trap  412/tcp    Trap Convention Port
synoptics-trap  412/udp    Trap Convention Port
#                          Illan Raab <iraab@synoptics.com>
smsp            413/tcp    SMSP
smsp            413/udp    SMSP
infoseek        414/tcp    InfoSeek
infoseek        414/udp    InfoSeek
#                          Steve Kirsch <stk@infoseek.com>
bnet            415/tcp    BNet
bnet            415/udp    BNet
#                          Jim Mertz <JMertz+RV09@rvdc.unisys.com>
silverplatter   416/tcp    Silverplatter
silverplatter   416/udp    Silverplatter
#                          Peter Ciuffetti <petec@silverplatter.com>
onmux           417/tcp    Onmux
onmux           417/udp    Onmux
#                          Stephen Hanna <hanna@world.std.com>
hyper-g         418/tcp    Hyper-G
hyper-g         418/udp    Hyper-G
#                          Frank Kappe <fkappe@iicm.tu-graz.ac.at>
ariel1          419/tcp    Ariel
ariel1          419/udp    Ariel
#                          Jonathan Lavigne <BL.JPL@RLG.Stanford.EDU>
smpte           420/tcp    SMPTE
smpte           420/udp    SMPTE
#                          Si Becker <71362.22@CompuServe.COM>
ariel2          421/tcp    Ariel
ariel2          421/udp    Ariel
ariel3          422/tcp    Ariel
ariel3          422/udp    Ariel
#                          Jonathan Lavigne  <BL.JPL@RLG.Stanford.EDU>
opc-job-start   423/tcp    IBM Operations Planning and Control Start
opc-job-start   423/udp    IBM Operations Planning and Control Start
opc-job-track   424/tcp    IBM Operations Planning and Control Track
opc-job-track   424/udp    IBM Operations Planning and Control Track
#                          Conny Larsson  <cocke@VNET.IBM.COM>
icad-el         425/tcp    ICAD
icad-el         425/udp    ICAD
#		           Larry Stone	<lcs@icad.com>
smartsdp        426/tcp    smartsdp
smartsdp        426/udp    smartsdp
#                          Alexander Dupuy <dupuy@smarts.com>
svrloc          427/tcp    Server Location
svrloc          427/udp    Server Location
#                          <veizades@ftp.com>
ocs_cmu         428/tcp    OCS_CMU
ocs_cmu         428/udp    OCS_CMU
ocs_amu         429/tcp    OCS_AMU
ocs_amu         429/udp    OCS_AMU
#                          Florence Wyman <wyman@peabody.plk.af.mil>
utmpsd          430/tcp    UTMPSD
utmpsd          430/udp    UTMPSD
utmpcd          431/tcp    UTMPCD
utmpcd          431/udp    UTMPCD
iasd            432/tcp    IASD  
iasd            432/udp    IASD  
#                          Nir Baroz <nbaroz@encore.com>
nnsp            433/tcp    NNSP
nnsp            433/udp    NNSP
#                          Rob Robertson <rob@gangrene.berkeley.edu>
mobileip-agent  434/tcp    MobileIP-Agent
mobileip-agent  434/udp    MobileIP-Agent
mobilip-mn      435/tcp    MobilIP-MN
mobilip-mn      435/udp    MobilIP-MN
#                          Kannan Alagappan <kannan@sejour.lkg.dec.com>
dna-cml         436/tcp    DNA-CML   
dna-cml         436/udp    DNA-CML   
#                          Dan Flowers <flowers@smaug.lkg.dec.com>
comscm          437/tcp    comscm
comscm          437/udp    comscm
#                          Jim Teague <teague@zso.dec.com>
dsfgw           438/tcp    dsfgw
dsfgw           438/udp    dsfgw
#                          Andy McKeen <mckeen@osf.org>
dasp            439/tcp    dasp      Thomas Obermair
dasp            439/udp    dasp      tommy@inlab.m.eunet.de
#                          Thomas Obermair <tommy@inlab.m.eunet.de>
sgcp            440/tcp    sgcp      
sgcp            440/udp    sgcp      
#                          Marshall Rose <mrose@dbc.mtview.ca.us>
decvms-sysmgt   441/tcp    decvms-sysmgt
decvms-sysmgt   441/udp    decvms-sysmgt
#                          Lee Barton <barton@star.enet.dec.com>
cvc_hostd       442/tcp    cvc_hostd
cvc_hostd       442/udp    cvc_hostd
#                          Bill Davidson <billd@equalizer.cray.com>
https           443/tcp    http protocol over TLS/SSL
https           443/udp    http protocol over TLS/SSL
#                          Kipp E.B. Hickman <kipp@mcom.com>
snpp            444/tcp    Simple Network Paging Protocol
snpp            444/udp    Simple Network Paging Protocol
#                          [RFC1568]
microsoft-ds    445/tcp    Microsoft-DS
microsoft-ds    445/udp    Microsoft-DS
#                          Pradeep Bahl <pradeepb@microsoft.com>
ddm-rdb         446/tcp    DDM-RDB
ddm-rdb         446/udp    DDM-RDB
ddm-dfm         447/tcp    DDM-RFM
ddm-dfm         447/udp    DDM-RFM
ddm-byte        448/tcp    DDM-BYTE
ddm-byte        448/udp    DDM-BYTE
#                          Jan David Fisher <jdfisher@VNET.IBM.COM>
as-servermap    449/tcp    AS Server Mapper
as-servermap    449/udp    AS Server Mapper
#                          Barbara Foss <BGFOSS@rchvmv.vnet.ibm.com>
tserver         450/tcp    TServer
tserver         450/udp    TServer
#                          Harvey S. Schultz <hss@mtgzfs3.mt.att.com>
sfs-smp-net     451/tcp    Cray Network Semaphore server
sfs-smp-net     451/udp    Cray Network Semaphore server
sfs-config	452/tcp    Cray SFS config server
sfs-config	452/udp    Cray SFS config server
#                          Walter Poxon <wdp@ironwood.cray.com>
creativeserver  453/tcp    CreativeServer
creativeserver  453/udp    CreativeServer
contentserver   454/tcp    ContentServer
contentserver   454/udp    ContentServer
creativepartnr  455/tcp    CreativePartnr
creativepartnr  455/udp    CreativePartnr
#                          Jesus Ortiz <jesus_ortiz@emotion.com>
macon-tcp       456/tcp    macon-tcp
macon-udp       456/udp    macon-udp
#                          Yoshinobu Inoue
#                          <shin@hodaka.mfd.cs.fujitsu.co.jp>
scohelp         457/tcp    scohelp
scohelp         457/udp    scohelp
#                          Faith Zack <faithz@sco.com>
appleqtc        458/tcp    apple quick time
appleqtc        458/udp    apple quick time
#           Murali Ranganathan <murali_ranganathan@quickmail.apple.com>
ampr-rcmd       459/tcp    ampr-rcmd              
ampr-rcmd       459/udp    ampr-rcmd              
#                          Rob Janssen <rob@sys3.pe1chl.ampr.org>
skronk          460/tcp    skronk
skronk          460/udp    skronk
#                          Henry Strickland <strick@yak.net>
datasurfsrv     461/tcp    DataRampSrv
datasurfsrv     461/udp    DataRampSrv
datasurfsrvsec  462/tcp    DataRampSrvSec
datasurfsrvsec  462/udp    DataRampSrvSec
#                          Diane Downie <downie@jibe.MV.COM>
alpes           463/tcp    alpes
alpes           463/udp    alpes
#                          Alain Durand <Alain.Durand@imag.fr>
kpasswd         464/tcp    kpasswd
kpasswd         464/udp    kpasswd
#                          Theodore Ts'o <tytso@MIT.EDU>
smtps           465/tcp    smtp protocol over TLS/SSL (was ssmtp)
smtps           465/udp    smtp protocol over TLS/SSL (was ssmtp)
#                          John Hemming <JohnHemming@Mkn.co.uk>
digital-vrc     466/tcp    digital-vrc
digital-vrc     466/udp    digital-vrc
#                          Peter Higginson <higginson@mail.dec.com>
mylex-mapd      467/tcp    mylex-mapd
mylex-mapd      467/udp    mylex-mapd
#                          Gary Lewis <GaryL@hq.mylex.com>
photuris        468/tcp    proturis
photuris        468/udp    proturis
#                          Bill Simpson <Bill.Simpson@um.cc.umich.edu>
rcp             469/tcp    Radio Control Protocol
rcp             469/udp    Radio Control Protocol
#                          Jim Jennings +1-708-538-7241
scx-proxy       470/tcp    scx-proxy
scx-proxy       470/udp    scx-proxy
#                          Scott Narveson <sjn@cray.com>
mondex          471/tcp    Mondex
mondex          471/udp    Mondex
#                          Bill Reding <redingb@nwdt.natwest.co.uk>
ljk-login       472/tcp    ljk-login
ljk-login       472/udp    ljk-login
#                          LJK Software, Cambridge, Massachusetts
#                          <support@ljk.com>
hybrid-pop      473/tcp    hybrid-pop
hybrid-pop      473/udp    hybrid-pop
#                          Rami Rubin <rami@hybrid.com>
tn-tl-w1        474/tcp    tn-tl-w1
tn-tl-w2        474/udp    tn-tl-w2
#                          Ed Kress <eskress@thinknet.com>
tcpnethaspsrv   475/tcp    tcpnethaspsrv
tcpnethaspsrv   475/tcp    tcpnethaspsrv
#                          Charlie Hava <charlie@aladdin.co.il>
tn-tl-fd1       476/tcp    tn-tl-fd1
tn-tl-fd1       476/udp    tn-tl-fd1
#                          Ed Kress <eskress@thinknet.com>
ss7ns           477/tcp    ss7ns
ss7ns           477/udp    ss7ns
#                          Jean-Michel URSCH <ursch@taec.enet.dec.com>
spsc            478/tcp    spsc
spsc            478/udp    spsc
#                          Mike Rieker <mikea@sp32.com>
iafserver       479/tcp    iafserver
iafserver       479/udp    iafserver
iafdbase        480/tcp    iafdbase
iafdbase        480/udp    iafdbase
#                          ricky@solect.com <Rick Yazwinski>
ph              481/tcp    Ph service
ph              481/udp    Ph service
#                          Roland Hedberg <Roland.Hedberg@umdac.umu.se>
bgs-nsi         482/tcp    bgs-nsi
bgs-nsi         482/udp    bgs-nsi
#                          Jon Saperia <saperia@bgs.com>         
ulpnet          483/tcp    ulpnet
ulpnet          483/udp    ulpnet
#                          Kevin Mooney <kevinm@bfs.unibol.com>
integra-sme     484/tcp    Integra Software Management Environment
integra-sme     484/udp    Integra Software Management Environment
#                          Randall Dow <rand@randix.m.isr.de>
powerburst      485/tcp    Air Soft Power Burst
powerburst      485/udp    Air Soft Power Burst
#                          <gary@airsoft.com>
avian           486/tcp    avian
avian           486/udp    avian
#                          Robert Ullmann 
#                          <Robert_Ullmann/CAM/Lotus.LOTUS@crd.lotus.com>
saft            487/tcp    saft Simple Asynchronous File Transfer
saft            487/udp    saft Simple Asynchronous File Transfer
#                          Ulli Horlacher <framstag@rus.uni-stuttgart.de>
gss-http        488/tcp    gss-http
gss-http        488/udp    gss-http
#                          Doug Rosenthal <rosenthl@krypton.einet.net>
nest-protocol   489/tcp    nest-protocol
nest-protocol   489/udp    nest-protocol
#                          Gil Gameiro <gil_gameiro@novell.com>
micom-pfs       490/tcp    micom-pfs
micom-pfs       490/udp    micom-pfs
#                          David Misunas <DMisunas@micom.com>
go-login        491/tcp    go-login
go-login        491/udp    go-login
#                          Troy Morrison <troy@graphon.com>
ticf-1          492/tcp    Transport Independent Convergence for FNA
ticf-1          492/udp    Transport Independent Convergence for FNA
ticf-2          493/tcp    Transport Independent Convergence for FNA
ticf-2          493/udp    Transport Independent Convergence for FNA
#                          Mamoru Ito <Ito@pcnet.ks.pfu.co.jp>
pov-ray         494/tcp    POV-Ray
pov-ray         494/udp    POV-Ray
#                          Chris Cason <cjcason@netspace.net.au>
intecourier     495/tcp    intecourier
intecourier     495/udp    intecourier
#                          Steve Favor <sfavor@tigger.intecom.com>
pim-rp-disc     496/tcp    PIM-RP-DISC
pim-rp-disc     496/udp    PIM-RP-DISC
#                          Dino Farinacci <dino@cisco.com>
dantz           497/tcp    dantz
dantz           497/udp    dantz
#                          Dotty Yackle <dotty_yackle@dantz.com>
siam            498/tcp    siam
siam            498/udp    siam
#                          Philippe Gilbert <pgilbert@cal.fr>
iso-ill         499/tcp    ISO ILL Protocol
iso-ill         499/udp    ISO ILL Protocol
#                          Mark H. Needleman <Mark.Needleman@ucop.edu>
isakmp          500/tcp    isakmp
isakmp          500/udp    isakmp
#                          Mark Schertler <mjs@tycho.ncsc.mil>
stmf            501/tcp    STMF
stmf            501/udp    STMF
#                          Alan Ungar <aungar@farradyne.com>
asa-appl-proto  502/tcp    asa-appl-proto
asa-appl-proto  502/udp    asa-appl-proto
#                          Dennis Dube <ddube@modicon.com>
intrinsa        503/tcp    Intrinsa
intrinsa        503/udp    Intrinsa
#                          Robert Ford <robert@intrinsa.com>
citadel         504/tcp    citadel
citadel         504/udp    citadel
#                          Art Cancro <ajc@uncnsrd.mt-kisco.ny.us>
mailbox-lm      505/tcp    mailbox-lm
mailbox-lm      505/udp    mailbox-lm
                           Beverly Moody <Beverly_Moody@stercomm.com>
ohimsrv         506/tcp    ohimsrv
ohimsrv         506/udp    ohimsrv
#                          Scott Powell <spowell@openhorizon.com>
crs             507/tcp    crs
crs             507/udp    crs
#                          Brad Wright <bradwr@microsoft.com>
xvttp           508/tcp    xvttp
xvttp           508/udp    xvttp
#                          Keith J. Alphonso <alphonso@ncs-ssc.com>
snare           509/tcp    snare
snare           509/udp    snare
#                          Dennis Batchelder <dennis@capres.com>
fcp             510/tcp    FirstClass Protocol
fcp             510/udp    FirstClass Protocol
#                          Mike Marshburn <mike@softarc.com>
mynet           511/tcp    mynet-as
mynet           511/udp    mynet-as
#                          John Rainford <JAR@cks-hq.mhs.compuserve.com>
exec            512/tcp    remote process execution;
#                          authentication performed using
#                          passwords and UNIX loppgin names
comsat          512/udp
biff            512/udp    used by mail system to notify users
#                          of new mail received; currently
#                          receives messages only from 
#                          processes on the same machine
login           513/tcp    remote login a la telnet;
#                          automatic authentication performed
#                          based on priviledged port numbers
#                          and distributed data bases which
#                          identify "authentication domains"
who             513/udp    maintains data bases showing who's
#                          logged in to machines on a local 
#                          net and the load average of the
#                          machine
shell           514/tcp    cmd
#                          like exec, but automatic authentication 
#                          is performed as for login server
syslog          514/udp
printer         515/tcp    spooler
printer         515/udp    spooler
videotex        516/tcp    videotex
videotex        516/udp    videotex
#                          Daniel Mavrakis <system@venus.mctel.fr>
talk            517/tcp    like tenex link, but across
#                          machine - unfortunately, doesn't
#                          use link protocol (this is actually
#                          just a rendezvous port from which a
#                          tcp connection is established)
talk            517/udp    like tenex link, but across
#                          machine - unfortunately, doesn't
#                          use link protocol (this is actually
#                          just a rendezvous port from which a
#                          tcp connection is established)
ntalk           518/tcp
ntalk           518/udp
utime           519/tcp    unixtime
utime           519/udp    unixtime
efs             520/tcp    extended file name server
router          520/udp    local routing process (on site);
#                          uses variant of Xerox NS routing
#                          information protocol - RIP
ripng           521/tcp    ripng
ripng           521/udp    ripng
#                          Robert E. Minnear <minnear@ipsilon.com>
ulp             522/tcp    ULP    
ulp             522/udp    ULP    
#                          Max Morris <maxm@MICROSOFT.com>
ibm-db2         523/tcp    IBM-DB2
ibm-db2         523/tcp    IBM-DB2
#                          Peter Pau <pau@VNET.IBM.COM>
ncp             524/tcp    NCP
ncp             524/udp    NCP    
#                          Don Provan <donp@sjf.novell.com>
timed  	        525/tcp    timeserver
timed           525/udp    timeserver
tempo	        526/tcp    newdate
tempo	        526/udp    newdate
stx             527/tcp    Stock IXChange
stx             527/udp    Stock IXChange
custix          528/tcp    Customer IXChange
custix          528/udp    Customer IXChange
#                          Ralph Hanan <RalphH@ixchange.com>
irc-serv        529/tcp    IRC-SERV
irc-serv        529/tcp    IRC-SERV
#                          Brian Tackett <cym@acrux.net>
courier         530/tcp    rpc
courier         530/udp    rpc
conference      531/tcp    chat
conference      531/udp    chat
netnews         532/tcp    readnews
netnews         532/udp    readnews
netwall	        533/tcp    for emergency broadcasts
netwall	        533/udp    for emergency broadcasts
mm-admin        534/tcp    MegaMedia Admin
mm-admin        534/udp    MegaMedia Admin
#                          Andreas Heidemann <a.heidemann@ais-gmbh.de>
iiop            535/tcp    iiop
iiop            535/udp    iiop
#                          Jeff M.Michaud <michaud@zk3.dec.com>
opalis-rdv      536/tcp    opalis-rdv
opalis-rdv      536/udp    opalis-rdv
#                          Laurent Domenech <laurent@opalis.com>
nmsp            537/tcp    Networked Media Streaming Protocol
nmsp            537/udp    Networked Media Streaming Protocol
#                          Paul Santinelli Jr. <psantinelli@narrative.com>
gdomap          538/tcp    gdomap
gdomap          538/udp    gdomap
#                          Richard Frith-Macdonald <richard@brainstorm.co.uk>
apertus-ldp     539/tcp    Apertus Technologies Load Determination
apertus-ldp     539/udp    Apertus Technologies Load Determination
uucp	        540/tcp    uucpd		
uucp	        540/udp    uucpd		
uucp-rlogin     541/tcp    uucp-rlogin  
uucp-rlogin     541/udp    uucp-rlogin
#                          Stuart Lynne <sl@wimsey.com>
commerce        542/tcp    commerce
commerce        542/udp    commerce
#                          Randy Epstein <repstein@wiznet.net>
#			   Alan Bridges <alan@wiznet.net>
klogin          543/tcp
klogin          543/udp
kshell 	        544/tcp    krcmd
kshell 	        544/udp    krcmd
appleqtcsrvr    545/tcp    appleqtcsrvr
appleqtcsrvr    545/udp    appleqtcsrvr
#                          Murali Ranganathan 
#                          <Murali_Ranganathan@quickmail.apple.com>
dhcpv6-client   546/tcp    DHCPv6 Client
dhcpv6-client   546/udp    DHCPv6 Client
dhcpv6-server   547/tcp    DHCPv6 Server
dhcpv6-server   547/udp    DHCPv6 Server
#                          Jim Bound <bound@zk3.dec.com>
afpovertcp      548/tcp    AFP over TCP
afpovertcp      548/udp    AFP over TCP
#                          Leland Wallace <randall@apple.com>
idfp            549/tcp    IDFP
idfp            549/udp    IDFP
#                          Ramana Kovi <ramana@kovi.com>
new-rwho        550/tcp    new-who
new-rwho        550/udp    new-who
cybercash       551/tcp    cybercash
cybercash       551/udp    cybercash
#                          Donald E. Eastlake 3rd <dee@cybercash.com>
deviceshare     552/tcp    deviceshare
deviceshare     552/udp    deviceshare
#                          Brian Schenkenberger <brians@advsyscon.com>
pirp            553/tcp    pirp
pirp            553/udp    pirp
#                          D. J. Bernstein <djb@silverton.berkeley.edu>
rtsp            554/tcp    Real Time Stream Control Protocol
rtsp            554/udp    Real Time Stream Control Protocol
#			   Rob Lanphier <robla@prognet.com>
dsf             555/tcp
dsf             555/udp
remotefs        556/tcp    rfs server
remotefs        556/udp    rfs server
openvms-sysipc  557/tcp    openvms-sysipc
openvms-sysipc  557/udp    openvms-sysipc
#                          Alan Potter <potter@movies.enet.dec.com>
sdnskmp         558/tcp    SDNSKMP
sdnskmp         558/udp    SDNSKMP
teedtap         559/tcp    TEEDTAP
teedtap         559/udp    TEEDTAP
#                          Mort Hoffman <hoffman@mail.ndhm.gtegsc.com>
rmonitor        560/tcp    rmonitord
rmonitor        560/udp    rmonitord
monitor         561/tcp
monitor         561/udp
chshell         562/tcp    chcmd
chshell         562/udp    chcmd
nntps           563/tcp    nntp protocol over TLS/SSL (was snntp)
nntps           563/udp    nntp protocol over TLS/SSL (was snntp)
#                          Kipp E.B. Hickman <kipp@netscape.com>
9pfs            564/tcp    plan 9 file service
9pfs            564/udp    plan 9 file service
whoami          565/tcp    whoami
whoami          565/udp    whoami
streettalk      566/tcp    streettalk
streettalk      566/udp    streettalk
banyan-rpc      567/tcp    banyan-rpc
banyan-rpc      567/udp    banyan-rpc
#                          Tom Lemaire <toml@banyan.com>
ms-shuttle      568/tcp    microsoft shuttle
ms-shuttle      568/udp    microsoft shuttle
#                          Rudolph Balaz <rudolphb@microsoft.com>
ms-rome         569/tcp    microsoft rome
ms-rome         569/udp    microsoft rome
#                          Rudolph Balaz <rudolphb@microsoft.com>
meter           570/tcp    demon
meter           570/udp    demon
meter	        571/tcp    udemon
meter	        571/udp    udemon
sonar           572/tcp    sonar
sonar           572/udp    sonar
#                          Keith Moore <moore@cs.utk.edu>
banyan-vip      573/tcp    banyan-vip
banyan-vip      573/udp    banyan-vip
#                          Denis Leclerc <DLeclerc@banyan.com>
ftp-agent       574/tcp    FTP Software Agent System
ftp-agent       574/udp    FTP Software Agent System
#                          Michael S. Greenberg <arnoff@ftp.com>
vemmi           575/tcp    VEMMI
vemmi           575/udp    VEMMI
#                          Daniel Mavrakis <mavrakis@mctel.fr>
ipcd            576/tcp    ipcd
ipcd            576/udp    ipcd
vnas            577/tcp    vnas
vnas            577/udp    vnas
ipdd            578/tcp    ipdd
ipdd            578/udp    ipdd
#                          Jay Farhat <jfarhat@ipass.com>
decbsrv		579/tcp    decbsrv
decbsrv		579/udp    decbsrv
#			   Rudi Martin <movies::martin"@movies.enet.dec.com>
sntp-heartbeat  580/tcp    SNTP HEARTBEAT
sntp-heartbeat  580/udp	   SNTP HEARTBEAT
#			   Louis Mamakos <louie@uu.net>
bdp		581/tcp    Bundle Discovery Protocol
bdp		581/udp	   Bundle Discovery Protocol
#			   Gary Malkin <gmalkin@xylogics.com>
scc-security    582/tcp    SCC Security
scc-security    582/udp	   SCC Security
#			   Prashant Dholakia <prashant@semaphorecom.com>
philips-vc	583/tcp    Philips Video-Conferencing
philips-vc	583/udp    Philips Video-Conferencing
#			   Janna Chang <janna@pmc.philips.com>
keyserver	584/tcp    Key Server
keyserver	584/udp	   Key Server
#			   Gary Howland <gary@systemics.com>
imap4-ssl	585/tcp    IMAP4+SSL (use 993 instead)
imap4-ssl	585/udp    IMAP4+SSL (use 993 instead)
#			   Terry Gray <gray@cac.washington.edu>
#               Use of 585 is not recommended, use 993 instead
password-chg 	586/tcp    Password Change
password-chg	586/udp	   Password Change
submission	587/tcp    Submission
submission	587/udp    Submission
#			   Randy Gellens <randy@qualcomm.com>
cal		588/tcp    CAL
cal		588/udp    CAL
#			   Myron Hattig <Myron_Hattig@ccm.jf.intel.com>
eyelink		589/tcp    EyeLink
eyelink		589/udp	   EyeLink
#			   Dave Stampe <dstampe@psych.toronto.edu>
tns-cml		590/tcp    TNS CML
tns-cml		590/udp    TNS CML
#			   Jerome Albin <albin@taec.enet.dec.com>
fmpro-http	591/tcp    FMPRO4 - HTTP
fmpro-http	591/udp    FMPRO4 - HTTP
#			   Christopher Pratt <christopher_pratt@claris.com>
eudora-set	592/tcp    Eudora Set
eudora-set	592/udp	   Eudora Set
#			   Randall Gellens <randy@qualcomm.com>
http-rpc-epmap  593/tcp    HTTP RPC Ep Map
http-rpc-epmap  593/tcp    HTTP RPC Ep Map
#			   Edward Reus <edwardr@microsoft.com>
tpip		594/tcp    TPIP
tpip		594/udp    TPIP
#			   Brad Spear <spear@platinum.com>
cab-protocol	595/tcp    CAB Protocol
cab-protocol	595/udp    CAB Protocol
#			   Winston Hetherington
smsd		596/tcp    SMSD
smsd		596/udp    SMSD
#			   Wayne Barlow <web@unx.dec.com>
ptcnameservice	597/tcp    PTC Name Service
ptcnameservice	597/udp    PTC Name Service
#			   Yuri Machkasov <yuri@ptc.com>
sco-websrvrmg3	598/tcp    SCO Web Server Manager 3
sco-websrvrmg3	598/udp    SCO Web Server Manager 3
#			   Simon Baldwin <simonb@sco.com>
acp		599/tcp    Aeolon Core Protocol
acp		599/udp    Aeolon Core Protocol
#			   Mike Marshburn <mike@aeolon.com>
ipcserver       600/tcp    Sun IPC server
ipcserver       600/udp    Sun IPC server
urm             606/tcp    Cray Unified Resource Manager
urm             606/udp    Cray Unified Resource Manager
nqs	        607/tcp    nqs
nqs	        607/udp    nqs
n#                          Bill Schiefelbein <schief@aspen.cray.com>
sift-uft        608/tcp    Sender-Initiated/Unsolicited File Transfer 
sift-uft        608/udp    Sender-Initiated/Unsolicited File Transfer
#                          Rick Troth <troth@rice.edu>
npmp-trap       609/tcp    npmp-trap
npmp-trap       609/udp    npmp-trap
npmp-local      610/tcp    npmp-local
npmp-local      610/udp    npmp-local
npmp-gui        611/tcp    npmp-gui  
npmp-gui        611/udp    npmp-gui  
#                          John Barnes <jbarnes@crl.com>
hmmp-ind	612/tcp    HMMP Indication
hmmp-ind	612/udp	   HMMP Indication
hmmp-op		613/tcp    HMMP Operation
hmmp-op		613/udp	   HMMP Operation
#			   Andrew Sinclair <andrsin@microsoft.com>
sshell		614/tcp    SSLshell
sshell   	614/udp	   SSLshell
#			   Simon J. Gerraty <sjg@quick.com.au>
sco-inetmgr	615/tcp	   Internet Configuration Manager
sco-inetmgr	615/udp    Internet Configuration Manager
sco-sysmgr	616/tcp    SCO System Administration Server
sco-sysmgr	616/udp    SCO System Administration Server
sco-dtmgr	617/tcp    SCO Desktop Administration Server
sco-dtmgr	617/udp    SCO Desktop Administration Server
#			   Christopher Durham <chrisdu@sco.com>
dei-icda	618/tcp    DEI-ICDA
dei-icda	618/udp    DEI-ICDA
#			   David Turner <digital@Quetico.tbaytel.net>
digital-evm	619/tcp    Digital EVM
digital-evm	619/udp    Digital EVM
#			   Jem Treadwell <jem@unx.dec.com>
sco-websrvrmgr  620/tcp    SCO WebServer Manager
sco-websrvrmgr  620/udp    SCO WebServer Manager
#			   Christopher Durham <chrisdu@sco.com>
escp-ip		621/tcp    ESCP
escp-ip		621/udp    ESCP
#			   Lai Zit Seng <lzs@pobox.com>
collaborator	622/tcp    Collaborator
collaborator	622/udp	   Collaborator
#			   Johnson Davis <johnsond@opteamasoft.com>
aux_bus_shunt	623/tcp    Aux Bus Shunt
aux_bus_shunt	623/udp    Aux Bus Shunt
#			   Steve Williams <Steven_D_Williams@ccm.jf.intel.com>
cryptoadmin	624/tcp    Crypto Admin
cryptoadmin	624/udp    Crypto Admin
#			   Matt Lachance <pagtec@cyberus.ca>
dec_dlm		625/tcp    DEC DLM
dec_dlm		625/udp    DEC DLM
#			   Rudi Martin <Rudi.Martin@edo.mts.dec.com>
asia		626/tcp    ASIA
asia		626/udp    ASIA
#			   Michael Dasenbrock <dasenbro@apple.com>
cks-tivioli	627/tcp    CKS & TIVIOLI
cks-tivioli	627/udp    CKS & TIVIOLI
#			   David Sarjantson <dps@ckshq.com>
#               628-632    Unassigned
servstat	633/tcp    Service Status update (Sterling Software)
servstat	633/udp    Service Status update (Sterling Software)
#                          Greg Rose <Greg_Rose@sydney.sterling.com>
ginad           634/tcp    ginad
ginad           634/udp    ginad
#                          Mark Crother <mark@eis.calstate.edu>
rlzdbase        635/tcp    RLZ DBase
rlzdbase        635/udp    RLZ DBase
#                          Michael Ginn <ginn@netcom.com>
ldaps           636/tcp    ldap protocol over TLS/SSL (was sldap)
ldaps           636/udp    ldap protocol over TLS/SSL (was sldap)
#                          Pat Richard <patr@xcert.com>
lanserver       637/tcp    lanserver
lanserver       637/udp    lanserver
#                          Chris Larsson <clarsson@VNET.IBM.COM>
#               638-665    Unassigned
mdqs            666/tcp	
mdqs            666/udp	
doom            666/tcp    doom Id Software
doom            666/udp    doom Id Software
#                          <ddt@idcube.idsoftware.com>
disclose        667/tcp    campaign contribution disclosures - 
                           SDR Technologies
disclose        667/udp    campaign contribution disclosures - 
                           SDR Technologies
#                          Jim Dixon  <jim@lambda.com>
mecomm          668/tcp    MeComm
mecomm          668/udp    MeComm
meregister      669/tcp    MeRegister
meregister      669/udp    MeRegister
#                          Armin Sawusch <armin@esd1.esd.de>
vacdsm-sws      670/tcp    VACDSM-SWS
vacdsm-sws      670/udp    VACDSM-SWS
vacdsm-app      671/tcp    VACDSM-APP
vacdsm-app      671/udp    VACDSM-APP
vpps-qua        672/tcp    VPPS-QUA
vpps-qua        672/udp    VPPS-QUA
cimplex         673/tcp    CIMPLEX
cimplex         673/udp    CIMPLEX
#                          Ulysses G. Smith Jr. <ugsmith@cesi.com>
acap		674/tcp    ACAP
acap		674/udp	   ACAP
#			   Chris Newman <Chris.Newman@innosoft.com>
dctp		675/tcp    DCTP
dctp		675/udp    DCTP
#			   Andre Kramer <Andre.Kramer@ansa.co.uk>
vpps-via	676/tcp    VPPS Via
vpps-via	676/udp    VPPS Via
#			   Ulysses G. Smith Jr. <ugsmith@cesi.com>
#               677-703    Unassigned
elcsd	        704/tcp    errlog copy/server daemon
elcsd	        704/udp    errlog copy/server daemon
agentx	        705/tcp    AgentX
agentx		705/udp    AgentX
#			   Bob Natale <natale@acec.com>
#               706-708    Unassigned
entrust-kmsh    709/tcp    Entrust Key Management Service Handler
entrust-kmsh    709/udp    Entrust Key Management Service Handler
entrust-ash     710/tcp    Entrust Administration Service Handler
entrust-ash     710/udp    Entrust Administration Service Handler
#                          Peter Whittaker <pww@entrust.com>
cisco-tdp	711/tcp    Cisco TDP
cisco-tdp	711/udp    Cisco TDP
#			   Bruce Davie <bsd@cisco.com>
#               712-728    Unassigned
netviewdm1      729/tcp    IBM NetView DM/6000 Server/Client
netviewdm1      729/udp    IBM NetView DM/6000 Server/Client
netviewdm2      730/tcp    IBM NetView DM/6000 send/tcp
netviewdm2      730/udp    IBM NetView DM/6000 send/tcp
netviewdm3      731/tcp    IBM NetView DM/6000 receive/tcp
netviewdm3      731/udp    IBM NetView DM/6000 receive/tcp
#                          Philippe Binet  (phbinet@vnet.IBM.COM)
netgw           741/tcp    netGW
netgw           741/udp    netGW
#                          Oliver Korfmacher (okorf@netcs.com)
netrcs          742/tcp    Network based Rev. Cont. Sys.
netrcs          742/udp    Network based Rev. Cont. Sys.
#                          Gordon C. Galligher <gorpong@ping.chi.il.us>
flexlm          744/tcp    Flexible License Manager
flexlm          744/udp    Flexible License Manager
#                          Matt Christiano
#                          <globes@matt@oliveb.atc.olivetti.com> 
fujitsu-dev     747/tcp    Fujitsu Device Control
fujitsu-dev     747/udp    Fujitsu Device Control
ris-cm          748/tcp    Russell Info Sci Calendar Manager
ris-cm          748/udp    Russell Info Sci Calendar Manager
kerberos-adm    749/tcp    kerberos administration
kerberos-adm    749/udp    kerberos administration
rfile 	        750/tcp
loadav          750/udp
kerberos-iv     750/udp    kerberos version iv
#                          Martin Hamilton <martin@mrrl.lut.as.uk>
pump	        751/tcp
pump	        751/udp
qrh	        752/tcp
qrh	        752/udp
rrh    	        753/tcp
rrh	        753/udp
tell	        754/tcp	    send
tell	        754/udp	    send
nlogin	        758/tcp
nlogin	        758/udp
con	        759/tcp
con	        759/udp
ns	        760/tcp
ns	        760/udp
rxe	        761/tcp
rxe	        761/udp
quotad	        762/tcp
quotad	        762/udp
cycleserv       763/tcp
cycleserv       763/udp
omserv	        764/tcp
omserv	        764/udp
webster	        765/tcp
webster	        765/udp
phonebook       767/tcp	   phone
phonebook       767/udp	   phone
vid	        769/tcp
vid	        769/udp
cadlock         770/tcp
cadlock         770/udp
rtip 	        771/tcp
rtip 	        771/udp
cycleserv2      772/tcp
cycleserv2      772/udp
submit	        773/tcp
notify	        773/udp
rpasswd	        774/tcp
acmaint_dbd     774/udp
entomb	        775/tcp
acmaint_transd	775/udp
wpages		776/tcp
wpages          776/udp
wpgs		780/tcp
wpgs		780/udp
concert         786/tcp    Concert
concert         786/udp    Concert
#                          Josyula R. Rao <jrrao@watson.ibm.com>
#               787-799    Unassigned
mdbs_daemon	800/tcp	
mdbs_daemon	800/udp	
device		801/tcp
device		801/udp
#               802-828    Unassigned
pkix-3-ca-ra	829/tcp    PKIX-3 CA/RA
pkix-3-ca-ra    829/tcp    PKIX-3 CA/RA
#			   Carlisle Adams <Cadams@entrust.com>
#		830-885    Unassigned
iclcnet-locate  886/tcp    ICL coNETion locate server
iclcnet-locate  886/udp    ICL coNETion locate server
#                          Bob Lyon <bl@oasis.icl.co.uk>
iclcnet_svinfo  887/tcp    ICL coNETion server info
iclcnet_svinfo  887/udp    ICL coNETion server info
#                          Bob Lyon <bl@oasis.icl.co.uk>
accessbuilder   888/tcp    AccessBuilder
accessbuilder   888/udp    AccessBuilder
#                          Steve Sweeney <Steven_Sweeney@3mail.3com.com>
# The following entry records an unassigned but widespread use
cddbp           888/tcp    CD Database Protocol
#                          Steve Scherf <steve@moonsoft.com>
#
#		889-899    Unassigned
omginitialrefs  900/tcp    OMG Initial Refs
omginitialrefs  900/udp    OMG Initial Refs
#			   Christian Callsen <Christian.Callsen@eng.sun.com>
#               889-910    Unassigned
xact-backup     911/tcp    xact-backup
xact-backup     911/tcp    xact-backup
#                          Bill Carroll <billc@xactlabs.com>
#               912-988    Unassigned
ftps-data	989/tcp    ftp protocol, data, over TLS/SSL
ftps-data	989/udp    ftp protocol, data, over TLS/SSL
ftps		990/tcp    ftp protocol, control, over TLS/SSL
ftps		990/udp    ftp protocol, control, over TLS/SSL
#			   Christopher Allen <ChristopherA@consensus.com>
nas		991/tcp    Netnews Administration System
nas		991/udp    Netnews Administration System
#			   Vera Heinau <heinau@fu-berlin.de>
#			   Heiko Schlichting <heiko@fu-berlin.de>
telnets		992/tcp    telnet protocol over TLS/SSL
telnets		992/udp    telnet protocol over TLS/SSL
imaps		993/tcp    imap4 protocol over TLS/SSL
imaps		993/udp    imap4 protocol over TLS/SSL
ircs		994/tcp    irc protocol over TLS/SSL
ircs		994/udp    irc protocol over TLS/SSL
#			   Christopher Allen <ChristopherA@consensus.com>
pop3s           995/tcp    pop3 protocol over TLS/SSL (was spop3)
pop3s           995/udp    pop3 protocol over TLS/SSL (was spop3)
#                          Gordon Mangione <gordm@microsoft.com>
vsinet          996/tcp    vsinet
vsinet          996/udp    vsinet
#                          Rob Juergens <robj@vsi.com>
maitrd		997/tcp
maitrd		997/udp
busboy		998/tcp
puparp		998/udp
garcon		999/tcp
applix		999/udp	       Applix ac
puprouter	999/tcp
puprouter	999/udp
cadlock		1000/tcp
ock		1000/udp
#               1001-1022      Unassigned
#		1008/udp   Possibly used by Sun Solaris????
                1023/tcp       Reserved
	        1023/udp       Reserved
#                              IANA <iana@isi.edu>



REGISTERED PORT NUMBERS

The Registered Ports are listed by the IANA and on most systems can be
used by ordinary user processes or programs executed by ordinary
users.

Ports are used in the TCP [RFC793] to name the ends of logical
connections which carry long term conversations.  For the purpose of
providing services to unknown callers, a service contact port is
defined.  This list specifies the port used by the server process as
its contact port.

The IANA registers uses of these ports as a convienence to the
community.

To the extent possible, these same port assignments are used with the
UDP [RFC768].

The Registered Ports are in the range 1024-49151.

Port Assignments:

Keyword         Decimal    Description                     References
-------         -------    -----------                     ----------
                1024/tcp   Reserved		
                1024/udp   Reserved             
#                          IANA <iana@isi.edu>
blackjack	1025/tcp   network blackjack
blackjack	1025/udp   network blackjack
iad1            1030/tcp   BBN IAD
iad1            1030/udp   BBN IAD
iad2            1031/tcp   BBN IAD
iad2            1031/udp   BBN IAD
iad3            1032/tcp   BBN IAD
iad3            1032/udp   BBN IAD
#                          Andy Malis <malis_a@timeplex.com>
neod1           1047/tcp   Sun's NEO Object Request Broker
neod1           1047/udp   Sun's NEO Object Request Broker
neod2           1048/tcp   Sun's NEO Object Request Broker
neod2           1048/udp   Sun's NEO Object Request Broker
#                          Rohit Garg <rohit.garg@eng.sun.com>
nim             1058/tcp   nim
nim             1058/udp   nim
nimreg          1059/tcp   nimreg
nimreg          1059/udp   nimreg
#                          Robert Gordon <rbg@austin.ibm.com>
instl_boots     1067/tcp   Installation Bootstrap Proto. Serv. 
instl_boots     1067/udp   Installation Bootstrap Proto. Serv. 
instl_bootc     1068/tcp   Installation Bootstrap Proto. Cli.  
instl_bootc     1068/udp   Installation Bootstrap Proto. Cli.  
#                          David Arko <<darko@hpfcrn.fc.hp.com>
socks           1080/tcp   Socks    
socks           1080/udp   Socks    
#                          Ying-Da Lee <ylee@syl.dl.nec.com
ansoft-lm-1     1083/tcp   Anasoft License Manager
ansoft-lm-1     1083/udp   Anasoft License Manager
ansoft-lm-2     1084/tcp   Anasoft License Manager
ansoft-lm-2     1084/udp   Anasoft License Manager
nfsd-status	1110/tcp   Cluster status info
nfsd-keepalive	1110/udp   Client status info
#                          Edgar Circenis <ec@hpfclj.fc.hp.com>
lmsocialserver  1111/tcp   LM Social Server
lmsocialserver	1111/udp   LM Social Server
#			   Ron Lussier <coyote@likeminds.com>
murray          1123/tcp   Murray
murray          1123/udp   Murray
#                          Stu Mark <fordii@j51.com>
nfa             1155/tcp   Network File Access                
nfa             1155/udp   Network File Access                
#                          James Powell <james@mailhost.unidata.com>
mc-client	1180/tcp   Millicent Client Proxy
mc-client 	1180/udp   Millicent Client Proxy
#			   Steve Glassman <steveg@pa.dec.com>
lupa            1212/tcp   lupa
lupa            1212/udp   lupa
#                          Barney Wolff <barney@databus.com>
nerv		1222/tcp   SNI R&D network                  
nerv		1222/udp   SNI R&D network                  
#                          Martin Freiss <freiss.pad@sni.de>
#		1223-1233  Unassigned
search-agent	1234/tcp   Infoseek Search Agent
search-agent	1234/udp   Infoseek Search Agent
#			   Jackie Wu <jackiew@infoseek.com>
#		1235-1238  Unassigned
nmsd		1239/tcp   NMSD
nmsd		1239/udp   NMSD
#			   Yuri Machkasov <yuri@ptc.com>
#		1240-1247  Unassigned
hermes		1248/tcp
hermes		1248/udp
#               1249-1299  Unassigned
h323hostcallsc	1300/tcp   H323 Host Call Secure
h323hostcallsc	1300/udp   H323 Host Call Secure
#			   Jim Toga <jtoga@ideal.jf.intel.com>
#		1301-1312  Unassigned
bmc_patroldb    1313/tcp   BMC_PATROLDB
bmc-patroldb    1313/udp   BMC_PATROLDB
#                          Devon Shows <Devon_Shows@crow.bmc.com>
pdps		1314/tcp   Photoscript Distributed Printing System
pdps            1314/udp   Photoscript Distributed Printing System
#			   Les Klein <sgy@cix.compulink.co.uk>
#               1315-1344  Unassigned  
vpjp            1345/tcp   VPJP
vpjp            1345/udp   VPJP
#                          Michael Collins <UBMCollins@aol.com>
alta-ana-lm     1346/tcp   Alta Analytics License Manager 
alta-ana-lm     1346/udp   Alta Analytics License Manager 
bbn-mmc		1347/tcp   multi media conferencing
bbn-mmc		1347/udp   multi media conferencing
bbn-mmx		1348/tcp   multi media conferencing
bbn-mmx		1348/udp   multi media conferencing
sbook           1349/tcp   Registration Network Protocol       
sbook           1349/udp   Registration Network Protocol       
editbench       1350/tcp   Registration Network Protocol       
editbench       1350/udp   Registration Network Protocol       
#               Simson L. Garfinkel <simsong@next.cambridge.ma.us>
equationbuilder 1351/tcp   Digital Tool Works (MIT)            
equationbuilder 1351/udp   Digital Tool Works (MIT)            
#                          Terrence J. Talbot <lexcube!tjt@bu.edu>
lotusnote       1352/tcp   Lotus Note                          
lotusnote       1352/udp   Lotus Note                          
#               Greg Pflaum <iris.com!Greg_Pflaum@uunet.uu.net>
relief          1353/tcp   Relief Consulting                   
relief          1353/udp   Relief Consulting                   
#                          John Feiler <relief!jjfeiler@uu2.psi.com>
rightbrain      1354/tcp   RightBrain Software              
rightbrain      1354/udp   RightBrain Software              
#                          Glenn Reid <glann@rightbrain.com>
intuitive edge  1355/tcp   Intuitive Edge 
intuitive edge  1355/udp   Intuitive Edge 
#                          Montgomery Zukowski
#                          <monty@nextnorth.acs.ohio-state.edu> 
cuillamartin    1356/tcp   CuillaMartin Company 
cuillamartin    1356/udp   CuillaMartin Company 
pegboard        1357/tcp   Electronic PegBoard  
pegboard        1357/udp   Electronic PegBoard  
#                          Chris Cuilla
#                          <balr!vpnet!cuilla!chris@clout.chi.il.us> 
connlcli        1358/tcp   CONNLCLI                             
connlcli        1358/udp   CONNLCLI                             
ftsrv           1359/tcp   FTSRV                                
ftsrv           1359/udp   FTSRV                                
#                          Ines Homem de Melo <sidinf@brfapesp.bitnet>
mimer           1360/tcp   MIMER                               
mimer           1360/udp   MIMER                               
#                          Per Schroeder  <Per.Schroder@mimer.se>
linx            1361/tcp   LinX                        
linx            1361/udp   LinX                        
#                          Steffen Schilke <---none--->
timeflies       1362/tcp   TimeFlies                           
timeflies       1362/udp   TimeFlies                           
#                          Doug Kent <mouthers@slugg@nwnexus.wa.com>
ndm-requester   1363/tcp   Network DataMover Requester
ndm-requester   1363/udp   Network DataMover Requester
ndm-server      1364/tcp   Network DataMover Server   
ndm-server      1364/udp   Network DataMover Server   
#                          Toshio Watanabe
#                          <watanabe@godzilla.rsc.spdd.ricoh.co.j> 
adapt-sna       1365/tcp   Network Software Associates
adapt-sna       1365/udp   Network Software Associates
#                          Jeffery Chiao <714-768-401>
netware-csp     1366/tcp   Novell NetWare Comm Service Platform
netware-csp     1366/udp   Novell NetWare Comm Service Platform
#                          Laurie Lindsey <llindsey@novell.com>
dcs             1367/tcp   DCS                             
dcs             1367/udp   DCS                             
#                          Stefan Siebert <ssiebert@dcs.de>
screencast      1368/tcp   ScreenCast                          
screencast      1368/udp   ScreenCast                          
#                          Bill Tschumy <other!bill@uunet.UU.NET>
gv-us           1369/tcp   GlobalView to Unix Shell             
gv-us           1369/udp   GlobalView to Unix Shell             
us-gv           1370/tcp   Unix Shell to GlobalView             
us-gv           1370/udp   Unix Shell to GlobalView             
#               Makoto Mita <mita@ssdev.ksp.fujixerox.co.jp>
fc-cli          1371/tcp   Fujitsu Config Protocol             
fc-cli          1371/udp   Fujitsu Config Protocol             
fc-ser          1372/tcp   Fujitsu Config Protocol             
fc-ser          1372/udp   Fujitsu Config Protocol             
#               Ryuichi Horie <horie@spad.sysrap.cs.fujitsu.co.jp>
chromagrafx     1373/tcp   Chromagrafx                         
chromagrafx     1373/udp   Chromagrafx                         
#                          Mike Barthelemy <msb@chromagrafx.com>
molly           1374/tcp   EPI Software Systems        
molly           1374/udp   EPI Software Systems        
#                          Jim Vlcek <vlcek@epimbe.com>
bytex           1375/tcp   Bytex                             
bytex           1375/udp   Bytex                             
#               Mary Ann Burt <bytex!ws054!maryann@uunet.UU.NET>
ibm-pps         1376/tcp   IBM Person to Person Software     
ibm-pps         1376/udp   IBM Person to Person Software     
#                          Simon Phipps <sphipps@vnet.ibm.com>
cichlid         1377/tcp   Cichlid License Manager       
cichlid         1377/udp   Cichlid License Manager       
#                          Andy Burgess <aab@cichlid.com>
elan            1378/tcp   Elan License Manager   
elan            1378/udp   Elan License Manager   
#                          Ken Greer <kg@elan.com>
dbreporter      1379/tcp   Integrity Solutions                 
dbreporter      1379/udp   Integrity Solutions                 
#                          Tim Dawson <tdawson%mspboss@uunet.UU.NET>
telesis-licman  1380/tcp   Telesis Network License Manager     
telesis-licman  1380/udp   Telesis Network License Manager     
#                          Karl Schendel, Jr. <wiz@telesis.com>
apple-licman    1381/tcp   Apple Network License Manager 
apple-licman    1381/udp   Apple Network License Manager 
#                          Earl Wallace <earlw@apple.com>
udt_os          1382/tcp   
udt_os          1382/udp   
gwha            1383/tcp   GW Hannaway Network License Manager
gwha            1383/udp   GW Hannaway Network License Manager
#                          J. Gabriel Foster <fop@gwha.com>
os-licman       1384/tcp   Objective Solutions License Manager 
os-licman       1384/udp   Objective Solutions License Manager 
#               Donald Cornwell <don.cornwell@objective.com>
atex_elmd       1385/tcp   Atex Publishing License Manager
atex_elmd       1385/udp   Atex Publishing License Manager
#                          Brett Sorenson <bcs@atex.com>
checksum        1386/tcp   CheckSum License Manager            
checksum        1386/udp   CheckSum License Manager            
#                          Andreas Glocker <glocker@sirius.com>
cadsi-lm        1387/tcp   Computer Aided Design Software Inc LM 
cadsi-lm        1387/udp   Computer Aided Design Software Inc LM 
#                          Sulistio Muljadi
objective-dbc   1388/tcp   Objective Solutions DataBase Cache
objective-dbc   1388/udp   Objective Solutions DataBase Cache
#                          Donald Cornwell
iclpv-dm        1389/tcp   Document Manager                    
iclpv-dm        1389/udp   Document Manager                    
iclpv-sc        1390/tcp   Storage Controller                  
iclpv-sc        1390/udp   Storage Controller                  
iclpv-sas       1391/tcp   Storage Access Server               
iclpv-sas       1391/udp   Storage Access Server               
iclpv-pm        1392/tcp   Print Manager                       
iclpv-pm        1392/udp   Print Manager                       
iclpv-nls       1393/tcp   Network Log Server                  
iclpv-nls       1393/udp   Network Log Server                  
iclpv-nlc       1394/tcp   Network Log Client                  
iclpv-nlc       1394/udp   Network Log Client                  
iclpv-wsm       1395/tcp   PC Workstation Manager software     
iclpv-wsm       1395/udp   PC Workstation Manager software     
#               A.P. Hobson <A.P.Hobson@bra0112.wins.icl.co.uk>
dvl-activemail  1396/tcp   DVL Active Mail                     
dvl-activemail  1396/udp   DVL Active Mail                     
audio-activmail 1397/tcp   Audio Active Mail                   
audio-activmail 1397/udp   Audio Active Mail                   
video-activmail 1398/tcp   Video Active Mail                   
video-activmail 1398/udp   Video Active Mail                   
#                          Ehud Shapiro <udi@wisdon.weizmann.ac.il>
cadkey-licman   1399/tcp   Cadkey License Manager         
cadkey-licman   1399/udp   Cadkey License Manager         
cadkey-tablet   1400/tcp   Cadkey Tablet Daemon           
cadkey-tablet   1400/udp   Cadkey Tablet Daemon           
#                          Joe McCollough <joe@cadkey.com>
goldleaf-licman 1401/tcp   Goldleaf License Manager
goldleaf-licman 1401/udp   Goldleaf License Manager
#                          John Fox <---none--->
prm-sm-np       1402/tcp   Prospero Resource Manager
prm-sm-np       1402/udp   Prospero Resource Manager
prm-nm-np       1403/tcp   Prospero Resource Manager
prm-nm-np       1403/udp   Prospero Resource Manager
#                          B. Clifford Neuman <bcn@isi.edu>
igi-lm          1404/tcp   Infinite Graphics License Manager
igi-lm          1404/udp   Infinite Graphics License Manager
ibm-res         1405/tcp   IBM Remote Execution Starter
ibm-res         1405/udp   IBM Remote Execution Starter
netlabs-lm      1406/tcp   NetLabs License Manager
netlabs-lm      1406/udp   NetLabs License Manager
dbsa-lm         1407/tcp   DBSA License Manager        
dbsa-lm         1407/udp   DBSA License Manager        
#                          Scott Shattuck <ss@dbsa.com>
sophia-lm       1408/tcp   Sophia License Manager              
sophia-lm       1408/udp   Sophia License Manager              
#                          Eric Brown <sst!emerald!eric@uunet.UU.net>
here-lm         1409/tcp   Here License Manager             
here-lm         1409/udp   Here License Manager             
#                          David Ison  <here@dialup.oar.net>
hiq             1410/tcp   HiQ License Manager               
hiq             1410/udp   HiQ License Manager               
#                          Rick Pugh <rick@bilmillennium.com>
af              1411/tcp   AudioFile                  
af              1411/udp   AudioFile                  
#                          Jim Gettys <jg@crl.dec.com>
innosys         1412/tcp   InnoSys               
innosys         1412/udp   InnoSys               
innosys-acl     1413/tcp   Innosys-ACL           
innosys-acl     1413/udp   Innosys-ACL           
#                          Eric Welch <--none--->
ibm-mqseries    1414/tcp   IBM MQSeries                        
ibm-mqseries    1414/udp   IBM MQSeries                        
#                          Roger Meli <rmmeli%winvmd@vnet.ibm.com>
dbstar          1415/tcp   DBStar                          
dbstar          1415/udp   DBStar                          
#                          Jeffrey Millman <jcm@dbstar.com>
novell-lu6.2    1416/tcp   Novell LU6.2         
novell-lu6.2    1416/udp   Novell LU6.2         
#                          Peter Liu <--none--->
timbuktu-srv1   1417/tcp   Timbuktu Service 1 Port            
timbuktu-srv1   1417/tcp   Timbuktu Service 1 Port            
timbuktu-srv2   1418/tcp   Timbuktu Service 2 Port            
timbuktu-srv2   1418/udp   Timbuktu Service 2 Port            
timbuktu-srv3   1419/tcp   Timbuktu Service 3 Port            
timbuktu-srv3   1419/udp   Timbuktu Service 3 Port            
timbuktu-srv4   1420/tcp   Timbuktu Service 4 Port            
timbuktu-srv4   1420/udp   Timbuktu Service 4 Port            
#                          Marc Epard <marc@waygate.farallon.com>
gandalf-lm      1421/tcp   Gandalf License Manager
gandalf-lm      1421/udp   Gandalf License Manager
#                          gilmer@gandalf.ca
autodesk-lm     1422/tcp   Autodesk License Manager   
autodesk-lm     1422/udp   Autodesk License Manager   
#                          David Ko <dko@autodesk.com>
essbase         1423/tcp   Essbase Arbor Software     
essbase         1423/udp   Essbase Arbor Software     
hybrid          1424/tcp   Hybrid Encryption Protocol  
hybrid          1424/udp   Hybrid Encryption Protocol  
#                          Howard Hart <hch@hybrid.com>
zion-lm         1425/tcp   Zion Software License Manager 
zion-lm         1425/udp   Zion Software License Manager 
#                          David Ferrero <david@zion.com>
sais            1426/tcp   Satellite-data Acquisition System 1
sais            1426/udp   Satellite-data Acquisition System 1
#                          Bill Taylor <sais@ssec.wisc.edu>
mloadd          1427/tcp   mloadd monitoring tool     
mloadd          1427/udp   mloadd monitoring tool     
#                          Bob Braden <braden@isi.edu>
informatik-lm   1428/tcp   Informatik License Manager
informatik-lm   1428/udp   Informatik License Manager
#                          Harald Schlangmann
#                          <schlangm@informatik.uni-muenchen.de> 
nms             1429/tcp   Hypercom NMS                      
nms             1429/udp   Hypercom NMS                      
tpdu            1430/tcp   Hypercom TPDU                     
tpdu            1430/udp   Hypercom TPDU                     
#                          Noor Chowdhury <noor@hypercom.com>
rgtp            1431/tcp   Reverse Gossip Transport
rgtp            1431/udp   Reverse Gossip Transport
#                          Ian Jackson  <iwj@cam-orl.co.uk>
blueberry-lm    1432/tcp   Blueberry Software License Manager  
blueberry-lm    1432/udp   Blueberry Software License Manager  
#                          Steve Beigel <ublueb!steve@uunet.uu.net>
ms-sql-s        1433/tcp   Microsoft-SQL-Server 
ms-sql-s        1433/udp   Microsoft-SQL-Server 
ms-sql-m        1434/tcp   Microsoft-SQL-Monitor
ms-sql-m        1434/udp   Microsoft-SQL-Monitor                
#                          Peter Hussey <peterhus@microsoft.com>
ibm-cics        1435/tcp   IBM CICS
ibm-cics        1435/udp   IBM CICS
#                          Geoff Meacock <gbibmswl@ibmmail.COM>
saism           1436/tcp   Satellite-data Acquisition System 2
saism           1436/udp   Satellite-data Acquisition System 2
#                          Bill Taylor <sais@ssec.wisc.edu>
tabula          1437/tcp   Tabula
tabula          1437/udp   Tabula
#                          Marcelo Einhorn
#                          <KGUNE%HUJIVM1.bitnet@taunivm.tau.ac.il> 
eicon-server    1438/tcp   Eicon Security Agent/Server         
eicon-server    1438/udp   Eicon Security Agent/Server         
eicon-x25       1439/tcp   Eicon X25/SNA Gateway               
eicon-x25       1439/udp   Eicon X25/SNA Gateway               
eicon-slp       1440/tcp   Eicon Service Location Protocol     
eicon-slp       1440/udp   Eicon Service Location Protocol     
#                          Pat Calhoun <CALHOUN@admin.eicon.qc.ca>
cadis-1         1441/tcp   Cadis License Management       
cadis-1         1441/udp   Cadis License Management       
cadis-2         1442/tcp   Cadis License Management       
cadis-2         1442/udp   Cadis License Management       
#                          Todd Wichers <twichers@csn.org>
ies-lm          1443/tcp   Integrated Engineering Software     
ies-lm          1443/udp   Integrated Engineering Software     
#                          David Tong <David_Tong@integrated.mb.ca>
marcam-lm       1444/tcp   Marcam  License Management    
marcam-lm       1444/udp   Marcam  License Management    
#                          Therese Hunt <hunt@marcam.com>
proxima-lm      1445/tcp   Proxima License Manager       
proxima-lm      1445/udp   Proxima License Manager       
ora-lm          1446/tcp   Optical Research Associates License Manager
ora-lm          1446/udp   Optical Research Associates License Manager
apri-lm         1447/tcp   Applied Parallel Research LM
apri-lm         1447/udp   Applied Parallel Research LM
#                          Jim Dillon <jed@apri.com>
oc-lm           1448/tcp   OpenConnect License Manager
oc-lm           1448/udp   OpenConnect License Manager
#                          Sue Barnhill <snb@oc.com>
peport          1449/tcp   PEport                               
peport          1449/udp   PEport                               
#                          Qentin Neill <quentin@ColumbiaSC.NCR.COM>
dwf             1450/tcp   Tandem Distributed Workbench Facility 
dwf             1450/udp   Tandem Distributed Workbench Facility 
#                          Mike Bert <BERG_MIKE@tandem.com>
infoman         1451/tcp   IBM Information Management
infoman         1451/udp   IBM Information Management
#                          Karen Burns <---none--->
gtegsc-lm       1452/tcp   GTE Government Systems License Man   
gtegsc-lm       1452/udp   GTE Government Systems License Man   
#               Mike Gregory <Gregory_Mike@msmail.iipo.gtegsc.com>
genie-lm        1453/tcp   Genie License Manager                
genie-lm        1453/udp   Genie License Manager                
#                          Paul Applegate <p.applegate2@genie.geis.com>
interhdl_elmd   1454/tcp   interHDL License Manager      
interhdl_elmd   1454/tcp   interHDL License Manager      
#                          Eli Sternheim eli@interhdl.com
esl-lm          1455/tcp   ESL License Manager           
esl-lm          1455/udp   ESL License Manager           
#                          Abel Chou <abel@willy.esl.com>
dca             1456/tcp   DCA           
dca             1456/udp   DCA           
#                          Jeff Garbers <jgarbers@netcom.com>
valisys-lm      1457/tcp    Valisys License Manager
valisys-lm      1457/udp    Valisys License Manager
#               Leslie Lincoln <leslie_lincoln@valisys.com>
nrcabq-lm       1458/tcp    Nichols Research Corp.
nrcabq-lm       1458/udp    Nichols Research Corp.
#                           Howard Cole <hcole@tumbleweed.nrcabq.com>
proshare1       1459/tcp    Proshare Notebook Application
proshare1       1459/udp    Proshare Notebook Application
proshare2       1460/tcp    Proshare Notebook Application
proshare2       1460/udp    Proshare Notebook Application
#                           Robin Kar <Robin_Kar@ccm.hf.intel.com>
ibm_wrless_lan  1461/tcp    IBM Wireless LAN 
ibm_wrless_lan  1461/udp    IBM Wireless LAN 
#                           <flanne@vnet.IBM.COM>
world-lm        1462/tcp    World License Manager
world-lm        1462/udp    World License Manager
#                           Michael S Amirault <ambi@world.std.com>
nucleus         1463/tcp    Nucleus
nucleus         1463/udp    Nucleus
#                           Venky Nagar <venky@fafner.Stanford.EDU>
msl_lmd         1464/tcp    MSL License Manager
msl_lmd         1464/udp    MSL License Manager
#                           Matt Timmermans
pipes           1465/tcp    Pipes Platform 
pipes           1465/udp    Pipes Platform  mfarlin@peerlogic.com
#                           Mark Farlin <mfarlin@peerlogic.com>
oceansoft-lm    1466/tcp    Ocean Software License Manager
oceansoft-lm    1466/udp    Ocean Software License Manager
#                           Randy Leonard <randy@oceansoft.com>
csdmbase        1467/tcp    CSDMBASE  
csdmbase        1467/udp    CSDMBASE  
csdm            1468/tcp    CSDM      
csdm            1468/udp    CSDM      
#               Robert Stabl <stabl@informatik.uni-muenchen.de>
aal-lm          1469/tcp    Active Analysis Limited License Manager
aal-lm          1469/udp    Active Analysis Limited License Manager
#                           David Snocken  +44 (71)437-7009
uaiact          1470/tcp    Universal Analytics  
uaiact          1470/udp    Universal Analytics  
#                           Mark R. Ludwig <Mark-Ludwig@uai.com>
csdmbase        1471/tcp    csdmbase   
csdmbase        1471/udp    csdmbase   
csdm            1472/tcp    csdm       
csdm            1472/udp    csdm       
#               Robert Stabl <stabl@informatik.uni-muenchen.de>
openmath        1473/tcp    OpenMath   
openmath        1473/udp    OpenMath   
#                           Garth Mayville <mayville@maplesoft.on.ca>
telefinder      1474/tcp    Telefinder 
telefinder      1474/udp    Telefinder 
#                           Jim White <Jim_White@spiderisland.com>
taligent-lm     1475/tcp    Taligent License Manager  
taligent-lm     1475/udp    Taligent License Manager  
#               Mark Sapsford <Mark_Sapsford@@taligent.com>
clvm-cfg        1476/tcp    clvm-cfg  
clvm-cfg        1476/udp    clvm-cfg  
#                           Eric Soderberg <seric@cup.hp.com>
ms-sna-server   1477/tcp    ms-sna-server  
ms-sna-server   1477/udp    ms-sna-server  
ms-sna-base     1478/tcp    ms-sna-base    
ms-sna-base     1478/udp    ms-sna-base    
#                           Gordon Mangione <gordm@microsoft.com>
dberegister     1479/tcp    dberegister  
dberegister     1479/udp    dberegister  
#                           Brian Griswold <brian@dancingbear.com>
pacerforum      1480/tcp    PacerForum  
pacerforum      1480/udp    PacerForum  
#                           Peter Caswell <pfc@pacvax.pacersoft.com>
airs            1481/tcp    AIRS        
airs            1481/udp    AIRS        
#                           Bruce Wilson, 905-771-6161
miteksys-lm     1482/tcp    Miteksys License Manager
miteksys-lm     1482/udp    Miteksys License Manager
#                           Shane McRoberts <mcroberts@miteksys.com>
afs             1483/tcp    AFS License Manager   
afs             1483/udp    AFS License Manager   
#                           Michael R. Pizolato <michael@afs.com>
confluent       1484/tcp    Confluent License Manager 
confluent       1484/udp    Confluent License Manager 
#                           James Greenfiel <jim@pa.confluent.com>
lansource       1485/tcp    LANSource 
lansource       1485/udp    LANSource 
#                           Doug Scott <lansourc@hookup.net>
nms_topo_serv   1486/tcp    nms_topo_serv  
nms_topo_serv   1486/udp    nms_topo_serv  
#                           Sylvia Siu <Sylvia_Siu@Novell.CO>
localinfosrvr   1487/tcp    LocalInfoSrvr  
localinfosrvr   1487/udp    LocalInfoSrvr  
#               Brian Matthews <brian_matthews@ibist.ibis.com>
docstor         1488/tcp    DocStor  
docstor         1488/udp    DocStor  
#                           Brian Spears <bspears@salix.com>
dmdocbroker     1489/tcp    dmdocbroker  
dmdocbroker     1489/udp    dmdocbroker  
#                           Razmik Abnous <abnous@documentum.com>
insitu-conf     1490/tcp    insitu-conf  
insitu-conf     1490/udp    insitu-conf  
#                           Paul Blacknell <paul@insitu.com>
anynetgateway   1491/tcp    anynetgateway  
anynetgateway   1491/udp    anynetgateway  
#                           Dan Poirier <poirier@VNET.IBM.COM>
stone-design-1  1492/tcp    stone-design-1  
stone-design-1  1492/udp    stone-design-1  
#                           Andrew Stone <andrew@stone.com>
netmap_lm       1493/tcp    netmap_lm  
netmap_lm       1493/udp    netmap_lm  
#                           Phillip Magson <philm@extro.ucc.su.OZ.AU>
ica             1494/tcp    ica   
ica             1494/udp    ica   
#                           John Richardson, Citrix Systems
cvc             1495/tcp    cvc  
cvc             1495/udp    cvc  
#                           Bill Davidson <billd@equalizer.cray.com>
liberty-lm      1496/tcp    liberty-lm
liberty-lm      1496/udp    liberty-lm
#                           Jim Rogers <trane!jimbo@pacbell.com>
rfx-lm          1497/tcp    rfx-lm
rfx-lm          1497/udp    rfx-lm
#                           Bill Bishop <bil@rfx.rfx.com>
sybase-sqlany   1498/tcp    Sybase SQL Any
sybase-sqlany   1498/udp    Sybase SQL Any
#                           Dave Neudoerffer <Dave.Neudoerffer@sybase.com>
fhc             1499/tcp    Federico Heinz Consultora
fhc             1499/udp    Federico Heinz Consultora
#                           Federico Heinz <federico@heinz.com>
vlsi-lm         1500/tcp    VLSI License Manager
vlsi-lm         1500/udp    VLSI License Manager
#                           Shue-Lin Kuo <shuelin@mdk.sanjose.vlsi.com>
saiscm          1501/tcp    Satellite-data Acquisition System 3 
saiscm          1501/udp    Satellite-data Acquisition System 3 
#                           Bill Taylor <sais@ssec.wisc.edu>
shivadiscovery  1502/tcp    Shiva
shivadiscovery  1502/udp    Shiva
#                           Jonathan Wenocur <jhw@Shiva.COM>
imtc-mcs        1503/tcp    Databeam
imtc-mcs        1503/udp    Databeam
#                           Jim Johnston <jjohnston@databeam.com>
evb-elm         1504/tcp    EVB Software Engineering License Manager
evb-elm         1504/udp    EVB Software Engineering License Manager
#                           B.G. Mahesh < mahesh@sett.com>
funkproxy       1505/tcp    Funk Software, Inc.
funkproxy       1505/udp    Funk Software, Inc.
#                           Robert D. Vincent <bert@willowpond.com>
utcd            1506/tcp    Universal Time daemon (utcd)
utcd            1506/udp    Universal Time daemon (utcd)
#                           Walter Poxon <wdp@ironwood.cray.com>
symplex         1507/tcp    symplex
symplex         1507/udp    symplex
#                           Mike Turley <turley@symplex.com>
diagmond        1508/tcp    diagmond
diagmond        1508/udp    diagmond
#                           Pete Moscatelli <moscat@hprdstl0.rose.hp.com>
robcad-lm       1509/tcp    Robcad, Ltd. License Manager
robcad-lm       1509/udp    Robcad, Ltd. License Manager
#                           Hindin Joseph <hindin%robcad@uunet.uu.net>
mvx-lm          1510/tcp    Midland Valley Exploration Ltd. Lic. Man.
mvx-lm          1510/udp    Midland Valley Exploration Ltd. Lic. Man.
#                           Neil Salter <neil@indigo2.mvel.demon.co.uk>Laszlo
3l-l1           1511/tcp    3l-l1
3l-l1           1511/udp    3l-l1
#                           Ian A. Young <iay@threel.co.uk>
wins            1512/tcp    Microsoft's Windows Internet Name Service
wins            1512/udp    Microsoft's Windows Internet Name Service
#                           Pradeep Bahl <pradeepb@microsoft.com>
fujitsu-dtc     1513/tcp    Fujitsu Systems Business of America, Inc
fujitsu-dtc     1513/udp    Fujitsu Systems Business of America, Inc
fujitsu-dtcns   1514/tcp    Fujitsu Systems Business of America, Inc
fujitsu-dtcns   1514/udp    Fujitsu Systems Business of America, Inc
#                           Charles A. Higgins <75730.2257@compuserve.com>
ifor-protocol   1515/tcp    ifor-protocol
ifor-protocol   1515/udp    ifor-protocol
#                           Dr. R.P. Alston <robin@gradient.com>
vpad            1516/tcp    Virtual Places Audio data
vpad            1516/udp    Virtual Places Audio data
vpac            1517/tcp    Virtual Places Audio control
vpac            1517/udp    Virtual Places Audio control
vpvd            1518/tcp    Virtual Places Video data
vpvd            1518/udp    Virtual Places Video data
vpvc            1519/tcp    Virtual Places Video control
vpvc            1519/udp    Virtual Places Video control
#                           Ehud Shapiro <udi@ubique.co.il>
atm-zip-office  1520/tcp    atm zip office
atm-zip-office  1520/udp    atm zip office
#                           Wilson Kwan <wilsonk%toronto@zip.atm.com>
ncube-lm        1521/tcp    nCube License Manager
ncube-lm        1521/udp    nCube License Manager
#                           Maxine Yuen <maxine@hq.ncube.com>
ricardo-lm      1522/tcp    Ricardo North America License Manager
ricardo-lm      1522/udp    Ricardo North America License Manager
#                           Mike Flemming <mf@xnet.com>
cichild-lm      1523/tcp    cichild
cichild-lm      1523/udp    cichild
#                           Andy Burgess <aab@cichlid.com>
ingreslock	1524/tcp    ingres
ingreslock	1524/udp    ingres
orasrv          1525/tcp    oracle
orasrv          1525/udp    oracle
prospero-np     1525/tcp    Prospero Directory Service non-priv
prospero-np     1525/udp    Prospero Directory Service non-priv
pdap-np         1526/tcp    Prospero Data Access Prot non-priv 
pdap-np         1526/udp    Prospero Data Access Prot non-priv 
#                           B. Clifford Neuman <bcn@isi.edu>
tlisrv          1527/tcp    oracle
tlisrv          1527/udp    oracle
mciautoreg      1528/tcp    micautoreg
mciautoreg      1528/udp    micautoreg
#                           John Klensin <klensin@MAIL1.RESTON.MCI.NET>
coauthor        1529/tcp    oracle
coauthor        1529/udp    oracle
rap-service     1530/tcp    rap-service
rap-service     1530/udp    rap-service
rap-listen      1531/tcp    rap-listen
rap-listen      1531/udp    rap-listen
#                           Phil Servita <meister@ftp.com>
miroconnect     1532/tcp    miroconnect
miroconnect     1532/udp    miroconnect
#                           Michael Fischer +49 531 21 13 0
virtual-places  1533/tcp    Virtual Places Software
virtual-places  1533/udp    Virtual Places Software
#                           Ehud Shapiro <udi@ubique.co.il> 
micromuse-lm    1534/tcp    micromuse-lm    
micromuse-lm    1534/udp    micromuse-lm    
#                           Adam Kerrison <adam@micromuse.co.uk>
ampr-info       1535/tcp    ampr-info    
ampr-info       1535/udp    ampr-info    
ampr-inter      1536/tcp    ampr-inter
ampr-inter      1536/udp    ampr-inter
#                           Rob Janssen <rob@sys3.pe1chl.ampr.org>
sdsc-lm         1537/tcp    isi-lm
sdsc-lm         1537/udp    isi-lm
#                           Len Wanger <lrw@sdsc.edu>
3ds-lm          1538/tcp    3ds-lm
3ds-lm          1538/udp    3ds-lm
#                           Keith Trummel <ktrummel@autodesk.com>
intellistor-lm  1539/tcp    Intellistor License Manager
intellistor-lm  1539/udp    Intellistor License Manager
#                           Ron Vaughn <rv@intellistor.com>
rds             1540/tcp    rds
rds             1540/udp    rds
rds2            1541/tcp    rds2
rds2            1541/udp    rds2
#                           Sudhakar Rajamannar <mobius1@cerfnet.com>
gridgen-elmd    1542/tcp    gridgen-elmd
gridgen-elmd    1542/udp    gridgen-elmd
#                           John R. Chawner +1 817 354-1004
simba-cs        1543/tcp    simba-cs
simba-cs        1543/udp    simba-cs
#                           Betsy Alexander +1 604-681-4549
aspeclmd        1544/tcp    aspeclmd
aspeclmd        1544/udp    aspeclmd
#                           V. Balaji <balaji@aspec.com>
vistium-share   1545/tcp    vistium-share
vistium-share   1545/udp    vistium-share
#             Allison Carleton <acarleto@naper1.napervilleil.ncr.com>
abbaccuray      1546/tcp    abbaccuray
abbaccuray      1546/udp    abbaccuray
#                           John Wendt 614-261-2000
laplink         1547/tcp    laplink
laplink         1547/udp    laplink
#                        Michael Crawford <MichaelC@dev.travsoft.com>
axon-lm         1548/tcp    Axon License Manager
axon-lm         1548/udp    Axon License Manager
#   Mark Pearce <<Mark_A.._Pearce/AXON_Networks_Inc..@notes.axon.com>
shivahose       1549/tcp    Shiva Hose
shivasound      1549/udp    Shiva Sound
#                           Kin Chan <kchan@shiva.com>
3m-image-lm     1550/tcp    Image Storage license manager 3M Company
3m-image-lm     1550/udp    Image Storage license manager 3M Company
#                           J. C. Canessa <jccanessa@mmm.com>
hecmtl-db       1551/tcp    HECMTL-DB
hecmtl-db       1551/udp    HECMTL-DB
#                           Maxime Belanger <R173@hec.ca>
pciarray        1552/tcp    pciarray
pciarray        1552/udp    pciarray
#                           Ron Folk <rfolkes@avl.com>
sna-cs          1553/tcp    sna-cs
sna-cs          1553/udp    sna-cs
#                           Tony Sowter <ts@datcon.co.uk>
caci-lm         1554/tcp    CACI Products Company License Manager
caci-lm         1554/udp    CACI Products Company License Manager
#                           Erik Blume <erikb@caciasl.com>
livelan         1555/tcp    livelan
livelan         1555/udp    livelan
#                    khedayat@roadrunner.pictel.com <Kaynam Hedayat>
ashwin          1556/tcp    AshWin CI Tecnologies
ashwin          1556/udp    AshWin CI Tecnologies
#                           Dave Neal <daven@ashwin.com>
arbortext-lm    1557/tcp    ArborText License Manager
arbortext-lm    1557/udp    ArborText License Manager
#                           David J. Wilson <djw@arbortext.com>
xingmpeg        1558/tcp    xingmpeg
xingmpeg        1558/udp    xingmpeg
#                           Howard Gordon <hgordon@system.xingtech.com>
web2host        1559/tcp    web2host
web2host        1559/udp    web2host
#                           Stephen Johnson <sjohnson@mindspring.com>
asci-val        1560/tcp    asci-val
asci-val        1560/udp    asci-val
#                           Brian Schenkenberger <brians@advsyscon.com>
facilityview    1561/tcp    facilityview
facilityview    1561/udp    facilityview
#                           Ed Green <egreen@pmeasuring.com>
pconnectmgr     1562/tcp    pconnectmgr
pconnectmgr     1562/udp    pconnectmgr
#                           Bob Kaiser <BKaiser@palindrome.com>
cadabra-lm      1563/tcp    Cadabra License Manager
cadabra-lm      1563/udp    Cadabra License Manager
#                           Arthur Castonguay <arthurc@doe.carleton.ca>
pay-per-view    1564/tcp    Pay-Per-View
pay-per-view    1564/udp    Pay-Per-View
#                           Brian Tung <brian@isi.edu>
winddlb         1565/tcp    WinDD
winddlb         1565/udp    WinDD
#                           Kelly Sims <kellys@garnet.wv.tek.com>
corelvideo      1566/tcp    CORELVIDEO
corelvideo      1566/udp    CORELVIDEO
#                           Ming Poon <mingp@corel.ca>
jlicelmd        1567/tcp    jlicelmd
jlicelmd        1567/udp    jlicelmd
#                   Christian Schormann <100410.3063@compuserve.com>
tsspmap         1568/tcp    tsspmap
tsspmap         1568/udp    tsspmap
#                           Paul W. Nelson <nelson@thursby.com>
ets             1569/tcp    ets
ets             1569/udp    ets
#                           Carstein Seeberg <case@boole.no> 
orbixd          1570/tcp    orbixd
orbixd          1570/udp    orbixd
#                           Bridget Walsh <bwalsh@iona.ie>
rdb-dbs-disp    1571/tcp    Oracle Remote Data Base
rdb-dbs-disp    1571/udp    Oracle Remote Data Base
#                           <mackin@us.oracle.com>
chip-lm         1572/tcp    Chipcom License Manager
chip-lm         1572/udp    Chipcom License Manager
#                           Jerry Natowitz <Jerry Natowitz>
itscomm-ns      1573/tcp    itscomm-ns
itscomm-ns      1573/udp    itscomm-ns
#                           Rich Thompson <richt@watson.ibm.com>
mvel-lm         1574/tcp    mvel-lm
mvel-lm         1574/udp    mvel-lm
#                           David Bisset <dbisset@mvel.demon.co.uk>
oraclenames     1575/tcp    oraclenames
oraclenames     1575/udp    oraclenames
#                           P.V.Shivkumar <PSHIVKUM@us.oracle.com>
moldflow-lm     1576/tcp    moldflow-lm
moldflow-lm     1576/udp    moldflow-lm
#                           Paul Browne <browne@moldflow.com.au>
hypercube-lm    1577/tcp    hypercube-lm
hypercube-lm    1577/udp    hypercube-lm
#                           Christopher McLendon <cem@hyper.com>
jacobus-lm      1578/tcp    Jacobus License Manager
jacobus-lm      1578/udp    Jacobus License Manager
#                           Tony Cleveland <tony.cleveland@jacobus.com>
ioc-sea-lm      1579/tcp    ioc-sea-lm
ioc-sea-lm      1579/tcp    ioc-sea-lm
#                           Paul Nelson <paul@ioc-sea.com>
tn-tl-r1        1580/tcp    tn-tl-r1
tn-tl-r2        1580/udp    tn-tl-r2
#                           Ed Kress <eskress@thinknet.com>
vmf-msg-port    1581/tcp    vmf-msg-port
vmf-msg-port    1581/udp    vmf-msg-port
#                           Eric Whitehill <eawhiteh@itt.com>
msims           1582/tcp    MSIMS
msims           1582/udp    MSIMS
#                           Glenn Olander <gjo@msi.com>
simbaexpress    1583/tcp    simbaexpress
simbaexpress    1583/udp    simbaexpress
#                           Betsy Alexander +1 604-681-4549
tn-tl-fd2       1584/tcp    tn-tl-fd2
tn-tl-fd2       1584/udp    tn-tl-fd2
#                           Ed Kress <eskress@thinknet.com>
intv            1585/tcp    intv
intv            1585/udp    intv
#                           Dermot Tynand <dtynan@claddagh.ie>
ibm-abtact      1586/tcp    ibm-abtact
ibm-abtact      1586/udp    ibm-abtact
#                           Sandeep K. Singhal <singhal@CS.Stanford.EDU>
pra_elmd        1587/tcp    pra_elmd
pra_elmd        1587/udp    pra_elmd
#                           Dennis Mastin <dennis@tasmania.platte.com>
triquest-lm     1588/tcp    triquest-lm 
triquest-lm     1588/udp    triquest-lm 
#                           Nand Kumar <nkumar@triquest-da.com>
vqp             1589/tcp    VQP
vqp             1589/udp    VQP
#                           Keith McCloghrie <kzm@cisco.com>
gemini-lm       1590/tcp    gemini-lm
gemini-lm       1590/udp    gemini-lm
#                           Tony Sawyer <tonys@gemtech.com>
ncpm-pm         1591/tcp    ncpm-pm
ncpm-pm         1591/udp    ncpm-pm
#                           Ted Power <tedp@hpinpcb.cup.hp.com>
commonspace     1592/tcp    commonspace
commonspace     1592/udp    commonspace
#                           Rob Chandhok <chandhok@within.com>
mainsoft-lm     1593/tcp    mainsoft-lm
mainsoft-lm     1593/udp    mainsoft-lm
#                           Anand Gangadharan <anand@goa.mainsoft.com>
sixtrak         1594/tcp    sixtrak
sixtrak         1594/udp    sixtrak
#                           Bob Rennie <rjrennie@wizvax.net>
radio           1595/tcp    radio
radio           1595/udp    radio
radio-sm        1596/tcp    radio-sm
radio-bc        1596/udp    radio-bc
#                           Ken Chapman <kchapman@isis.com>
orbplus-iiop    1597/tcp    orbplus-iiop
orbplus-iiop    1597/udp    orbplus-iiop
#                           Robert A. Kukura <kukura@apollo.hp.com>
picknfs         1598/tcp    picknfs
picknfs         1598/udp    picknfs
#                           John Lombardo <johnl@picksys.com>
simbaservices   1599/tcp    simbaservices
simbaservices   1599/udp    simbaservices
#                           Betsy Alexander +1 604-681-4549
issd		1600/tcp
issd		1600/udp
aas             1601/tcp   aas
aas             1601/udp   aas
#                          Bob Beard <bobb@lachman.com>
inspect         1602/tcp   inspect
inspect         1602/udp   inspect
#                          Frank O'Neill <frank@morse.ilo.dec.com>
picodbc         1603/tcp   pickodbc
picodbc         1603/udp   pickodbc
#                          John Lombardo <johnl@picksys.com>
icabrowser      1604/tcp   icabrowser
icabrowser      1604/udp   icabrowser
#                          Brad Pedersen <bradp@citrix.com>       
slp             1605/tcp   Salutation Manager (Salutation Protocol)
slp             1605/udp   Salutation Manager (Salutation Protocol)
slm-api         1606/tcp   Salutation Manager (SLM-API)
slm-api         1606/udp   Salutation Manager (SLM-API)
#                          Tohru Mori <tmori@VNET.IBM.COM>       
stt             1607/tcp   stt
stt             1607/udp   stt
#                          Ryan Bolz <ryanbo@microsoft.com>
smart-lm        1608/tcp   Smart Corp. License Manager
smart-lm        1608/udp   Smart Corp. License Manager
#                          Connie Qiu <connie@scdb.com>
isysg-lm        1609/tcp   isysg-lm
isysg-lm        1609/udp   isysg-lm
#                          Adam Curtin <adam.curtin@isysg.com>
taurus-wh       1610/tcp   taurus-wh
taurus-wh       1610/udp   taurus-wh
#                          Jeff Moffatt <jeff@taurus.com>
ill             1611/tcp   Inter Library Loan
ill             1611/udp   Inter Library Loan
#                          Niall Murphy <niallm@orca.ucd.ie>

netbill-trans   1612/tcp   NetBill Transaction Server
netbill-trans   1612/udp   NetBill Transaction Server
netbill-keyrep  1613/tcp   NetBill Key Repository
netbill-keyrep  1613/udp   NetBill Key Repository
netbill-cred    1614/tcp   NetBill Credential Server
netbill-cred    1614/udp   NetBill Credential Server
netbill-auth    1615/tcp   NetBill Authorization Server
netbill-auth    1615/udp   NetBill Authorization Server
netbill-prod    1616/tcp   NetBill Product Server
netbill-prod    1616/udp   NetBill Product Server
#                          Marvin Sirbu <sirbu+@andrew.cmu.edu>
nimrod-agent    1617/tcp   Nimrod Inter-Agent Communication
nimrod-agent    1617/udp   Nimrod Inter-Agent Communication
#                          Charles Lynn <clynn@bbn.com>
skytelnet       1618/tcp   skytelnet
skytelnet       1618/udp   skytelnet
#                          Byron Jones <byronj@bellsouth.net>
xs-openstorage  1619/tcp  xs-openstorage
xs-openstorage  1619/udp  xs-openstorage
#                         XuiS Software Ltd. 
                          <100322.2376@compuserve.com>
faxportwinport  1620/tcp  faxportwinport
faxportwinport  1620/udp  faxportwinport
#                         Chris Wells <chris_wells@lansource.com>
softdataphone   1621/tcp  softdataphone
softdataphone   1621/udp  softdataphone
#                         Dror Gill <drorgi@VNET.IBM.COM>n
ontime          1622/tcp  ontime
ontime          1622/udp  ontime
#                         Keith Rhodes 810-559-5955
jaleosnd        1623/tcp  jaleosnd
jaleosnd        1623/udp  jaleosnd
#                   Christian Schormann <100410.3063@compuserve.com>
udp-sr-port     1624/tcp  udp-sr-port
udp-sr-port     1624/udp  udp-sr-port
#                         Herb Jensen <HWJensen@nfsrv.avionics.itt.com>
svs-omagent     1625/tcp  svs-omagent
svs-omagent     1625/udp  svs-omagent
#                         Alberto Berlen <aberlen@VNET.IBM.COM>
cncp            1636/tcp  CableNet Control Protocol
cncp            1636/udp  CableNet Control Protocol
cnap            1637/tcp  CableNet Admin Protocol
cnap            1637/udp  CableNet Admin Protocol
cnip            1638/tcp  CableNet Info Protocol
cnip            1638/udp  CableNet Info Protocol
#                         Damian Hamill <damian@cablenet.net>
cert-initiator  1639/tcp  cert-initiator
cert-initiator  1639/udp  cert-initiator
cert-responder  1640/tcp  cert-responder
cert-responder  1640/udp  cert-responder
#                         Tom Markson <markson@osmosys.incog.com>
invision        1641/tcp  InVision
invision        1641/udp  InVision
#                         Christopher Davey <niallocl@quay.ie>
isis-am         1642/tcp  isis-am
isis-am         1642/udp  isis-am
isis-ambc       1643/tcp  isis-ambc
isis-ambc       1643/udp  isis-ambc
#                         Ken Chapman <kchapman@isis.com>
saiseh          1644/tcp  Satellite-data Acquisition System 4
#                         Bill Taylor <sais@ssec.wisc.edu>
datametrics     1645/tcp  datametrics
datametrics     1645/udp  datametrics
#                         Jerry Jongerius <jerryj@datametrics.com>
sa-msg-port     1646/tcp  sa-msg-port
sa-msg-port     1646/udp  sa-msg-port
#                         Eric Whitehill <eawhiteh@itt.com>
rsap            1647/tcp  rsap
rsap            1647/udp  rsap
#                         Holger Reif 
#                         <Holger.Reif@prakinf.tu-ilmenau.de> 
concurrent-lm   1648/tcp  concurrent-lm
concurrent-lm   1648/udp  concurrent-lm
#                         Maggie Brinsford <mjb@concurrent.co.uk>
inspect         1649/tcp  inspect
inspect         1649/udp  inspect
#                         Frank da Cruz <fdc@watsun.cc.columbia.edu>
nkd		1650/tcp  nkd
nkd		1650/udp  nkd
shiva_confsrvr  1651/tcp  shiva_confsrvr
shiva_confsrvr  1651/udp  shiva_confsrvr
#                         Mike Horowitz <mah@Shiva.COM>
xnmp            1652/tcp  xnmp
xnmp            1652/udp  xnmp
#                         Ali Saleh <scomm@cerf.net>
alphatech-lm    1653/tcp  alphatech-lm
alphatech-lm    1653/udp  alphatech-lm
#                         Joseph Hauk <joseph.hauk@alphatech.com>
stargatealerts  1654/tcp  stargatealerts
stargatealerts  1654/udp  stargatealerts
#                         Tim Coppernoll
#                         <Tim_Coppernoll@ccm.jf.intel.com>
dec-mbadmin     1655/tcp  dec-mbadmin
dec-mbadmin     1655/udp  dec-mbadmin
dec-mbadmin-h   1656/tcp  dec-mbadmin-h
dec-mbadmin-h   1656/udp  dec-mbadmin-h
#                         Nick Shipman <Nick.Shipman@mrmog.reo.dec.com>
fujitsu-mmpdc   1657/tcp  fujitsu-mmpdc
fujitsu-mmpdc   1657/udp  fujitsu-mmpdc
#                         Katsumi Oomuro <NAE01421@niftyserve.or.jp>
sixnetudr       1658/tcp  sixnetudr
sixnetudr       1658/udp  sixnetudr
#                         Bob Rennie <rjrennie@wizvax.net>
sg-lm           1659/tcp  Silicon Grail License Manager
sg-lm           1659/udp  Silicon Grail License Manager
#                         William R Bishop <wrb@world.std.com>
skip-mc-gikreq  1660/tcp  skip-mc-gikreq
skip-mc-gikreq  1660/udp  skip-mc-gikreq
#                         Tom Markson <markson@osmosys.incog.com>
netview-aix-1   1661/tcp  netview-aix-1
netview-aix-1   1661/udp  netview-aix-1
netview-aix-2   1662/tcp  netview-aix-2
netview-aix-2   1662/udp  netview-aix-2
netview-aix-3   1663/tcp  netview-aix-3
netview-aix-3   1663/udp  netview-aix-3
netview-aix-4   1664/tcp  netview-aix-4
netview-aix-4   1664/udp  netview-aix-4
netview-aix-5   1665/tcp  netview-aix-5
netview-aix-5   1665/udp  netview-aix-5
netview-aix-6   1666/tcp  netview-aix-6
netview-aix-6   1666/udp  netview-aix-6
netview-aix-7   1667/tcp  netview-aix-7
netview-aix-7   1667/udp  netview-aix-7
netview-aix-8   1668/tcp  netview-aix-8
netview-aix-8   1668/udp  netview-aix-8
netview-aix-9   1669/tcp  netview-aix-9
netview-aix-9   1669/udp  netview-aix-9
netview-aix-10  1670/tcp  netview-aix-10
netview-aix-10  1670/udp  netview-aix-10
netview-aix-11  1671/tcp  netview-aix-11
netview-aix-11  1671/udp  netview-aix-11
netview-aix-12  1672/tcp  netview-aix-12
netview-aix-12  1672/udp  netview-aix-12
#               Martha Crisson <CRISSON@ralvm12.vnet.ibm.com>
proshare-mc-1   1673/tcp  Intel Proshare Multicast
proshare-mc-1   1673/udp  Intel Proshare Multicast
proshare-mc-2   1674/tcp  Intel Proshare Multicast
proshare-mc-2   1674/udp  Intel Proshare Multicast
#               Mark Lewis <Mark_Lewis@ccm.jf.intel.com>
pdp             1675/tcp  Pacific Data Products
pdp             1675/udp  Pacific Data Products
#                         Gary Morton <mortong@pacdata.com>
netcomm1        1676/tcp  netcomm1
netcomm2        1676/udp  netcomm2
#                         Bulent Kasman <BKasman@symantec.com>
groupwise       1677/tcp  groupwise
groupwise       1677/udp  groupwise
#                         Brent Bradshaw <bbradshaw@novell.com>
prolink         1678/tcp  prolink
prolink         1678/udp  prolink
#                         Brian Abramson <brianab@soul.tv.tek.com>
darcorp-lm      1679/tcp  darcorp-lm
darcorp-lm      1679/udp  darcorp-lm
#                         <DARcorp@aol.com>
microcom-sbp    1680/tcp  microcom-sbp	
microcom-sbp    1680/udp  microcom-sbp	
#                         Boris B. Maiden <Boris_Maiden@smtp.microcom.com> 
sd-elmd         1681/tcp  sd-elmd
sd-elmd         1681/udp  sd-elmd
#                         Bryan Otey <bwo@softdesk.com>
lanyon-lantern  1682/tcp  lanyon-lantern
lanyon-lantern  1682/udp  lanyon-lantern
#                         Robin Lewis <robin.lewis@lanyon.com>
ncpm-hip        1683/tcp  ncpm-hip
ncpm-hip        1683/udp  ncpm-hip
#                         Ken Hearn <hearn@hpindacx.cup.hp.com>
snaresecure     1684/tcp  SnareSecure
snaresecure     1684/udp  SnareSecure
#                         Marty Batchelder <marty@capres.com>
n2nremote       1685/tcp  n2nremote
n2nremote       1685/udp  n2nremote
#                         Kin Chan <kchan@net2net.com>
cvmon           1686/tcp  cvmon
cvmon           1686/udp  cvmon
#                         Carol Ann Krug <carolann@hpmfas3.cup.hp.com>
nsjtp-ctrl      1687/tcp  nsjtp-ctrl
nsjtp-ctrl      1687/udp    nsjtp-ctrl
nsjtp-data      1688/tcp    nsjtp-data
nsjtp-data      1688/udp    nsjtp-data
#                           Orazio Granato <og@wsbgrd01.italy.hp.com>
firefox         1689/tcp    firefox
firefox         1689/udp    firefox
#                           Mark S. Edwards <marke@firefox.co.uk>
ng-umds         1690/tcp    ng-umds
ng-umds         1690/udp    ng-umds
#                           Louis E. Simard <76400.3371@compuserve.com>
empire-empuma   1691/tcp    empire-empuma
empire-empuma   1691/udp    empire-empuma
#                           Bobby Krupczak <rdk@empiretech.com>
sstsys-lm       1692/tcp    sstsys-lm
sstsys-lm       1692/udp    sstsys-lm
#                           Yih-Wu Wang <sstsys@ix.netcom.com>
rrirtr          1693/tcp    rrirtr
rrirtr          1693/udp    rrirtr
rrimwm          1694/tcp    rrimwm
rrimwm          1694/udp    rrimwm
rrilwm          1695/tcp    rrilwm
rrilwm          1695/udp    rrilwm
rrifmm          1696/tcp    rrifmm
rrifmm          1696/udp    rrifmm
rrisat          1697/tcp    rrisat
rrisat          1697/udp    rrisat
#                           Allen Briggs <briggs@access.rrinc.com>
rsvp-encap-1    1698/tcp    RSVP-ENCAPSULATION-1
rsvp-encap-1    1698/udp    RSVP-ENCAPSULATION-1
rsvp-encap-2    1699/tcp    RSVP-ENCAPSULATION-2
rsvp-encap-2    1699/udp    RSVP-ENCAPSULATION-2
#                           Bob Braden <braden@isi.edu>
mps-raft        1700/tcp    mps-raft
mps-raft        1700/udp    mps-raft
#                           Jason Leupen <Jleupen@aol.com>
l2f             1701/tcp    l2f
l2f             1701/udp    l2f
#                           Andy Valencia <vandys@vandys-lap.cisco.com>
deskshare       1702/tcp    deskshare
deskshare       1702/udp    deskshare
#                           Sarah Thompson <sarah@telergy.com
hb-engine       1703/tcp    hb-engine
hb-engine       1703/udp    hb-engine
#                           Charles C.L. Chou <cchou@zoom.com>
bcs-broker      1704/tcp    bcs-broker
bcs-broker      1704/udp    bcs-broker
#                           Andy Warner <andyw@knoware.nl>
slingshot       1705/tcp    slingshot
slingshot       1705/udp    slingshot
#                           Paul Groarke <paulg@quay.ie>
jetform         1706/tcp    jetform
jetform         1706/udp    jetform
#                           gdeinsta <gdeinsta@jetform.com>
vdmplay         1707/tcp    vdmplay
vdmplay         1707/udp    vdmplay
#                           Vadim Lebedev <vadim@magic.fr>
gat-lmd         1708/tcp    gat-lmd
gat-lmd         1708/udp    gat-lmd
#                           Igor Zaoutine <igor@global-tech.com>
centra          1709/tcp    centra
centra          1709/udp    centra
#                           Drew Wolff <dwolff@centra.net>
impera          1710/tcp    impera
impera          1710/udp    impera
#                           Stepehen Campbell <campbell@uniprise.com>
pptconference   1711/tcp    pptconference
pptconference   1711/udp    pptconference
#                           John Tafoya <johnt@microsoft.com>
registrar       1712/tcp    resource monitoring service
registrar       1712/udp    resource monitoring service
#                           Ron Lawson <ronaldl@hpindacx.cup.hp.com>
conferencetalk  1713/tcp    ConferenceTalk
conferencetalk  1713/udp    ConferenceTalk
#                           George Kajos <gkajos@mail1.videoserver.com>
sesi-lm         1714/tcp    sesi-lm
sesi-lm         1714/udp    sesi-lm
houdini-lm      1715/tcp    houdini-lm
houdini-lm      1715/udp    houdini-lm
#                           Paul Breslin <phb@SIDEFX.COM>
xmsg            1716/tcp    xmsg
xmsg            1716/udp    xmsg
#                           Mark E. Fogle <mefogle@xantel.com>
fj-hdnet        1717/tcp    fj-hdnet
fj-hdnet        1717/udp    fj-hdnet
#                           Manabu Makino <m-makino@ael.fujitsu.co.jp>
h323gatedisc    1718/tcp    h323gatedisc
h323gatedisc    1718/udp    h323gatedisc
h323gatestat    1719/tcp    h323gatestat 
h323gatestat    1719/udp    h323gatestat 
h323hostcall    1720/tcp    h323hostcall
h323hostcall    1720/udp    h323hostcall
#                           Jim Toga <jtoga@ibeam.jf.intel.com>
caicci          1721/tcp    caicci
caicci          1721/udp    caicci
#                           Sylvia Scheuren <schsy02@cai.com>
hks-lm          1722/tcp    HKS License Manager
hks-lm          1722/udp    HKS License Manager
#                           Michael Wood <wood@althea.hks.com>
pptp            1723/tcp    pptp
pptp            1723/udp    pptp
#                           Ken Crocker <kcrocker@microsoft.com>
csbphonemaster  1724/tcp    csbphonemaster
csbphonemaster  1724/udp    csbphonemaster
#                           Mark Kellerhuis <Mark_Kellerhuis@msn.com>
iden-ralp       1725/tcp    iden-ralp
iden-ralp       1725/udp    iden-ralp
#                           Chris Stanaway <stanaway@comm.mot.com>
iberiagames     1726/tcp    IBERIAGAMES
iberiagames     1726/tcp    IBERIAGAMES
#                           Jose Luis <73374.313@compuserve.com>
winddx          1727/tcp    winddx
winddx          1727/udp    winddx
#                           Bill Andrews <billa@vnd.tek.com>
telindus        1728/tcp    TELINDUS
telindus        1728/udp    TELINDUS
#                           Paul Pyck <papy@telindus.be
citynl          1729/tcp    CityNL License Management
citynl          1729/udp    CityNL License Management
#                           CityDisc <citydisc@euronet.nl>
roketz          1730/tcp    roketz
roketz          1730/udp    roketz
#                           Ahti Heinla <ahti@ahti.bluemoon.ee>
msiccp          1731/tcp    MSICCP
msiccp          1731/udp    MSICCP
#                           Max Morris <maxm@MICROSOFT.com>
proxim          1732/tcp    proxim
proxim          1732/udp    proxim
#                           Srinivas N. Mogalapalli <srinivas@proxim.com>
siipat          1733/tcp    SIMS - SIIPAT Protocol for Alarm Transmission
siipat          1733/udp    SIMS - SIIPAT Protocol for Alarm Transmission
#                           Steve Ryckman <sryckman@simsware.com>
cambertx-lm     1734/tcp    Camber Corporation License Management
cambertx-lm     1734/udp    Camber Corporation License Management
#                           Jeannie Burleson <jeannie@cambertx.com>
privatechat     1735/tcp    PrivateChat
privatechat     1735/udp    PrivateChat
#                           Louis E. Simard <76400.3371@CompuServe.COM>
street-stream   1736/tcp    street-stream
street-stream   1736/udp    street-stream
#                           Glenn Levitt <streetd1@ix.netcom.com>
ultimad         1737/tcp    ultimad
ultimad         1737/udp    ultimad
#                           (Michael Lanzetta <hagbard@ultimatech.com>
gamegen1        1738/tcp    GameGen1
gamegen1        1738/udp    GameGen1
#                           Glen Pearson <GlenP@multigen.com>
webaccess       1739/tcp    webaccess
webaccess       1739/udp    webaccess
#                           Christian Saether <ChristianS@asymetrix.com>
encore          1740/tcp    encore
encore          1740/udp    encore
#                           Stuart Button <button@promis.com>
cisco-net-mgmt  1741/tcp    cisco-net-mgmt
cisco-net-mgmt  1741/udp    cisco-net-mgmt
#                           John McCormack <jmac@cisco.com>
3Com-nsd        1742/tcp    3Com-nsd
3Com-nsd        1742/udp    3Com-nsd
#                           Nitza Steinberg <nitza@isd.3com.com>
cinegrfx-lm     1743/tcp    Cinema Graphics License Manager
cinegrfx-lm     1743/udp    Cinema Graphics License Manager
#                           Rodney Iwashina <rodney@cyclone.rfx.com>
ncpm-ft         1744/tcp    ncpm-ft
ncpm-ft         1744/udp    ncpm-ft
#                           Ken Hearn <hearn@hpindacx.cup.hp.com>
remote-winsock  1745/tcp    remote-winsock
remote-winsock  1745/udp    remote-winsock
#                           Avi Nathan <avin@microsoft.com>
ftrapid-1       1746/tcp    ftrapid-1
ftrapid-1       1746/udp    ftrapid-1
ftrapid-2       1747/tcp    ftrapid-2
ftrapid-2       1747/udp    ftrapid-2
#                           Richard J. Williams <RJW1@trpo4.tr.unisys.com>
oracle-em1      1748/tcp    oracle-em1
oracle-em1      1748/udp    oracle-em1
#                           Bob Purvy <bpurvy@us.oracle.com>
aspen-services  1749/tcp    aspen-services
aspen-services  1749/udp    aspen-services
#                           Mark B. Hurst <mhurst@aspenres.com>
sslp            1750/tcp    Simple Socket Library's PortMaster
sslp            1750/udp    Simple Socket Library's PortMaster
#                           Dr. Charles E. Campbell Jr.
#                           <cec@gryphon.gsfc.nasa.gov> 
swiftnet        1751/tcp    SwiftNet
swiftnet        1751/udp    SwiftNet
#                           Terry Lim <tkl@pentek.com>
lofr-lm         1752/tcp    Leap of Faith Research License Manager 
lofr-lm         1752/udp    Leap of Faith Research License Manager 
#                           
translogic-lm   1753/tcp    Translogic License Manager
translogic-lm   1753/udp    Translogic License Manager
#                           Stan Dallas <stan@translogic.com>
oracle-em2      1754/tcp    oracle-em2
oracle-em2      1754/udp    oracle-em2
#                           Bob Purvy <bpurvy@us.oracle.com>
ms-streaming    1755/tcp    ms-streaming
ms-streaming    1755/udp    ms-streaming
#                           Bret O'Rourke
capfast-lmd     1756/tcp    capfast-lmd
capfast-lmd     1756/udp    capfast-lmd
#                           Chuck Neal <chuck@phase3.com>
cnhrp           1757/tcp    cnhrp
cnhrp           1757/udp    cnhrp
#                           William Stoye <wstoye@atml.co.uk>
tftp-mcast      1758/tcp    tftp-mcast
tftp-mcast      1758/udp    tftp-mcast
#                           Tom Emberson <tom@lanworks.com>
spss-lm         1759/tcp    SPSS License Manager
spss-lm         1759/udp    SPSS License Manager
#                           Tex Hull <tex@spss.com>
www-ldap-gw     1760/tcp    www-ldap-gw
www-ldap-gw     1760/udp    www-ldap-gw
#                           Nick Emery <Nick.Emery@altavista.digital.com>
cft-0           1761/tcp    cft-0
cft-0           1761/udp    cft-0
cft-1           1762/tcp    cft-1
cft-1           1762/udp    cft-1
cft-2           1763/tcp    cft-2
cft-2           1763/udp    cft-2
cft-3           1764/tcp    cft-3
cft-3           1764/udp    cft-3
cft-4           1765/tcp    cft-4
cft-4           1765/udp    cft-4
cft-5           1766/tcp    cft-5
cft-5           1766/udp    cft-5
cft-6           1767/tcp    cft-6
cft-6           1767/udp    cft-6
cft-7           1768/tcp    cft-7
cft-7           1768/udp    cft-7
#                           Martine Marchand 16 1 46 59 24 84
bmc-net-adm     1769/tcp    bmc-net-adm
bmc-net-adm     1769/udp    bmc-net-adm
#                           Cameron Haight <cameron_haight@bmc.com>
bmc-net-svc     1770/tcp    bmc-net-svc
bmc-net-svc     1770/udp    bmc-net-svc
#                           Cameron Haight <cameron_haight@bmc.com>bmc-net-svc
vaultbase       1771/tcp    vaultbase
vaultbase       1771/udp    vaultbase
#                           Jose A. Sesin <sesin@vaultbase.com>
essweb-gw       1772/tcp    EssWeb Gateway
essweb-gw       1772/udp    EssWeb Gateway
#                           Bob Nattenberg <bnattenberg@arborsoft.com>
kmscontrol      1773/tcp    KMSControl
kmscontrol      1773/udp    KMSControl
#                           Roy Chastain <roy@kmsys.com>
global-dtserv   1774/tcp    global-dtserv
global-dtserv   1774/udp    global-dtserv
#                           Nicholas Davies <N.Davies@globalcomm.co.uk>
#               1775/tcp
199z
femis           1776/tcp    Federal Emergency Management Information System
femis           1776/udp    Federal Emergency Management Information System
#                           Larry Gerhardstein <lh_gerhardstein@pnl.gov>
powerguardian   1777/tcp    powerguardian
powerguardian   1777/udp    powerguardian
#                           Charles Bennett <chuck@benatong.com>
prodigy-internet1778/tcp    prodigy-internet
prodigy-internet1778/udp    prodigy-internet
#                           Bob Dedrick <bob@staff.prodigy.com>
pharmasoft      1779/tcp    pharmasoft
pharmasoft      1779/udp    pharmasoft
#                           Ola Strandberg <Ola.Strandberg@pharmasoft.se>
dpkeyserv       1780/tcp    dpkeyserv
dpkeyserv       1780/udp    dpkeyserv
#                           Yasunari Gon Yamasita <yamasita@omronsoft.co.jp>
answersoft-lm   1781/tcp    answersoft-lm
answersoft-lm   1781/udp    answersoft-lm 
#                           James A. Brewster <jimbrew@answersoft.com>
hp-hcip         1782/tcp    hp-hcip
hp-hcip         1782/udp    hp-hcip
#                           Allen Baker <abaker@boi.hp.com>
fjris           1783/tcp    Fujitsu Remote Install Service
fjris           1783/udp    Fujitsu Remote Install Service
#                           Naohito Nakamura
#                           <naonao@kikaku.mmp.fujitsu.co.jp> 
finle-lm        1784/tcp    Finle License Manager
finle-lm        1784/udp    Finle License Manager
#                           Dongling Wang <dongling@finle.com>
windlm          1785/tcp    Wind River Systems License Manager
windlm          1785/udp    Wind River Systems License Manager
#                           Will Dere <will@wrs.com>
funk-logger     1786/tcp    funk-logger
funk-logger     1786/udp    funk-logger
funk-license    1787/tcp    funk-license
funk-license    1787/udp    funk-license
#                           Cimarron Boozer <cboozer@funk.com>
#                           Eric Wilde <eric@funk.com>
psmond          1788/tcp    psmond
psmond          1788/udp    psmond
#                           Will Golson <golson@fc.hp.com>
hello           1789/tcp    hello
hello           1789/udp    hello
#                           D. J. Bernstein <djb@koobera.math.uic.edu>       
nmsp            1790/tcp    Narrative Media Streaming Protocol
nmsp            1790/udp    Narrative Media Streaming Protocol
#                           Paul Santinelli, Jr. <psantinelli@narrative.com>
ea1             1791/tcp    EA1
ea1             1791/udp    EA1
#                           Kirk MacLean <kmaclean@ea.com>
ibm-dt-2        1792/tcp    ibm-dt-2
ibm-dt-2        1792/udp    ibm-dt-2
#                           Sam Borman <sam_borman@uk.ibm.com>
rsc-robot       1793/tcp    rsc-robot
rsc-robot       1793/udp    rsc-robot
#                           Andrew Jay Schneider <ajs@relsoft.com>
cera-bcm        1794/tcp    cera-bcm
cera-bcm        1794/udp    cera-bcm
#                           Leo Moesgaard <leo_moesgaard@dk.ibm.com>
dpi-proxy       1795/tcp    dpi-proxy
dpi-proxy       1795/udp    dpi-proxy
#                           Charles Gordon <cgordon@digprod.com>
vocaltec-admin  1796/tcp    Vocaltec Server Administration
vocaltec-admin  1796/udp    Vocaltec Server Administration
#                           Scott Petrack <Scott_Petrack@vocaltec.com>
uma             1797/tcp    UMA 
uma             1797/udp    UMA
#                           Martin Kirk <m.kirk@opengroup.org>
etp             1798/tcp    Event Transfer Protocol
etp             1798/udp    Event Transfer Protocol
#                           Mike Wray <mjw@hplb.hpl.hp.com>
netrisk		1799/tcp    NETRISK
netrisk		1799/udp    NETRISK
#			    Kevin Green <Kevin_Green@tds.com>
ansys-lm	1800/tcp    ANSYS-License manager
ansys-lm	1800/udp    ANSYS-License manager
#			    Suzanne Lorrin <sml@ansyspo.ansys.com>
msmq		1801/tcp    Microsoft Message Que
msmq		1801/udp    Microsoft Message Que
#			    Amnon Horowitz <amnonh@MICROSOFT.com>
concomp1	1802/tcp    ConComp1
concomp1	1802/udp    ConComp1
#			    Ed Vincent <@edv@concomp.com>
hp-hcip-gwy	1803/tcp    HP-HCIP-GWY
hp-hcip-gwy	1803/udp    HP-HCIP-GWY
#			    Allen Baker <abaker@boi.hp.com>
enl		1804/tcp    ENL
enl		1804/udp    ENL
#			    Brian Olson <Olson@smg.seagatesoftware.com>
enl-name	1805/tcp    ENL-Name
enl-name	1805/udp    ENL-Name
#			    Brain Olson <Olson@smg.seagatesoftware.com>
musiconline	1806/tcp    Musiconline
musiconline	1806/udp    Musiconline
#			    Craig Weeks <cweeks@syspace.co.uk>
fhsp		1807/tcp    Fujitsu Hot Standby Protocol
fhsp		1807/udp    Fujitsu Hot Standby Protocol
#			    Eiki Iwata (eiki@nd.net.fujitsu.co.jp>
oracle-vp2	1808/tcp    Oracle-VP2
oracle-vp2	1808/udp    Oracle-VP2
#                           Craig Fowler <cfowler@us.oracle.com>
oracle-vp1      1809/tcp    Oracle-VP1
oracle-vp1	1809/udp    Oracle-VP1
#                           Craig Fowler <cfowler@us.oracle.com>
jerand-lm       1810/tcp    Jerand License Manager
jerand-lm	1810/udp    Jerand License Manager
#                           Robert Monat <jerand@jerand.com>
scientia-sdb    1811/tcp    Scientia-SDB
scientia-sdb	1811/udp    Scientia-SDB
#                           Ian Miller <Ian_Miller@scientia.com>
radius          1812/tcp    RADIUS
radius          1812/udp    RADIUS
#                           Carl Rigney <cdr@livingston.com>
radius-acct     1813/tcp    RADIUS Accounting
radius-acct     1813/udp    RADIUS Accounting
#                           Carl Rigney <cdr@livingston.com>
tdp-suite       1814/tcp    TDP Suite
tdp-suite       1814/udp    TDP Suite
#                           Rob Lockhart <rob.lockhart@mot.com>
mmpft		1815/tcp    MMPFT
mmpft		1815/udp    MMPFT
#			    Ralf Muckenhirn <FAX: 49-7622-398200>
#                           <Phone: 49-7622-3980>
harp		1816/tcp    HARP
harp		1816/udp    HARP
#			    Bjorn Chambless <bjorn@cs.pdx.edu>
#               1817        Unassigned
etftp           1818/tcp    Enhanced Trivial File Transfer Protocol
etftp           1818/udp    Enhanced Trivial File Transfer Protocol
#                           William Polites <wpolites@mitre.org>
plato-lm        1819/tcp    Plato License Manager
plato-lm        1819/udp    Plato License Manager
#                           Mark Morris <mim@ermuk.com>
mcagent         1820/tcp    mcagent
mcagent         1820/udp    mcagent
#                           Ryoichi Shinohara <shinohara@VNET.IBM.COM>
donnyworld      1821/tcp    donnyworld
donnyworld      1821/udp    donnyworld
#                           Don Oliver <don@donnyworld.com>
es-elmd         1822/tcp    es-elmd
es-elmd         1822/udp    es-elmd
#                           David Duncan <dduncan@es.com>
unisys-lm       1823/tcp    Unisys Natural Language License Manager
unisys-lm       1823/udp    Unisys Natural Language License Manager
#                           Raymond A. Diedrichs <rayd@slu.tr.unisys.com>
metrics-pas     1824/tcp    metrics-pas
metrics-pas     1824/udp    metrics-pas
#                           Tom Haapanen <tomh@metrics.com>
#               1825-1849   Unassigned
gsi		1850/tcp    GSI
gsi		1850/udp    GSI
#			    William Mullaney <mullanwi@usa.net>
#		1851-1859   Unassigned
sunscalar-svc	1860/tcp    SunSCALAR Services
sunscalar-svc	1860/udp    SunSCALAR Services
#			    Sanjay Radia <srradia@kasumbi.Eng.Sun.COM>
lecroy-vicp	1861/udp    LeCroy VICP
lecroy-vcip	1861/tcp    LeCroy VICP
#			    Anthony Cake <anthonyrc@lecroy.com>
techra-server	1862/tcp    techra-server
techra-server	1862/udp    techra-server
#			    Roy Lyseng <roy.lyseng@maxware.no>
msnp		1863/tcp    MSNP
msnp		1863/udp    MSNP
#			    William Lai <wlai@microsoft.com>
paradym-31port	1864/tcp    Paradym 31 Port
paradym-31port	1864/udp    Paradym 31 Port
#			    David Wooden <dwooden@wizdom.com>
entp		1865/tcp    ENTP
entp		1865/udp    ENTP
#			    Seiko Epson <Ishida.Hitoshi@exc.epson.co.jp>
#		1866-1869   Unassigned
sunscalar-dns   1870/tcp    SunSCALAR DNS Service
sunscalar-dns	1870/udp    SunSCALAR DNS Service
#                           Sanjay Radia <srradia@kasumbi.Eng.Sun.COM>
#		1871-1880   Unassigned
ibm-mqseries2	1881/tcp    IBM MQSeries
ibm-mqseries2	1881/udp    IBM MQSeries
#			    Steve Hall <steve_hall@uk.ibm.com>
#		1882-1900   Unassigned
fjicl-tep-a     1901/tcp    Fujitsu ICL Terminal Emulator Program A
fjicl-tep-a     1901/udp    Fujitsu ICL Terminal Emulator Program A
#                           Bob Lyon <bl@oasis.icl.co.uk>
fjicl-tep-b     1902/tcp    Fujitsu ICL Terminal Emulator Program B
fjicl-tep-b     1902/udp    Fujitsu ICL Terminal Emulator Program B
#                           Bob Lyon <bl@oasis.icl.co.uk>
linkname        1903/tcp    Local Link Name Resolution
linkname        1903/udp    Local Link Name Resolution
#                           Dan Harrington <dth@lucent.com>
fjicl-tep-c     1904/tcp    Fujitsu ICL Terminal Emulator Program C
fjicl-tep-c     1904/udp    Fujitsu ICL Terminal Emulator Program C
#                           Bob Lyon <bl@oasis.icl.co.uk>
sugp   		1905/tcp    Secure UP.Link Gateway Protocol
sugp            1905/udp    Secure UP.Link Gateway Protocol
#			    Peter King <king@uplanet.com>
tpmd		1906/tcp    TPortMapperReq
tpmd		1906/udp    TPortMapperReq
# 			    Sheila Devins <sheila_devins@VNET.IBM.COM>
intrastar	1907/tcp    IntraSTAR
intrastar	1907/udp    IntraSTAR
#			    Peter Schoenberger <ps@teles.de>
dawn		1908/tcp    Dawn
dawn		1908/udp    Dawn
#			    Michael Crawford <michaelc@travsoft.com>
global-wlink	1909/tcp    Global World Link
global-wlink	1909/udp    Global World Link
#			    Nicholas Davies <N.Davies@globalcomm.co.uk>
#               1908-1910   Unassigned
mtp             1911/tcp    Starlight Networks Multimedia Transport Protocol
mtp             1911/tcp    Starlight Networks Multimedia Transport Protocol
#                           Bruce Lieberman <brucel@iserver.starlight.com>
                1912        Unassigned
#                           Tom Lake <tlake@m-ware.com>
armadp          1913/tcp    armadp
armadp          1913/udp    armadp
#                           Kevin Welton <Kevin.Welton@armltd.co.uk>
elm-momentum    1914/tcp    Elm-Momentum
elm-momentum    1914/udp    Elm-Momentum
#                           Willie Wu <willie@mds.com>
facelink        1915/tcp    FACELINK
facelink        1915/udp    FACELINK
#                           J.H. Hermans <j.h.hermans@hiscom.nl>
persoft         1916/tcp    Persoft Persona
persoft         1916/udp    Persoft Persona
#                           Tom Spidell <spidell@persoft.com>
noagent		1917/tcp    nOAgent
noagent		1917/udp    nOAgent
#			    Martin Bestmann <martin@datawatch.de>
can-nds   	1918/tcp    Candle Directory Service - NDS    
can-nds		1918/udp    Candle Directory Service - NDS
can-dch		1919/tcp    Candle Directory Service - DCH
can-dch   	1919/udp    Candle Directory Service - DCH
can-ferret	1920/tcp    Candle Directory Service - FERRET
can-ferret	1920/udp    Candle Directory Service - FERRET
#			    Dannis Yang <Dannis_Yang@candle.com>
noadmin		1921/tcp    NoAdmin
noadmin		1921/udp    NoAdmin
#			    Martin Bestmann <martin@datawatch.de>
#               1922-1943  Unassigned
close-combat    1944/tcp   close-combat
close-combat    1944/udp   close-combat
#                          David Hua <dhua@microsoft.com>
dialogic-elmd   1945/tcp   dialogic-elmd
dialogic-elmd   1945/udp   dialogic-elmd
#                          Roger Kay <r.kay@nz.dialogic.com>
tekpls          1946/tcp   tekpls
tekpls          1946/udp   tekpls
#                          Brian Abramson <brianab@vnd.tek.com>
hlserver        1947/tcp   hlserver
hlserver        1947/udp   hlserver
#                          Michael Zzunke <mzunke@fast-ag.de>
eye2eye         1948/tcp   eye2eye
eye2eye         1948/udp   eye2eye
#                          Trevor Bell <Trevor@iguana.iosoftware.com>
ismaeasdaqlive  1949/tcp   ISMA Easdaq Live
ismaeasdaqlive  1949/udp   ISMA Easdaq Live
ismaeasdaqtest  1950/tcp   ISMA Easdaq Test
ismaeasdaqtest  1950/udp   ISMA Easdaq Test
#                          Stephen Dunne <sdun@isma.co.uk>
bcs-lmserver    1951/tcp   bcs-lmserver
bcs-lmserver    1951/udp   bcs-lmserver
#                          Andy Warner <andyw@knoware.nl>
#               1952-1972  Unassigned
dlsrap          1973/tcp   Data Link Switching Remote Access Protocol
dlsrap          1973/udp   Data Link Switching Remote Access Protocol
#                          Steve T. Chiang <schiang@cisco.com>
#               1974-1984  Unassigned               
##########Use the above block for Cisco?################
hsrp		1985/tcp   Hot Standby Router Protocol
hsrp		1985/udp   Hot Standby Router Protocol
#			   Phil Morton <pmorton@cisco.com>
licensedaemon   1986/tcp   cisco license management
licensedaemon   1986/udp   cisco license management
tr-rsrb-p1      1987/tcp   cisco RSRB Priority 1 port
tr-rsrb-p1      1987/udp   cisco RSRB Priority 1 port
tr-rsrb-p2      1988/tcp   cisco RSRB Priority 2 port
tr-rsrb-p2      1988/udp   cisco RSRB Priority 2 port
tr-rsrb-p3      1989/tcp   cisco RSRB Priority 3 port
tr-rsrb-p3      1989/udp   cisco RSRB Priority 3 port
# The following entry records an unassigned but widespread use
mshnet          1989/tcp   MHSnet system
mshnet          1989/udp   MHSnet system
#               Bob Kummerfeld <bob@sarad.cs.su.oz.au>
stun-p1         1990/tcp   cisco STUN Priority 1 port
stun-p1         1990/udp   cisco STUN Priority 1 port
stun-p2         1991/tcp   cisco STUN Priority 2 port
stun-p2         1991/udp   cisco STUN Priority 2 port
stun-p3         1992/tcp   cisco STUN Priority 3 port
stun-p3         1992/udp   cisco STUN Priority 3 port
# The following entry records an unassigned but widespread use
ipsendmsg       1992/tcp   IPsendmsg
ipsendmsg       1992/udp   IPsendmsg
#               Bob Kummerfeld <bob@sarad.cs.su.oz.au>
snmp-tcp-port   1993/tcp   cisco SNMP TCP port
snmp-tcp-port   1993/udp   cisco SNMP TCP port
stun-port       1994/tcp   cisco serial tunnel port
stun-port       1994/udp   cisco serial tunnel port
perf-port       1995/tcp   cisco perf port
perf-port       1995/udp   cisco perf port
tr-rsrb-port    1996/tcp   cisco Remote SRB port
tr-rsrb-port    1996/udp   cisco Remote SRB port
gdp-port        1997/tcp   cisco Gateway Discovery Protocol
gdp-port        1997/udp   cisco Gateway Discovery Protocol
x25-svc-port    1998/tcp   cisco X.25 service (XOT)
x25-svc-port    1998/udp   cisco X.25 service (XOT)
tcp-id-port     1999/tcp   cisco identification port
tcp-id-port     1999/udp   cisco identification port
callbook        2000/tcp
callbook        2000/udp
dc		2001/tcp
wizard		2001/udp    curry
globe		2002/tcp
globe		2002/udp
mailbox		2004/tcp
emce            2004/udp    CCWS mm conf
berknet		2005/tcp
oracle		2005/udp
invokator	2006/tcp
raid-cc		2006/udp    raid
dectalk		2007/tcp
raid-am		2007/udp
conf		2008/tcp
terminaldb	2008/udp
news		2009n/tcp
whosockami	2009/udp
search		2010/tcp
pipe_server	2010/udp
raid-cc		2011/tcp    raid
servserv	2011/udp
ttyinfo		2012/tcp
raid-ac		2012/udp
raid-am		2013/tcp
raid-cd		2013/udp
troff		2014/tcp
raid-sf		2014/udp
cypress		2015/tcp
raid-cs		2015/udp
bootserver	2016/tcp
bootserver	2016/udp
cypress-stat	2017/tcp
bootclient	2017/udp
terminaldb	2018/tcp
rellpack	2018/udp
whosockami	2019/tcp
about		2019/udp
xinupageserver	2020/tcp
xinupageserver	2020/udp
servexec	2021/tcp
xinuexpansion1	2021/udp
down		2022/tcp
xinuexpansion2	2022/udp
xinuexpansion3	2023/tcp
xinuexpansion3	2023/udp
xinuexpansion4	2024/tcp
xinuexpansion4	2024/udp
ellpack		2025/tcp
xribs		2025/udp
scrabble	2026/tcp
scrabble	2026/udp
shadowserver	2027/tcp
shadowserver	2027/udp
submitserver	2028/tcp
submitserver	2028/udp
device2		2030/tcp
device2		2030/udp
blackboard      2032/tcp
blackboard      2032/udp
glogger		2033/tcp
glogger		2033/udp
scoremgr	2034/tcp
scoremgr	2034/udp
imsldoc		2035/tcp
imsldoc		2035/udp
objectmanager	2038/tcp
objectmanager	2038/udp
lam		2040/tcp
lam		2040/udp
interbase	2041/tcp
interbase	2041/udp
isis		2042/tcp   isis
isis		2042/udp   isis
isis-bcast	2043/tcp   isis-bcast
isis-bcast	2043/udp   isis-bcast
#                          Ken Chapman <kchapman@isis.com
rimsl		2044/tcp
rimsl		2044/udp
cdfunc		2045/tcp
cdfunc		2045/udp
sdfunc		2046/tcp
sdfunc		2046/udp
dls		2047/tcp
dls		2047/udp
dls-monitor	2048/tcp
dls-monitor	2048/udp
#                         <== NOTE Conflict on 2049 !
shilp		2049/tcp
shilp		2049/udp
nfs             2049/tcp Network File System - Sun Microsystems
nfs             2049/udp Network File System - Sun Microsystems
#                        Brent Callaghan <brent@terra.eng.sun.com>
dlsrpn          2065/tcp   Data Link Switch Read Port Number
dlsrpn          2065/udp   Data Link Switch Read Port Number
dlswpn          2067/tcp   Data Link Switch Write Port Number
dlswpn          2067/udp   Data Link Switch Write Port Number
lrp		2090/tcp   Load Report Protocol
lrp		2090/udp   Load Report Protocol
#			   Amir Peless <amirp@radware.co.il>
#		2091-2101  Unassigned
zephyr-srv      2102/tcp   Zephyr server
zephyr-srv      2102/udp   Zephyr server
zephyr-clt      2103/tcp   Zephyr serv-hm connection
zephyr-clt      2103/udp   Zephyr serv-hm connection
zephyr-hm       2104/tcp   Zephyr hostmanager
zephyr-hm       2104/udp   Zephyr hostmanager
#                          Greg Hudson <zephyr-bugs@mit.edu>
minipay		2105/tcp   MiniPay
minipay		2105/udp   MiniPay
#			   Amir Herzberg <amirh@vnet.ibm.com>
#		2106-2179  Unassigned
mc-gt-srv	2180/tcp   Millicent Vendor Gateway Server
mc-gt-srv	2180/udp   Millicent Vendor Gateway Server
#			   Steve Glassman <steveg@pa.dec.com>
ats             2201/tcp   Advanced Training System Program
ats             2201/udp   Advanced Training System Program
#
imtc-map	2202/tcp   Int. Multimedia Teleconferencing Cosortium
imtc-map	2202/udp   Int. Multimedia Teleconferencing Cosortium
#			   Pat Galvin <pgalvin@databeam.com>
kali            2213/tcp   Kali
kali            2213/udp   Kali
#                          Jay Cotton <JAY@calc.vet.uga.edu>
ganymede	2220/tcp   Ganymede
ganymede	2220/udp   Ganymede
#			   David Quan <davidq@ganymedesoftware.com>
unreg-ab1	2221/tcp   Allen-Bradley unregistered port
unreg-ab1	2221/udp   Allen-Bradley unregistered port
unreg-ab2       2222/tcp   Allen-Bradley unregistered port
unreg-ab2       2222/udp   Allen-Bradley unregistered port
inreg-ab3	2223/tcp   Allen-Bradley unregistered port
inreg-ab3	2223/udp   Allen-Bradley unregistered port
#
ivs-video       2232/tcp   IVS Video default
ivs-video       2232/udp   IVS Video default
#                  Thierry Turletti <Thierry.Turletti@sophia.inria.fr>
infocrypt	2233/tcp   INFOCRYPT
infocrypt	2233/udp   INFOCRYPT
#			   Erica Liu <liue@isolation.com>
directplay      2234/tcp   DirectPlay
directplay      2234/udp   DirectPlay
#                          Ajay Jindal <ajayj@microsoft.com>
sercomm-wlink	2235/tcp   Sercomm-WLink
sercomm-wlink   2235/udp   Sercomm-WLink
#			   Melinda Tsao <melinda@tpe1.sercomm.com.tw>
nani		2236/tcp   Nani
nani		2236/udp   Nani
#			   Steve Benoit <sbenoi01@eng.eds.com>
optech-port1-lm 2237/tcp   Optech Port1 License Manager
optech-port1-lm 2237/udp   Optech Port1 License Manager
#		 	   Gerard Cannie <jcannie@opticaltech.com>
aviva-sna	2238/tcp   AVIVA SNA SERVER
aviva-sna	2238/udp   AVIVA SNA SERVER
#			   Vick Keshishian <vickenK@192.219.82.71>
imagequery	2239/tcp   Image Query	
imagequery      2239/udp   Image Query
#			   Charles Jacobs <cjacobs@numinous.com>
recipe		2240/tcp   RECIPe
recipe		2240/udp   RECIPe
#			   Jerry Freedman <Jerome.Freedman@gsc.gte.com>
ivsd            2241/tcp   IVS Daemon
ivsd            2241/udp   IVS Daemon
#       Thierry Turletti <Thierry.Turletti@sophia.inria.fr>
foliocorp       2242/tcp   Folio Remote Server
foliocorp       2242/udp   Folio Remote Server
#                          Pat Mcgowan <pmcgowan@folio.com>
#               2243-2278  Unassigned
xmquery         2279/tcp   xmquery
xmquery         2279/udp   xmquery
#                          Niels Christiansen <nchris@austin.ibm.com>
lnvpoller       2280/tcp   LNVPOLLER
lnvpoller       2280/udp   LNVPOLLER
lnvconsole      2281/tcp   LNVCONSOLE
lnvconsole      2281/udp   LNVCONSOLE
lnvalarm        2282/tcp   LNVALARM
lnvalarm        2282/udp   LNVALARM
lnvstatus       2283/tcp   LNVSTATUS
lnvstatus       2283/udp   LNVSTATUS
lnvmaps         2284/tcp   LNVMAPS
lnvmaps         2284/udp   LNVMAPS
lnvmailmon      2285/tcp   LNVMAILMON
lnvmailmon      2285/udp   LNVMAILMON
#                          Andrew MacKeith <mackeith@crd.lotus.com>
nas-metering    2286/tcp   NAS-Metering
nas-metering    2286/udp   NAS-Metering
#                          Steven Sawkins <ssawkins@symantec.com>    
dna		2287/tcp   DNA
dna		2287/udp   DNA
#			   Tung Nguyen <dash@ricochet.net>
netml		2288/tcp   NETML
netml		2288/udp   NETML
#			   Jochen Hansmeyer <cjh@krypton.de>
#               2289-2294  Unassigned
advant-lm	2295/tcp   Advant License Manager
advant-lm	2295/udp   Advant License Manager
#			   Lars-Goran Magnusson 
#                          <lars-goran.magnusson@seisy.mail.abb.com>
theta-lm	2296/tcp   Theta License Manager (Rainbow)
theta-lm	2296/udp   Theta License Manager (Rainbow)
#		   	   David Thompson <theta@theta-ent.com>
d2k-datamover1	2297/tcp   D2K DataMover 1
d2k-datamover1	2297/udp   D2K DataMover 1
d2k-datamover2  2298/tcp   D2K DataMover 2
d2k-datamover2	2298/udp   D2K DataMover 2
#			   Eric Lan <elan@d2k.com>
pc-telecommute	2299/tcp   PC Telecommute
pc-telecommute	2299/udp   PC Telecommute
#			   John Daniel Bonamico <jbonamico@symantec.com>
cvmmon		2300/tcp   CVMMON
cvmmon		2300/udp   CVMMON
#			   Roger Kumpf <kumpf@cup.hp.com>
cpq-wbem	2301/tcp   Compaq HTTP
cpq-wbem	2301/udp   Compaq HTTP
#			   Scott Shaffer <scott.shaffer@compaq.com>
binderysupport	2302/tcp   Bindery Support
binderysupport	2302/udp   Bindery Support
#			   Narasimha Rao N. <nnarasimharao@novell.com>
proxy-gateway	2303/tcp   Proxy Gateway
proxy-gateway	2303/udp   Proxy Gateway
#			   Paul Funk <paul@funk.com>
attachmate-uts	2304/tcp   Attachmate UTS
attachmate-uts	2304/udp   Attachmate UTS
#			   George Gianelos <Georgegi@Attachmate.com>
#		2305-2306  Unassigned
pehelp          2307/tcp   pehelp
pehelp          2307/udp   pehelp
#                          Jens Kilian <jensk@hpbeo82.bbn.hp.com>
sdhelp		2308/tcp   sdhelp
sdhelp		2308/udp   sdhelp
#			   Annette Klecha <annette_klecha@bbn.hp.com>
sdserver	2309/tcp   SD Server
sdserver	2309/udp   SD Server
sdclient	2310/tcp   SD Client
sdclient	2310/udp   SD Client
#			   Jeurgen Broesamle <juergb@bbn.hp.com>
messageservice	2311/tcp   Message Service
messageservice	2311/udp   Message Service
#		2312	   Unassigned
#			   Ken Madsen <kenhvm@forum.dk>
iapp		2313/tcp   IAPP (Inter Access Point Protocol)
iapp		2313/udp   IAPP (Inter Access Point Protocol)
#			   Henri Moelard <moelard@lucent.com>
cr-websystems	2314/tcp   CR WebSystems
cr-websystems	2314/udp   CR WebSystems
#			   Robin Giese <rgiese@peddie.org>
precise-sft	2315/tcp   Precise Sft.
precise-sft	2315/udp   Precise Sft.
#			   Michael Landwehr <mikel@precisesoft.co.il>
sent-lm		2316/tcp   SENT License Manager
sent-lm		2316/udp   SENT License Manager
#			   Pisharath Krishnan <krishnan@axis-inc.com>
attachmate-g32	2317/tcp   Attachmate G32
attachmate-g32	2317/udp   Attachmate G32
#			   Bryce Bhatnagar <BRYCEBH@Attachmate.com>
cadencecontrol	2318/tcp   Cadence Control
cadencecontrol	2318/udp   Cadence Control
#			   Buck Caldwell <buck_c@polygon.com>
infolibria	2319/tcp   InfoLibria
infolibria	2319/udp   InfoLibria
#			   Chris Chiotasso <cchiotasso@infolibria.com>
#		2320-2392  Unassigned
ms-olap1	2393/tcp   MS OLAP 1
ms-olap1	2393/udp   MS OLAP 1
ms-olap2	2394/tcp   MS OLAP 2
ms-olap2	2394/udp   MA OLAP 2
#			   Mosha Pasumansky <moshap@microsoft.com>
#		2395-2399  Unassigned
opequus-server	2400/tcp   OpEquus Server
opequus-server	2400/udp   OpEquus Server
#			   Gavin Hutchinson <gavinh@tesl.com>
cvspserver      2401/tcp   cvspserver
cvspserver      2401/udp   cvspserver
#                          Jim Kingdon <kingdon@harvey.cyclic.com>
rtsserv         2500/tcp   Resource Tracking system server
rtsserv         2500/udp   Resource Tracking system server
rtsclient       2501/tcp   Resource Tracking system client
rtsclient       2501/udp   Resource Tracking system client
#                          Aubrey Turner
#               <S95525ta%etsuacad.bitnet@ETSUADMN.ETSU.EDU>
#		2502-2526  Unassigned
iqserver	2527/tcp   IQ Server
iqserver	2527/udp   IQ Server
#			   Nick Straguzzi <Nick_Straguzzi@akbs.com>
ncr_ccl		2528/tcp   NCR CCL
ncr_ccl		2528/udp   NCR CCL
#			   Amitava Dutta <Amitava.Dutta@WoodbridgeNJ.ncr.com>
utsftp		2529/tcp   UTS FTP
utsftp		2529/udp   UTS FTP
#			   David Moore <dmoore@uttc-uts.com>
vrcommerce	2530/tcp   VR Commerce
vrcommerce	2530/udp   VR Commerce
#			   Yosi Mass <yosimass@haifa.vnet.ibm.com>
ito-e-gui	2531/tcp   ITO-E GUI
ito-e-gui	2531/udp   ITO-E GUI
#			   Michael Haeuptle <Michael_Haeuptle@hp.com>
ovtopmd		2532/tcp   OVTOPMD
ovtopmd		2532/udp   OVTOPMD
#			   Eric Pulsipher <eric_pulsipher@hp.com>
#		2533	   Unassigned
combox-web-acc	2534/tcp   Combox Web Access
combox-web-acc	2534/udp   Combox Web Access
#		   	   Yochai Cohen <yochai@combox.co.il>
#		2535-2563  Unassigned
hp-3000-telnet  2564/tcp   HP 3000 NS/VT block mode telnet
#		2565-2591  Unassigned
netrek          2592/tcp   netrek
netrek          2592/udp   netrek
#                          Al Guetzlaff <aeg@teamquest.com>
mns-mail	2593/tcp   MNS Mail Notice Service
mns-mail	2593/udp   MNS Mail Notice Service
#			   Rumiko Kikuta <kiku@nd.net.fujitsu.co.jp>
#		2594-2627  Unassigned
dict		2628/tcp   DICT
dict		2628/udp   DICT
#			   Rik Faith <faith@cs.unc.edu>
sitaraserver	2629/tcp   Sitara Server
sitaraserver	2629/udp   Sitara Server
sitaramgmt	2630/tcp   Sitara Management
sitaramgmt	2630/udp   Sitara Management
sitaradir	2631/tcp   Sitara Dir
sitaradir	2631/udp   Sitara Dir
#		  	   Manickam R.Sridhar <msridhar@sitaranetworks.com>
irdg-post	2632/tcp   IRdg Post
irdg-post	2632/udp   IRdg Post
#			   IRdg, Inc. <jtaylor@irdg.com>
interintelli	2633/tcp   InterIntelli
interintelli	2633/udp   InterIntelli
#			   Mike Gagle <MikeG@inter-intelli.com>
pk-electronics  2634/tcp   PK Electronics
pk-electronics  2634/udp   PK Electronics
#			   Seb Ibis <seb_ibis@pkworld.com>
backburner	2635/tcp   Back Burner
backburner	2635/udp   Back Burner
#			   Kevin Teiskoetter <kevint@metacreations.com>
solve		2636/tcp   Solve
solve		2636/udp   Solve
#			   Peter Morrison <peter_morrison@sydney.sterling.com>
imdocsvc	2637/tcp   Import Document Service
imdocsvc	2637/udp   Import Document Service
#			   Zia Bhatti <zia@netright.com>
sybaseanywhere  2638/tcp   Sybase Anywhere
sybaseanywhere	2638/udp   Sybase Anywhere
#			   Verna Friesen <friesen@sybase.com>
aminet		2639/tcp   AMInet
aminet		2639/udp   AMInet
#			   Alcorn McBride Inc. <jeff@alcorn.com>
sai_sentlm	2640/tcp   Sabbagh Associates Licence Manager
sai_sentlm	2640/udp   Sabbagh Associates Licence Manager
#			   Elias Sabbagh <ehs@sabbagh.com>
hdl-srv		2641/tcp   HDL Server
hdl-srv		2641/udp   HDL Server
#			   David Ely <dely@cnri.reston.va.us>
tragic		2642/tcp   Tragic
tragic		2642/udp   Tragic
#			   Stu Mark <fordii@j51.com>
gte-samp	2643/tcp   GTE-SAMP
gte-samp	2643/udp   GTE-SAMP
#			   Asher Altman <Asher.Altman@GSC.GTE.Com>
travsoft-ipx-t	2644/tcp   Travsoft IPX Tunnel
travsoft-ipx-t	2644/udp   Travsoft IPX Tunnel
#			   Jack Wilson <JackW@travsoft.com>
novell-ipx-cmd	2645/tcp   Novell IPX CMD
novell-ipx-cmd	2645/udp   Novell IPX CMD
#			   Juan Carlos Luciani <jluciani@novell.com>
#		2646-2699  Unassigned
tqdata          2700/tcp   tqdata
tqdata          2700/udp   tqdata
#                          Al Guetzlaff <aeg@teamquest.com>
#               2701-2783  Unassigned
www-dev         2784/tcp   world wide web - development
www-dev         2784/udp   world wide web - development
aic-np          2785/tcp   aic-np
aic-np          2785/udp   aic-np
#                          Brad Parker <brad@american.com>
aic-oncrpc      2786/tcp   aic-oncrpc - Destiny MCD database
aic-oncrpc      2786/udp   aic-oncrpc - Destiny MCD database
#                          Brad Parker  <brad@american.com>
piccolo         2787/tcp   piccolo - Cornerstone Software
piccolo         2787/udp   piccolo - Cornerstone Software
#                          Dave Bellivea <DaveBelliveau@corsof.com>
fryeserv        2788/tcp   NetWare Loadable Module - Seagate Software
fryeserv        2788/udp   NetWare Loadable Module - Seagate Software
#               Joseph LoPilato <Joseph_M_LoPilato@notes.seagate.com>
media-agent     2789/tcp   Media Agent
media-agent     2789/udp   Media Agent
#			   Nitzan Daube <nitzan@brm.com>
#               2789-2907  Unassigned
mao             2908/tcp   mao
mao             2908/udp   mao
#                          Marc Baudoin <babafou@agm-ita.ensta.fr>
funk-dialout 	2909/tcp   Funk Dialout
funk-dialout	2909/udp   Funk Dialout
#			   Cimarron Boozer <cboozer@funk.com>
tdaccess	2910/tcp   TDAccess
tdaccess	2910/udp   TDAccess
#			   Tom Haapanen <tomh@metrics.com>
blockade	2911/tcp   Blockade
blockade	2911/udp   Blockade
#			   Konstantin Iavid <kj@interlog.com>
epicon		2912/tcp   Epicon
epicon		2912/udp   Epicon
#			   Michael Khalandovsky <mlk@epicon.com>
boosterware	2913/tcp   Booster Ware
boosterware	2913/udp   Booster Ware
#		 	   Ido Ben-David <dgntcom@netvision.net.il>
gamelobby	2914/tcp   Game Lobby
gamelobby	2914/udp   Game Lobby
#			   Paul Ford-Hutchinson <pfh@dial.pipex.com>
tksocket	2915/tcp   TK Socket
tksocket	2915/udp   TK Socket
#			   Alan Fahrner <alan@protix.com>
elvin_server	2916/tcp   Elvin Server
elvin_server	2916/ucp   Elvin Server
elvin_client	2917/tcp   Elvin Client
elvin_client	2917/udp   Elvin Client
#			   David Arnold <davida@pobox.com>
kastenchasepad	2918/tcp   Kasten Chase Pad
kastenchasepad	2918/udp   Kasten Chase Pad
#			   Marc Gauthier <mgau@kastenchase.com>
#               2918-2970  Unassigned
netclip		2971/tcp   Net Clip
netclip		2971/udp   Net Clip
#			   Rudi Chiarito <chiarito@cli.di.unipi.it>
pmsm-webrctl	2972/tcp   PMSM Webrctl
pmsm-webrctl	2972/udp   PMSM Webrctl
#			   Markus Michels <mmi@pmsmicado.com>
svnetworks	2973/tcp   SV Networks
svnetworks	2973/udp   SV Networks
#			   Sylvia Siu <ssiu@svnetworks.com>
signal		2974/tcp   Signal
signal		2974/udp   Signal
#			   Wyatt Williams <wyattw@icall.com>
fjmpcm		2975/tcp   Fujitsu Configuration Management Service
fjmpcm		2975/udp   Fujitsu Configuration Management Service
#			   Hiroki Kawano <kawano@saint.nm.fujitsu.co.jp>
#		2976-2997  Unassigned
realsecure	2998/tcp   Real Secure
realsecure	2998/udp   Real Secure
#			   Tim Farley <TFarley@iss.net>
remoteware-un	2999/tcp   RemoteWare Unassigned
remoteware-un	2999/udp   RemoteWare Unassigned
#			   Tim Farley <Tim.Farley@xcellenet.com>
hbci            3000/tcp   HBCI
hbci            3000/udp   HBCI
#                          Kurt Haubner <haubner@ibm.net>
# The following entry records an unassigned but widespread use
remoteware-cl	3000/tcp   RemoteWare Client
remoteware-cl	3000/udp   RemoteWare Client
#			   Tim Farley <Tim.Farley@xcellenet.com>
redwood-broker  3001/tcp   Redwood Broker
redwood-broker  3001/udp   Redwood Broker
#			   Joseph Morrison <joe@powerframe.com>
exlm-agent	3002/tcp   EXLM Agent
exlm-agent	3002/udp   EXLM Agent
#			   Randy Martin <exlmoc@clemson.edu>
# The following entry records an unassigned but widespread use
remoteware-srv	3002/tcp   RemoteWare Server
remoteware-srv	3002/udp   RemoteWare Server
#			   Tim Farley <Tim.Farley@xcellenet.com>
cgms		3003/tcp   CGMS
cgms		3003/udp   CGMS
#			   Jim Mazzonna <jmazzonna@tiscom.uscg.mil>
csoftragent	3004/tcp   Csoft Agent
csoftragent	3004/udp   Csoft Agent
#			   Nedelcho Stanev <decho@csoft.bg>
geniuslm	3005/tcp   Genius License Manager
geniuslm	3005/udp   Genius License Manager
#			   Jakob Spies <Jakob.Spies@genius.de>
ii-admin	3006/tcp   Instant Internet Admin
ii-admin	3006/udp   Instant Internet Admin
#			   Lewis Donzis <Lewis_Donzis@baynetworks.com>
lotusmtap	3007/tcp   Lotus Mail Tracking Agent Protocol
lotusmtap	3007/udp   Lotus Mail Tracking Agent Protocol
#			   Ken Lin <ken_lin@lotus.com>
midnight-tech	3008/tcp   Midnight Technologies
midnight-tech	3008/udp   Midnight Technologies
#			   Kyle Unice <kyle@midnighttech.com>
pxc-ntfy	3009/tcp   PXC-NTFY
pxc-ntfy	3009/udp   PXC-NTFY
#			   Takeshi Nishizawa <takeshi@cp10.es.xerox.com>
gw              3010/tcp   Telerate Workstation
ping-pong       3010/udp   Telerate Workstation
#                          Timo Sivonen <timo.sivonen@ccmail.dowjones.com>
trusted-web	3011/tcp   Trusted Web
trusted-web	3011/udp   Trusted Web
twsdss		3012/tcp   Trusted Web Client
twsdss		3012/udp   Trusted Web Client
#			   Alex Duncan <alex.duncan@sse.ie>
gilatskysurfer	3013/tcp   Gilat Sky Surfer
gilatskysurfer	3013/udp   Gilat Sky Surfer
#			   Yossi Gal <yossi@gilat.com>
broker_service	3014/tcp   Broker Service
broker_service	3014/udp   Broker Service
#			   Dale Bethers <dbethers@novell.com>
nati-dstp	3015/tcp   NATI DSTP
nati-dstp	3015/udp   NATI DSTP
#			   Paul Austin <paul.austin@natinst.com>
notify_srvr	3016/tcp   Notify Server
notify_srvr	3016/udp   Notify Server
#			   Hugo Parra <hparra@novell.com>
event_listener	3017/tcp   Event Listener
event_listener	3017/udp   Event Listener
#			   Ted Tronson <ttronson@novell.com>
srvc_registry	3018/tcp   Service Registry
srvc_registry	3018/udp   Service Registry
#			   Mark Killgore <MKillgore@novell.com>
resource_mgr	3019/tcp   Resource Manager
resource_mgr	3019/udp   Resource Manager
#			   Gary Glover <gglover@novell.com>
cifs		3020/tcp   CIFS
cifs		3020/udp   CIFS
#			   Paul Leach <paulle@microsoft.com>
agriserver	3021/tcp   AGRI Server
agriserver	3021/udp   AGRI Server
#			   Frank Neulichedl <frank@websmile.com>
#               3022-3046  Unassigned
hlserver        3047/tcp   Fast Security HL Server
hlserver        3047/udp   Fast Security HL Server
#                          Michael Zunke <mzunke@fast-ag.de>
pctrader        3048/tcp   Sierra Net PC Trader
pctrader        3048/udp   Sierra Net PC Trader
#                          Chris Hahn <chrish@sierra.net>
nsws		3049/tcp   NSWS
nsws		3049/udp   NSWS
#                          Ray Gwinn <p00321@psilink.com>
#		3050-3104  Unassigned
cardbox		3105/tcp   Cardbox
cardbox		3105/udp   Cardbox
cardbox-http	3106/tcp   Cardbox HTTP
cardbox-http	3106/udp   Cardbox HTTP
#			   Martin Kochanski <martin@cardbox.co.uk>
#		3107-3129  Unassigned
icpv2		3130/tcp   ICPv2
icpv2		3130/udp   ICPv2
#			   Duane Wessels <wessels@nlanr.net>
netbookmark	3131/tcp   Net Book Mark
netbookmark	3131/udp   Net Book Mark
#			   Yiftach Ravid <yiftach@haifa.vnet.ibm.com>
#		3132-3140  Unassigned
vmodem          3141/tcp   VMODEM
vmodem          3141/udp   VMODEM
#                          Ray Gwinn <p00321@psilink.com>
rdc-wh-eos	3142/tcp   RDC WH EOS
rdc-wh-eos	3142/udp   RDC WH EOS
#			   Udi Nir <udi_nir@ncc.co.il>
seaview		3143/tcp   Sea View
seaview		3143/udp   Sea View
#			   Jim Flaherty <jim_e_flaherty@notes.seagate.com>
tarantella	3144/tcp   Tarantella
tarantella	3144/udp   Tarantella
#			   Roger Binns <rogerb@sco.com>
csi-lfap	3145/tcp   CSI-LFAP
csi-lfap	3145/udp   CSI-LFAP
#			   Paul Amsden <amsden@.ctron.com>
#		3146	   Unassigned
rfio		3147/tcp   RFIO
rfio		3147/udp   RFIO
#			   Frederic Hemmer <Frederic.Hemmer@cern.ch>
#		3148-3179  Unassigned
mc-brk-srv	3180/tcp   Millicent Broker Server
mc-brk-srv	3180/udp   Millicent Broker Server
#			   Steve Glassman <steveg@pa.dec.com>
#		3181-3263  Unassigned
ccmail          3264/tcp   cc:mail/lotus
ccmail          3264/udp   cc:mail/lotus
altav-tunnel    3265/tcp   Altav Tunnel
altav-tunnel	3265/udp   Altav Tunnel
#			   Matt Thomas <matt.thomas@altavista-software.com>
ns-cfg-server   3266/tcp   NS CFG Server
ns-cfg-server   3266/udp   NS CFG Server
#			   Aivi Lie <LIEA@netsoft.com>
ibm-dial-out    3267/tcp   IBM Dial Out
ibm-dial-out    3267/udp   IBM Dial Out
#			   Skip Booth <sbooth@VNET.IBM.COM>
msft-gc		3268/tcp   Microsoft Global Catalog
msft-gc		3268/udp   Microsoft Global Catalog
msft-gc-ssl	3269/tcp   Microsoft Global Catalog with LDAP/SSL
msft-gc-ssl     3269/udp   Microsoft Global Catalog with LDAP/SSL
#  			   Steve Judd <stevenju@.microsoft.com>
verismart	3270/tcp   Verismart
verismart	3270/udp   Verismart
#			   Jay Weber <weber@vfi.com>
csoft-prev	3271/tcp   CSoft Prev Port
csoft-prev	3271/udp   CSoft Prev Port
#			   Nedelcho Stanev <decho@iname.com>
user-manager 	3272/tcp   Fujitsu User Manager
user-manager	3272/udp   Fujitsu User Manager
#			   Yukihiko Sakurai <y-sakurai@ael.fujitsu.co.jp>
sxmp		3273/tcp   Simple Extensible Multiplexed Protocol
sxmp		3273/udp   Simple Extensible Multiplexed Protocol
#			   Jerry Jongerius <jerryj@webdash.com>
ordinox-server	3274/tcp   Ordinox Server
ordinox-server	3274/udp   Ordinox Server
#			   Guy Letourneau <gletourneau@ordinox.com>
samd		3275/tcp   SAMD
samd		3275/udp   SAMD
#			   Edgar Circenis <ec@fc.hp.com>
maxim-asics	3276/tcp   Maxim ASICs
maxim-asics	3276/udp   Maxim ASICs
#			   Dave Inman <davei@mxim.com>
awg-proxy	3277/tcp   AWG Proxy
awg-proxy	3277/udp   AWG Proxy
#			   Alex McDonald <alexm@an.hp.com>
lkcmserver	3278/tcp   LKCM Server
lkcmserver	3278/udp   LKCM Server
#			   Javier Jimenez
admind		3279/tcp   admind
admind		3279/udp   admind
#			   Jeff Haynes <haynes@chistech.com>
vs-server	3280/tcp   VS Server
vs-server	3280/udp   VS Server
#			   Scott Godlew <Scott@godlew.com>
sysopt		3281/tcp   SYSOPT
sysopt 		3281/udp   SYSOPT
#			   Tony Hoffman <ajh@unx.dec.com>
datusorb	3282/tcp   Datusorb
datusorb	3282/udp   Datusorb
#			   Thomas Martin <thomas@datus-usa.com>
net-assistant	3283/tcp   Net Assistant
net-assistant	3283/udp   Net Assistant
#			   Michael Stein <mvs@apple.com>
4talk		3284/tcp   4Talk
4talk		3284/udp   4Talk
#			   Tony Bushnell <tony_bushnell@four-sight.co.uk>
plato		3285/tcp   Plato
plato		3285/udp   Plato
#			   Jim Battin <battin@tro.com>
e-net		3286/tcp   E-Net
e-net		3286/udp   E-Net
#			   Steven Grigsby <sgrigsby@austin.eent.com>
directvdata	3287/tcp   DIRECTVDATA
directvdata	3287/udp   DIRECTVDATA
#			   Michael Friedman <mfr1@worldnet.att.net>
cops		3288/tcp   COPS
cops 		3288/udp   COPS
#			   Shai Herzog <herzog@iphighway.com>
enpc		3289/tcp   ENPC
enpc		3289/udp   ENPC
#			   SEIKO EPSON <Ishida.Hitoshi@exc.epson.co.jp>
caps-lm		3290/tcp   CAPS LOGISTICS TOOLKIT - LM
caps-lm		3290/udp   CAPS LOGISTICS TOOLKIT - LM
#			   Joseph Krebs <joek@caps.com>
sah-lm		3291/tcp   S A Holditch & Associates - LM
sah-lm		3291/udp   S A Holditch & Associates - LM
#			   Randy Hudgens <rhh@nmail.holditch.com>
cart-o-rama	3292/tcp   Cart O Rama
cart-o-rama	3292/udp   Cart O Rama
#			   Phillip Dillinger <Phillip.Dillinger@sealabs.com>
fg-fps		3293/tcp   fg-fps
fg-fps		3293/udp   fg-fps
fg-gip		3294/tcp   fg-gip
fg-gip		3294/udp   fg-gip
#			   Jean-Marc Frailong <jmf@freegate.net>
dyniplookup	3295/tcp   Dynamic IP Lookup
dyniplookup	3295/udp   Dynamic IP Lookup
#			   Eugene Osovetsky <eugeneo@geocities.com>
rib-slm		3296/tcp   Rib License Manager
rib-slm		3296/udp   Rib License Manager
#			   Kristean Heisler <kh@rib.de>
cytel-lm	3297/tcp   Cytel License Manager
cytel-lm	3297/udp   Cytel License Manager
#			   Yogesh P. Gajjar <yogesh@cytel.com>
transview	3298/tcp   Transview
transview	3298/udp   Transview
#			   Richard Obermeier <richard.obermeier@mch.sni.de>
pdrncs		3299/tcp   pdrncs
pdrncs		3299/udp   pdrncs
#			   Paul Wissenbach <paulwi@vnd.tek.com>
bmcpatrolagent	3300/tcp   BMC Patrol Agent
bmcpatrolagent  3300/udp   BMC Patrol Agent
bmcpatrolrnvu	3301/tcp   BMC Patrol Rendezvous
bmcpatrolrnvu   3301/udp   BMC Patrol Rendezvous
#			   Eric Anderson <eric_anderson@bmc.com>
mcs-fastmail	3302/tcp   MCS Fastmail
mcs-fastmail	3302/udp   MCS Fastmail
#			   Patti Jo Newsom <pjn@mcsdallas.com>
opsession-clnt	3303/tcp   OP Session Client
opsession-clnt  3303/udp   OP Session Client
opsession-srvr  3304/tcp   OP Session Server
opsession-srvr  3304/udp   OP Session Server
#			   Amir Blich <amir@netmanage.co.il>
odette-ftp	3305/tcp   ODETTE-FTP
odette-ftp	3305/udp   ODETTE-FTP
#			   David Nash <dnash@ford.com>
mysql		3306/tcp   MySQL
mysql		3306/udp   MySQL
#			   Monty <monty@analytikerna.se>
opsession-prxy	3307/tcp   OP Session Proxy
opsession-prxy	3307/udp   OP Session Proxy
#			   Amir Blich <amir@netmanage.co.il>
tns-server	3308/tcp   TNS Server
tns-server	3308/udp   TNS Server
tns-adv		3309/tcp   TNS ADV
tns-adv		3309/udp   TND ADV
#			   Jerome Albin <albin@taec.enet.dec.com>
dyna-access	3310/tcp   Dyna Access
dyna-access	3310/udp   Dyna Access
#			   Dave Belliveau
#			   <DaveBelliveau@cornerstonesoftware.com>
mcns-tel-ret	3311/tcp   MCNS Tel Ret
mcns-tel-ret	3311/udp   MCNS Tel Ret
#			   Randall Atkinson <rja@home.net>
appman-server	3312/tcp   Application Management Server
appman-server	3312/udp   Application Management Server
uorb		3313/tcp   Unify Object Broker
uorb		3313/udp   Unify Object Broker
uohost		3314/tcp   Unify Object Host
uohost		3314/udp   Unify Object Host
#			   Dave Glende <dmg@unify.com>
cdid		3315/tcp   CDID
cdid		3315/udp   CDID
#			   Andrew Borisov <hd@glasnet.ru>
aicc-cmi	3316/tcp   AICC/CMI
aicc-cmi	3316/udp   AICC/CMI
#			   William McDonald <billmc@atc.boeing.com>
vsaiport	3317/tcp   VSAI PORT
vsaiport	3317/udp   VSAI PORT
#			   Rieko Asai <asai@isl.mei.co.jp>
ssrip		3318/tcp   Swith to Swith Routing Information Protocol
ssrip		3318/udp   Swith to Swith Routing Information Protocol
#			   Baba Hidekazu <baba@flare.nd.net.fujitsu.co.jp>
sdt-lmd		3319/tcp   SDT License Manager
sdt-lmd		3319/udp   SDT License Manager
#			   Salvo Nassisi <sdtech@tin.it>
officelink2000	3320/tcp   Office Link 2000
officelink2000	3320/udp   Office Link 2000
#			   Mike Balch <mbalch@teltone.com>
vnsstr		3321/tcp   VNSSTR
vnsstr		3321/udp   VNSSTR
#			   Takeshi Ohmura <ohmura@isl.mei.co.jp>
active-net	3322-3325  Active Networks
#			   Bob Braden <braden@isi.edu>
sftu		3326/tcp   SFTU
sftu		3326/udp   SFTU
#		   Eduardo Rosenberg de Moura <eduardor@spacenet.com.br>
bbars		3327/tcp   BBARS
bbars		3327/udp   BBARS
#			   George Stevens <gstevens@bandl.com>
egptlm		3328/tcp   Eaglepoint License Manager
egptlm		3328/udp   Eaglepoint License Manager
#			   Dave Benton <dave.benton@eaglepoint.com>
hp-device-disc  3329/tcp   HP Device Disc
hp-device-disc  3329/udp   HP Device Disc
#			   Shivaun Albright <shivaun_albright@hp.com>
mcs-calypsoicf  3330/tcp   MCS Calypso ICF
mcs-calypsoicf  3330/udp   MCS Calypso ICF
mcs-messaging	3331/tcp   MCS Messaging
mcs-messaging	3331/udp   MCS Messaging
mcs-mailsvr	3332/tcp   MCS Mail Server
mcs-mailsvr	3332/udp   MCS Mail Server
#			   Patti Jo Newsom <pjn@mcsdallas.com>
dec-notes       3333/tcp   DEC Notes
dec-notes       3333/udp   DEC Notes
#                          Kim Moraros <moraros@via.enet.dec.com>
directv-web	3334/tcp   Direct TV Webcasting
directv-web	3334/udp   Direct TV Webcasting
directv-soft	3335/tcp   Direct TV Software Updates
directv-soft	3335/udp   Direct TV Software Updates
directv-tick	3336/tcp   Direct TV Tickers
directv-tick	3336/udp   Direct TV Tickers
directv-catlg	3337/tcp   Direct TV Data Catalog
directv-catlg	3337/udp   Direct TV Data Catalog
#			   Michael Friedman <mfr1@worldnet.att.net>
anet-b		3338/tcp   OMF data b
anet-b		3338/udp   OMF data b
anet-l		3339/tcp   OMF data l
anet-l		3339/udp   OMF data l
anet-m		3340/tcp   OMF data m
anet-m		3340/udp   OMF data m
anet-h		3341/tcp   OMF data h
anet-h		3341/udp   OMF data h
#			   Per Sahlqvist <psahlqvi@sw.seisy.abb.se>
webtie		3342/tcp   WebTIE
webtie		3342/udp   WebTIE
#			   Kevin Frender <kbf@ngdc.noaa.gov>
ms-cluster-net	3343/tcp   MS Cluster Net
ms-cluster-net	3343/udp   MS Cluster Net
#			   Mike Massa <mikemas@microsoft.com>
bnt-manager	3344/tcp   BNT Manager
bnt-manager	3344/udp   BNT Manager
#			   Brian Ives <Brian_J_Ives@compuserve.com>
influence	3345/tcp   Influence
influence	3345/udp   Influence
#			   Russ Ferriday <russf@topia.com>
trnsprntproxy	3346/tcp   Trnsprnt Proxy
trnsprntproxy   3346/udp   Trnsprnt Proxy
#			   Grant Kirby <grant_kirby@ccm.al.intel.com>
phoenix-rpc	3347/tcp   Phoenix RPC
phoenix-rpc	3347/udp   Phoenix RPC
#			   Ian Anderson <ian_anderson@phoenix.com>
pangolin-laser	3348/tcp   Pangolin Laser
pangolin-laser	3348/udp   Pangolin Laser
#			   William Benner <William_Benner@msn.com>
chevinservices	3349/tcp   Chevin Services
chevinservices  3349/tcp   Chevin Services
#			   Gus McNaughton <gus@chevin.com>
findviatv	3350/tcp   FINDVIATV
findviatv	3350/udp   FINDVIATV
#			   Oran Davis <oran@8x8.com>
btrieve		3351/tcp   BTRIEVE
btrieve		3351/udp   BTRIEVE
ssql		3352/tcp   SSQL
ssql		3352/udp   SSQL
#			   John McDowell <jmcdowel@pervasive-sw.com>
fatpipe		3353/tcp   FATPIPE
fatpipe		3353/udp   FATPIPE
#			   Sanchaita Datta <sdatta@ragula.com>
suitjd		3354/tcp   SUITJD
suitjd		3354/udp   SUITJD
#			   Todd Moyer <tsm@unx.dec.com>
ordinox-dbase	3355/tcp   Ordinox Dbase
ordinox-dbase	3355/udp   Ordinox Dbase
#			   Guy Litourneau <gletourneau@ordinox.com>
upnotifyps	3356/tcp   UPNOTIFYPS
upnotifyps	3356/udp   UPNOTIFYPS
#			   Mark Fox <markf@uplanet.com>
adtech-test	3357/tcp   Adtech Test IP
adtech-test	3357/udp   Adtech Test IP
#			   Robin Uyeshiro <robin_u@adtech-inc.com>
mpsysrmsvr	3358/tcp   Mp Sys Rmsvr
mpsysrmsvr	3358/udp   Mp Sys Rmsvr
#			   Hiroyuki Kawabuchi <buchi@ael.fujitsu.co.jp>   
wg-netforce	3359/tcp   WG NetForce
wg-netforce	3359/udp   WG NetForce
#			   Lee Wheat <wheat@wg.com>
kv-server	3360</tcp   KV Server
kv-server	3360/udp   KV Server
kv-agent	3361/tcp   KV Agent 
kv-agent	3361/udp   KV Agent
#			   Thomas Soranno <tom_soranno@cipartners.com>
dj-ilm		3362/tcp   DJ ILM
dj-ilm		3362/udp   DJ ILM
#			   Don Tyson
nati-vi-server	3363/tcp   NATI Vi Server
nati-vi-server	3363/udp   NATI Vi Server
#			   Robert Dye <rob@natinst.com>
creativeserver	3364/tcp   Creative Server
creativeserver	3364/udp   Creative Server
contentserver	3365/tcp   Content Server
contentserver	3365/udp   Content Server
creativepartnr	3366/tcp   Creative Partner
creativepartnr	3366/udp   Creative Partner
#			   Jesus Ortiz <Jesus_A._Ortiz@notes.emotion.com>
satvid-datalnk	3367-3371  Satellite Video Data Link
#			   Scott Engel <ScottX_Engel@ccm.jf.intel.com>
tip1		3372/tcp   TIP 1
tip1		3372/udp   TIP 1
tip2		3372/tcp   TIP 2
tip2		3372/udp   TIP 2
#			   Keith Evans <keith@loc252.tandem.com>
lavenir-lm	3373/tcp   Lavenir License Manager
lavenir-lm	3373/udp   Lavenir License Manager
#			   Marius Matioc <marius@lavenir.com>
cluster-disc	3374/tcp   Cluster Disc
cluster-disc	3374/udp   Cluster Disc
#			   Jeff Hughes <Jeff.Hughes@columbiasc.ncr.com>
vsnm-agent	3375/tcp   VSNM Agent
vsnm-agent      3375/udp   VSNM Agent
#			   Venkat Rangan <venkatr@vitalsigns.com>
cdborker	3376/tcp   CD Broker
cdbroker	3376/udp   CD Broker
#			   Moon Ho Chung <mchung@esps.com>
cogsys-lm	3377/tcp   Cogsys Network License Manager
cogsys-lm	3377/udp   Cogsys Network License Manager
#			   Simon Chinnick <support@cogsys.co.uk>
wsicopy		3378/tcp   WSICOPY
wsicopy		3378/udp   WSICOPY
#			   James Overby
socorfs		3379/tcp   SOCORFS
socorfs		3379/udp   SOCORFS
#			   Hugo Charbonneau
sns-channels	3380/tcp   SNS Channels
sns-channels	3380/udp   SNS Channels
#			   Shekar Pasumarthi <shekarp@firstfloor.com>
geneous		3381/tcp   Geneous
geneous		3381/udp   Geneous
#			   Nick de Smith <nick.desmith@histech.com>
fujitsu-neat	3382/tcp   Fujitsu Network Enhanced Antitheft function
fujitsu-neat	3382/udp   Fujitsu Network Enhanced Antitheft function
#			   Markku Viima <markku.viima@team.icl.se>
esp-lm		3383/tcp   Enterprise Software Products License Manager
esp-lm		3383/udp   Enterprise Software Products License Manager
#			   George Rudy <george@entsoft.com>
hp-clic		3384/tcp   Cluster Management Services
hp-clic 	3384/udp   Hardware Management
#			   Rajesh Srinivasaraghavan <srajesh@cup.hp.com>
qnxnetman	3385/tcp   qnxnetman
qnxnetman	3385/udp   qnxnetman
#			   Michael Hunter <mphunter@qnx.com>
gprs-data	3386/tcp   GPRS Data
gprs-sig	3386/udp   GPRS SIG
#			   Ansgar Bergmann <Ansgar.Bergmann@etsi.fr>
backroomnet	3387/tcp   Back Room Net
backroomnet	3387/udp   Back Room Net
#			   Clayton Wilkinson <cwilkinson@carreker.com>
cbserver	3388/tcp   CB Server
cbserver	3388/udp   CB Server
#			   Allen Wei <Allen_Wei@arborsoft.com>
ms-wbt-server	3389/tcp   MS WBT Server
ms-wbt-server	3389/udp   MS WBT Server
#			   Ritu Bahl <ritub@microsoft.com>
dsc		3390/tcp   Distributed Service Coordinator
dsc		3390/udp   Distributed Service Coordinator
#			   Chas Honton <chas@secant.com>
savant		3391/tcp   SAVANT
savant		3391/udp   SAVANT
#			   Andy Bruce <AndyBruce@theprogrammers.com>
efi-lm		3392/tcp   EFI License Management
efi-lm		3392/udp   EFI License Management
#			   Ross E. Greinke <greinker@execpc.com>
d2k-tapestry1	3393/tcp   D2K Tapestry Client to Server
d2k-tapestry1	3393/udp   D2K Tapestry Client to Server
d2k-tapestry2	3394/tcp   D2K Tapestry Server to Server
d2k-tapestry2	3394/udp   D2K Tapestry Server to Server
#			   Eric Lan <elan@d2k.com>
dyna-lm		3395/tcp   Dyna License Manager (Elam)
dyna-lm		3395/udp   Dyna License Manager (Elam)
#			   Anjana Iyer <anjana@dyna.com>
printer_agent	3396/tcp   Printer Agent
printer_agent	3396/udp   Printer Agent
#			   Devon Taylor <dtaylor@novell.com>
cloanto-lm	3397/tcp   Cloanto License Manager
cloanto-lm	3397/udp   Cloanto License Manager 
#		    	   Takeo Sato <takeo_sato@cloanto.com>
mercantile	3398/tcp   Mercantile
mercantile	3398/udp   Mercantile
#			   Erik Kragh Jensen <kragh@inet.uni2.dk>
#		3399-3420  Unassigned
bmap            3421/tcp   Bull Apprise portmapper
bmap            3421/udp   Bull Apprise portmapper
#                          Jeremy Gilbert <J.Gilbert@ma30.bull.com>
mira            3454/tcp   Apple Remote Access Protocol
#                          Mike Alexander <mta@um.cc.umich.edu>
prsvp           3455/tcp   RSVP Port
prsvp           3455/udp   RSVP Port
#               Bob Braden <Braden@isi.edu>
vat             3456/tcp   VAT default data
vat             3456/udp   VAT default data
#               Van Jacobson <van@ee.lbl.gov>
vat-control     3457/tcp   VAT default control
vat-control     3457/udp   VAT default control
#               Van Jacobson <van@ee.lbl.gov>
d3winosfi	3458/tcp   D3WinOsfi
d3winosfi	3458/udp   DsWinOSFI
#			   Brad Hamilton <bh@picksys.com>
integral	3459/tcp   Integral
integral 	3459/udp   Integral
#			   Olivier Mascia
edm-manager	3460/tcp   EDM Manger
edm-manager	3460/udp   EDM Manger
edm-stager	3461/tcp   EDM Stager
edm-stager	3461/udp   EDM Stager
edm-std-notify	3462/tcp   EDM STD Notify
edm-std-notify	3462/udp   EDM STD Notify
edm-adm-notify	3463/tcp   EDM ADM Notify
edm-adm-notify	3463/udp   EDM ADM Notify
edm-mgr-sync	3464/tcp   EDM MGR Sync
edm-mgr-sync	3464/udp   EDM MGR Sync
edm-mgr-cntrl	3465/tcp   EDM MGR Cntrl
edm-mgr-cntrl	3465/udp   EDM MGR Cntrl
#			   Tom Hennessy <thenn@novadigm.com>
workflow	3466/tcp   WORKFLOW
workflow	3466/udp   WORKFLOW
#			   Robert Hufsky <rhufsky@csesys.co.at>
#		3467-3562  Unassigned
watcomdebug	3563/tcp   Watcom Debug
watcomdebug	3563/udp   Watcom Debug
#			   Anthony Scian <anthony@watcom.on.ca>
#		3564-3899  Unassigned
udt_os          3900/tcp   Unidata UDT OS
udt_os          3900/udp   Unidata UDT OS
#                          James Powell <james@mailhost.unidata.com>
mapper-nodemgr  3984/tcp   MAPPER network node manager
mapper-nodemgr  3984/udp   MAPPER network node manager
mapper-mapethd  3985/tcp   MAPPER TCP/IP server
mapper-mapethd  3985/udp   MAPPER TCP/IP server
mapper-ws_ethd  3986/tcp   MAPPER workstation server
mapper-ws_ethd  3986/udp   MAPPER workstation server
#                          John C. Horton <jch@unirsvl.rsvl.unisys.com>
centerline	3987/tcp   Centerline
centerline	3987/udp   Centerline
#			   Mark Simpson <simpson@centerline.com>
#		3988-3999  Unassigned
terabase	4000/tcp   Terabase
terabase	4000/udp   Terabase
#			   Thor Olson <Thor@terabase.com>   
newoak		4001/tcp   NewOak
newoak		4001/udp   NewOak
#			   Jim Philippou <jphilippou@newoak.com>
netcheque       4008/tcp   NetCheque accounting 
netcheque       4008/udp   NetCheque accounting 
#                          B. Clifford Neuman <bcn@isi.edu>
chimera-hwm     4009/tcp   Chimera HWM
chimera-hwm	4009/udp   Chimera HWM
#			   Ken Anderson <kanderso@kleber.ICS.UCI.EDU>
samsung-unidex  4010/tcp   Samsung Unidex
samsung-unidex	4010/udp   Samsung Unidex
#			   Konstantin V. Vyaznikov <kv@ssm6000.samsung.ru>
altserviceboot	4011/tcp   Alternate Service Boot
altserviceboot	4011/udp   Alternate Service Boot
#			   Eric Dittert <Eric_Dittert@ccm.jf.intel.com>
pda-gate	4012/tcp   PDA Gate
pda-gate	4012/udp   PDA Gate
#			   Masakuni Okada <masakuni@jp.ibm.com>
acl-manager	4013/tcp   ACL Manager
acl-manager	4013/udp   ACL Manager
#			   Toru Murai <murai@saint.nm.fujitsu.co.jp>
taiclock	4014/tcp   TAICLOCK
taiclock	4014/udp   TAICLOCK
#			   Dan Bernstein <djb@koobera.math.uic.edu>
#		4015-4095  Unassigned
bre 		4096/tcp   BRE (Bridge Relay Element)
bre 		4096/udp   BRE (Bridge Relay Element)
#			   Stephen Egbert <egbert@ra.timeplex.com>
#		4097-4131  Unassigned
nuts_dem        4132/tcp   NUTS Daemon
nuts_dem        4132/udp   NUTS Daemon
nuts_bootp      4133/tcp   NUTS Bootp Server
nuts_bootp      4133/udp   NUTS Bootp Server
#                          Martin Freiss <freiss.pad@sni.>
nifty-hmi	4134/tcp   NIFTY-Serve HMI protocol
nifty-hmi	4134/udp   NIFTY-Serve HMI protocol
#			   Ryuichi Suzuki <SCI00376@niftyserve.or.jp>
oirtgsvc	4141/tcp   Workflow Server
oirtgsvc	4141/udp   Workflow Server
oidocsvc	4142/tcp   Document Server
oidocsvc	4142/udp   Document Server
oidsr		4143/tcp   Document Replication
oidsr		4143/udp   Document Replication
#		 	   Norman Brie <norm_brie@sns.ca>
##########  Compuserve (unoffically) is using port 4144 #########
#		4144-4199  Unassigned
vrml-multi-use  4200-4299  VRML Multi User Systems
#			   Mitra <mitra@earth.path.net>
corelccam	4300/tcp   Corel CCam
corelccam	4300/udp   Corel CCam
#			   Jason Aiken <jasona@corelcomputer.com>
#		4301-4320  Unassigned
rwhois          4321/tcp   Remote Who Is
rwhois          4321/udp   Remote Who Is
#                          Mark Kosters  <markk@internic.net>
unicall         4343/tcp   UNICALL
unicall         4343/udp   UNICALL
#                          James Powell <james@enghp.unidata.comp>
vinainstall 	4344/tcp   VinaInstall
vinainstall	4344/udp   VinaInstall
#			   Jay Slupesky <js@vina-tech.com>
m4-network-as	4345/tcp   Macro 4 Network AS
m4-network-as   4345/udp   Macro 4 Network AS
#			   Paul Wren <Paul.Wren@macro4.com>
elanlm		4346/tcp   ELAN LM
elanlm		4346/udp   ELAN LM
#			   Paul Ballew <ballew@projtech.com>
lansurveyor	4347/tcp   LAN Surveyor
lansurveyor	4347/udp   LAN Surveyor
#			   Michael Swan <swan@neon.com>
itose		4348/tcp   ITOSE
itose		4348/tcp   ITOSE
#			   Michael Haeuptle <Michael_Haeuptle@hp.com>
fsportmap	4349/tcp   File System Port Map
fsportmap	4349/udp   File System Port Map
#			   Ron Minnich <rminnich@sarnoff.com>
net-device	4350/tcp   Net Device
net-device	4350/udp   Net Device
#			   Glenn Peterson <glennp@microsoft.com>
plcy-net-svcs	4351/tcp   PLCY Net Services
plcy-net-svcs	4351/udp   PLCY Net Services
#			   J.J. Ekstrom
#		4352-4443  Unassigned
krb524          4444/tcp   KRB524
krb524          4444/udp   KRB524
#                          B. Clifford Neuman <bcn@isi.edu>
# PROBLEM krb524 assigned the port, 
# PROBLEM nv used it without an assignment
nv-video        4444/tcp   NV Video default
nv-video        4444/udp   NV Video default
#               Ron Frederick <frederick@parc.xerox.com>
upnotifyp	4445/tcp   UPNOTIFYP
upnotifyp 	4445/udp   UPNOTIFYP
#			   Mark Fox <markf@uplanet.com>
n1-fwp		4446/tcp   N1-FWP
n1-fwp		4446/udp   N1-FWP
n1-rmgmt	4447/tcp   N1-RMGMT
n1-rmgmt	4447/udp   N1-RMGMT
#			   Lori Tassin <Ramsey@network-1.com>
asc-slmd	4448/tcp   ASC Licence Manager
asc-slmd	4448/udp   ASC Licence Manager
#			   Casper Stoel <cbs@ascinc.com>
arcryptoip      4449/tcp   ARCrypto IP
arcryptoip      4449/udp   ARCrypto IP
#			   Uri Resnitzky <uri@arx.com>
camp		4450/tcp   Camp
camp		4450/udp   Camp
ctisystemmsg    4451/tcp   CTI System Msg
ctisystemmsg    4451/udp   CTI System Msg
ctiprogramload  4452/tcp   CTI Program Load
ctiprogramload  4452/udp   CTI Program Load
#			   Steven Cliff <sbcliff@controltechnology.com>
nssalertmgr 	4453/tcp   NSS Alert Manager
nssalertmgr	4453/udp   NSS Alert Manager
nssagentmgr	4454/tcp   NSS Agent Manager
nssagentmgr 	4454/udp   NSS Agent Manager
#			   Jim Hill<jhill@symantec.com>
prchat-user	4455/tcp   PR Chat User
prchat-user	4455/udp   PR Chat User
prchat-server	4456/tcp   PR Chat Server
prchat-server	4456/udp   PR Chat Server
prRegister	4457/tcp   PR Register
prRegister	4457/udp   PR Register
#			   Donny Gilor <dgilor@pop01.ny.us.ibm.net>
#		4458-4499  Unassigned
sae-urn         4500/tcp   sae-urn
sae-urn         4500/udp   sae-urn
urn-x-cdchoice  4501/tcp   urn-x-cdchoice
urn-x-cdchoice  4501/udp   urn-x-cdchoice
#                          Paul Hoffman <phoffman@proper.com>
highscore	4545/tcp   Highscore
highscore	4545/udp   Highscore
#			   Chris Flynn <Chris@highscore.com>
sf-lm		4546/tcp   SF License Manager (Sentinel)
sf-lm		4546/udp   SF License Manager (Sentinel)
#			   Thomas Koell <koell@sf.com>
lanner-lm	4547/tcp   Lanner License Manager
lanner-lm	4547/udp   Lanner License Manager
#			   Les Enstone <lenstone@lanner.co.uk>
#		4548-4671  Unassigned
rfa             4672/tcp   remote file access server
rfa             4672/udp   remote file access server
#		4673-4867  Unassigned
phrelay		4868/tcp   Photon Relay
phrelay		4868/udp   Photon Relay
phrelaydbg	4869/tcp   Photon Relay Debug
phrelaydbg	4869/udp   Photon Relay Debug
#			   Michael Hunter <mphunter@qnx.com>
commplex-main	5000/tcp
commplex-main	5000/udp
commplex-link	5001/tcp
commplex-link	5001/udp
rfe             5002/tcp   radio free ethernet
rfe             5002/udp   radio free ethernet
claris-fmpro    5003/tcp   Claris FileMaker Pro
claris-fmpro    5003/udp   Claris FileMaker Pro
#                          Jon Thatcher <jon_thatcher@qm.claris.com>
avt-profile-1   5004/tcp   avt-profile-1
avt-profile-1   5004/udp   avt-profile-1
avt-profile-2   5005/tcp   avt-profile-2
avt-profile-2   5005/udp   avt-profile-2
#                          Henning Schulzrinne <schulzrinne@fokus.gmd.de>
telelpathstart  5010/tcp   TelepathStart
telelpathstart  5010/udp   TelepathStart
telelpathattack 5011/tcp   TelepathAttack
telelpathattack 5011/udp   TelepathAttack
#               Helmuth Breitenfellner <hbreitenf@vnet.imb.com>
zenginkyo-1     5020/tcp    zenginkyo-1
zenginkyo-1     5020/udp    zenginkyo-1
zenginkyo-2     5021/tcp    zenginkyo-2
zenginkyo-2     5021/udp    zenginkyo-2
#                           Masashi Suzaki <susakim@noa.nttdata.jp>
mmcc            5050/tcp   multimedia conference control tool
mmcc            5050/udp   multimedia conference control tool
#               Steve Casner <Casner@isi.edu>
ita-agent	5051/tcp    ITA Agent
ita-agent	5051/udp    ITA Agent
ita-manager	5052/tcp    ITA Manager
ita-manager	5052/udp    ITA Manager
#			    Don Merrell <donmer@axent.com>
rmonitor_secure	5145/tcp
rmonitor_secure	5145/udp
atmp            5150/tcp   Ascend Tunnel Management Protocol
atmp            5150/udp   Ascend Tunnel Management Protocol
#                          Kory Hamzeh <kory@ascend.com>
aol             5190/tcp   America-Online
aol             5190/udp   America-Online
#                          Marty Lyons <marty@aol.com>
aol-1           5191/tcp   AmericaOnline1
aol-1           5191/udp   AmericaOnline1
aol-2           5192/tcp   AmericaOnline2
aol-2           5192/udp   AmericaOnline2
aol-3           5193/tcp   AmericaOnline3
aol-3           5193/udp   AmericaOnline3
#                          Bruce Mackey <BAMackey@aol.com>
padl2sim	5236/tcp
padl2sim	5236/udp

pk		5272/tcp   PK
pk		5272/udp   PK
#			   Patrick Kara <Patrick@EBA.NET>
hacl-hb		5300/tcp	# HA cluster heartbeat
hacl-hb		5300/udp	# HA cluster heartbeat
hacl-gs		5301/tcp	# HA cluster general services
hacl-gs		5301/udp	# HA cluster general services
hacl-cfg	5302/tcp	# HA cluster configuration
hacl-cfg	5302/udp	# HA cluster configuration
hacl-probe	5303/tcp	# HA cluster probing
hacl-probe	5303/udp	# HA cluster probing
hacl-local      5304/tcp        # HA Cluster Commands
hacl-local      5304/udp        
hacl-test       5305/tcp        # HA Cluster Test                    
hacl-test       5305/udp                            
#                               Eric Soderberg <seric@hposl102.cup.hp>
#                               Edward Yim <eyim@hpmfas4.cup.hp.com>
sun-mc-grp	5306/tcp   Sun MC Group
sun-mc-grp	5306/udp   Sun MC Group
#			   Michael DeMoney <demoney@eng.sun.com>
sco-aip		5307/tcp   SCO AIP
sco-aip		5307/udp   SCO AIP
#			   Barrie Cooper <barrie@sco.com>
cfengine 	5308/tcp   CFengine
cfengine	5308/udp   CFengine
#			   Mark Burgess <mark.burgess@iu.hioslo.no>
jprinter	5309/tcp   J Printer
jprinter  	5309/udp   J Printer
#			   Ken Blackwell <kenb@bristol.com>
outlaws		5310/tcp   Outlaws
outlaws		5310/udp   Outlaws
#			   Richard Fife <richardf@lucasarts.com>
tmlogin		5311/tcp   TM Login
tmlogin		5311/udp   TM Login
#			   Eric Sharakan <eric.sharakan@east.sun.com>
#     		5312-5399  Unassigned
excerpt		5400/tcp   Excerpt Search
excerpt		5400/udp   Excerpt Search
excerpts	5401/tcp   Excerpt Search Secure
excerpts	5401/udp   Excerpt Search Secure
#			   John Hinsdale <hin@alma.com>
mftp		5402/tcp   MFTP
mftp		5402/udp   MFTP
#			   Alan Rosenberg <arosen@starburstcom.com>
hpoms-ci-lstn   5403/tcp   HPOMS-CI-LSTN
hpoms-ci-lstn	5403/udp   HPOMS-CI-LSTN
hpoms-dps-lstn  5404/tcp   HPOMS-DPS-LSTN
hpoms-dps-lstn  5404/udp   HPOMS-DPS-LSTN
#			   Harold Froehling <hrf@cup.hp.com>
netsupport	5405/tcp   NetSupport
netsupport	5405/udp   NetSupport
#			   Paul Sanders <pe77@dial.pipex.com>
systemics-sox	5406/tcp   Systemics Sox
systemics-sox	5406/udp   Systemics Sox
#			   Gary Howland <gary@systemics.com>
foresyte-clear  5407/tcp   Foresyte-Clear
foresyte-clear  5407/udp   Foresyte-Clear
foresyte-sec    5408/tcp   Foresyte-Sec
foresyte-sec	5408/udp   Foresyte-Sec
#			   Jorge Aldana <operator@foresyte.com>
salient-dtasrv  5409/tcp   Salient Data Server
salient-dtasrv  5409/udp   Salient Data Server
salient-usrmgr  5410/tcp   Salient User Manager
salient-usrmgr  5410/udp   Salient User Manager
#			   Richard Farnham <rfarnham@margin-minder.com>
actnet		5411/tcp   ActNet
actnet		5411/udp   ActNet
#			   Simon Robillard <RobillardS@actresearch.com>
continuus	5412/tcp   Continuus
continuus	5412/udp   Continuus
#			   Steven Holtsberg <steveh@continuus.com>
wwiotalk	5413/tcp   WWIOTALK
wwiotalk	5413/udp   WWIOTALK
#			   Roger Knobbe <RogerK@Wonderware.COM>
statusd		5414/tcp   StatusD
statusd		5414/udp   StatusD
#			   Stephen Misel <steve@satelnet.org>
ns-server	5415/tcp   NS Server
ns-server	5415/udp   NS Server
#			   Jeffrey Chiao <chiaoj@netsoft.com>
sns-gateway	5416/tcp   SNS Gateway
sns-gateway	5416/udp   SNS Gateway
sns-agent	5417/tcp   SNS Agent
sns-agent	5417/udp   SNS Agent
#	    		   Mary Holstage <holstege@firstfloor.com>
mcntp		5418/tcp   MCNTP
mcntp		5418/udp   MCNTP
#			   Heiko Rupp <hwr@pilhuhn.de>
dj-ice		5419/tcp   DJ-ICE
dj-ice		5419/udp   DJ-ICE
#			   Don Tyson <don.tyson@cor.dowjones.com>
cylink-c	5420/tcp   Cylink-C
cylink-c	5420/udp   Cylink-C
#			   John Jobe <jjobe@cylink.com>
#		5421-5499  Unassigned
fcp-addr-srvr1  5500/tcp   fcp-addr-srvr1
fcp-addr-srvr1  5500/udp   fcp-addr-srvr1
fcp-addr-srvr2  5501/tcp   fcp-addr-srvr2
fcp-addr-srvr2  5501/udp   fcp-addr-srvr2
fcp-srvr-inst1  5502/tcp   fcp-srvr-inst1
fcp-srvr-inst1  5502/udp   fcp-srvr-inst1
fcp-srvr-inst2  5503/tcp   fcp-srvr-inst2
fcp-srvr-inst2  5503/udp   fcp-srvr-inst2
fcp-cics-gw1    5504/tcp   fcp-cics-gw1
fcp-cics-gw1    5504/udp   fcp-cics-gw1
#			   Mark Zeiss <mark.r.zeiss@ac.com>
#		5504-5554  Unassigned
############Port 5555 also used by HP Omniback#####################
personal-agent  5555/tcp   Personal Agent
personal-agent  5555/udp   Personal Agent
#			   Jackie Wu <jackiew@infoseek.com>
###################################################################
#		5556-5598  Unassigned
esinstall	5599/tcp   Enterprise Security Remote Install
esinstall	5599/udp   Enterprise Security Remote Install
esmmanager	5600/tcp   Enterprise Security Manager
esmmanager	5600/udp   Enterprise Security Manager
esmagent	5601/tcp   Enterprise Security Agent
esmagent	5601/udp   Enterprise Security Agent
#			   Kimberly Gibbs <kimgib@CCGATE-UT.AXENT.COM>
a1-msc		5602/tcp   A1-MSC
a1-msc		5602/udp   A1-MSC
a1-bs		5603/tcp   A1-BS
a1-bs		5603/udp   A1-BS
a3-sdunode	5604/tcp   A3-SDUNode
a3-sdunode	5604/udp   A3-SDUNode
a4-sdunode	5605/tcp   A4-SDUNode
a4-sdunode	5605/udp   A4-SDUNode
#			   Mike Dolan <MDolan@ihcmail.ih.lucent.com>
pcanywheredata  5631/tcp   pcANYWHEREdata
pcanywheredata  5631/udp   pcANYWHEREdata
pcanywherestat  5632/tcp   pcANYWHEREstat
pcanywherestat  5632/udp   pcANYWHEREstat
#                          Jon Rosarky <JRosarky@symantec.com>
rrac            5678/tcp   Remote Replication Agent Connection  
rrac            5678/udp   Remote Replication Agent Connection  
dccm            5679/tcp   Direct Cable Connect Manager
dccm            5679/udp   Direct Cable Connect Manager
#                          Mark Miller <mmiller@MICROSOFT.com>
proshareaudio   5713/tcp   proshare conf audio
proshareaudio   5713/udp   proshare conf audio
prosharevideo   5714/tcp   proshare conf video
prosharevideo   5714/udp   proshare conf video
prosharedata    5715/tcp   proshare conf data 
prosharedata    5715/udp   proshare conf data 
prosharerequest 5716/tcp   proshare conf request
prosharerequest 5716/udp   proshare conf request
prosharenotify  5717/tcp   proshare conf notify 
prosharenotify  5717/udp   proshare conf notify 
#                          <gunner@ibeam.intel.com>
openmail        5729/tcp   Openmail User Agent Layer
openmail        5729/udp   Openmail User Agent Layer
#                          OpenMail Encyclopedia <opencyc@hpopd.pwd.hp.com>
#                          Don Loughry <DON_LOUGHRY@hp-cupertino-om4.om.hp.com>
ida-discover1   5741/tcp   IDA Discover Port 1
ida-discover1   5741/udp   IDA Discover Port 1
ida-discover2   5742/tcp   IDA Discover Port 2
ida-discover2   5742/udp   IDA Discover Port 2
#                          Morten Christensen <morten.christensen@I-DATA.COM>
fcopy-server    5745/tcp   fcopy-server
fcopy-server    5745/udp   fcopy-server
fcopys-server   5746/tcp   fcopys-server
fcopys-server   5746/udp   fcopys-server
#                          Moshe Leibovitch <moshe@softlinkusa.com
openmailg       5755/tcp   OpenMail Desk Gateway server
openmailg       5755/udp   OpenMail Desk Gateway server
x500ms          5757/tcp   OpenMail X.500 Directory Server
x500ms          5757/udp   OpenMail X.500 Directory Server
openmailns      5766/tcp   OpenMail NewMail Server
openmailns      5766/udp   OpenMail NewMail Server
s-openmail      5767/tcp   OpenMail Suer Agent Layer (Secure)
s-openmail      5767/udp   OpenMail Suer Agent Layer (Secure)
openmailpxy	5768/tcp   OpenMail CMTS Server
openmailpxy	5768/udp   OpenMail CMTS Server
#                          OpenMail Encyclopedia <opencyc@hpopd.pwd.hp.com>
#                          Don Loughry <DON_LOUGHRY@hp-cupertino-om4.om.hp.com>
x11             6000-6063/tcp   X Window System
x11             6000-6063/udp   X Window System
#               Stephen Gildea <gildea@expo.lcs.mit.edu>
softcm          6110/tcp   HP SoftBench CM
softcm          6110/udp   HP SoftBench CM
spc             6111/tcp   HP SoftBench Sub-Process Control
spc             6111/udp   HP SoftBench Sub-Process Control
#                          Scott A. Kramer <sk@tleilaxu.sde.hp.com>
dtspcd          6112/tcp   dtspcd
dtspcd          6112/udp   dtspcd   
#                          Doug Royer <Doug.Royer@eng.sun.com>
backup-express  6123/tcp   Backup Express
backup-express  6123/udp   Backup Express
#			   Chi Shih Chang <cchang@syncsort.com>
meta-corp       6141/tcp   Meta Corporation License Manager
meta-corp       6141/udp   Meta Corporation License Manager
#                          Osamu Masuda <--none--->
aspentec-lm     6142/tcp   Aspen Technology License Manager
aspentec-lm     6142/udp   Aspen Technology License Manager
#                          Kevin Massey <massey@aspentec.com>
watershed-lm    6143/tcp   Watershed License Manager
watershed-lm    6143/udp   Watershed License Manager
#                          David Ferrero <david@zion.com>
statsci1-lm     6144/tcp   StatSci License Manager - 1
statsci1-lm     6144/udp   StatSci License Manager - 1
statsci2-lm     6145/tcp   StatSci License Manager - 2
statsci2-lm     6145/udp   StatSci License Manager - 2
#                          Scott Blachowicz <scott@statsci.com>
lonewolf-lm     6146/tcp   Lone Wolf Systems License Manager
lonewolf-lm     6146/udp   Lone Wolf Systems License Manager
#                          Dan Klein <dvk@lonewolf.com>
montage-lm      6147/tcp   Montage License Manager
montage-lm      6147/udp   Montage License Manager
#                          Michael Ubell <michael@montage.com>
ricardo-lm      6148/tcp   Ricardo North America License Manager
ricardo-lm      6148/udp   Ricardo North America License Manager
#                          M Flemming <mflemming@aol.com>
tal-pod         6149/tcp    tal-pod 
tal-pod         6149/udp    tal-pod 
#                           Steven Loomis <srl@taligent.com>
crip            6253/tcp    CRIP
crip            6253/udp    CRIP
#                           Mike Rodbell <mrodbell@ciena.com> 
clariion-evr01  6389/tcp    clariion-evr01
clariion-evr01  6389/udp    clariion-evr01
#                           Dave DesRoches <ddesroches@clariion.com>
skip-cert-recv  6455/tcp   SKIP Certificate Receive
skip-cert-send  6456/tcp   SKIP Certificate Send
#                          Tom Markson <markson@osmosys.incog.com>
lvision-lm	6471/tcp   LVision License Manager
lvision-lm	6471/udp   LVision License Manager
#			   Brian McKinnon <bmk@lvision.com>
#		6472-6499  Unassigned
boks		6500/tcp   BoKS Master
boks		6500/udp   BoKS Master
boks_servc	6501/tcp   BoKS Servc
boks_servc	6501/udp   BoKS Servc
boks_servm	6502/tcp   BoKS Servm
boks_servm	6502/udp   BoKS Servm
boks_clntd	6503/tcp   BoKS Clntd
boks_clntd	6503/udp   BoKS Clntd
#		6504       Unassigned
badm_priv	6505/tcp   BoKS Admin Private Port
badm_priv	6505/udp   BoKS Admin Private Port
badm_pub	6506/tcp   BoKS Admin Public Port
badm_pub	6506/udp   BoKS Admin Public Port
bdir_priv	6507/tcp   BoKS Dir Server, Private Port
bdir_priv	6507/udp   BoKS Dir Server, Private Port
bdir_pub	6508/tcp   BoKS Dir Server, Public Port
bdir_pub	6508/udp   BoKS Dir Server, Public Port
#			   Magnus Nystrom <magnus@dynas.se>
#               6509-6557  Unassigned
xdsxdm		6558/tcp	
xdsxdm		6558/udp	
ircu		6665-6669/tcp  IRCU
ircu		6665-6669/udp  IRCU
#			   Brian Tackett <cym@acrux.net>
vocaltec-gold   6670/tcp   Vocaltec Global Online Directory
vocaltec-gold   6670/udp   Vocaltec Global Online Directory
#                          Scott Petrack <Scott_Petrack@vocaltec.com>
vision_server   6672/tcp   vision_server
vision_server   6672/udp   vision_server
vision_elmd     6673/tcp   vision_elmd
vision_elmd     6673/udp   vision_elmd
#                          Chris Kramer <CKramer@gis.shl.com>
ambit-lm        6831/tcp   ambit-lm
ambit-lm        6831/udp   ambit-lm
#                          Don Hejna <djhejna@ambit.com>
acmsoda         6969/tcp   acmsoda
acmsoda         6969/udp   acmsoda
#                          Daniel Simms <dsimms@acm.uiuc.edu>
afs3-fileserver	7000/tcp   file server itself
afs3-fileserver	7000/udp   file server itself
afs3-callback	7001/tcp   callbacks to cache managers
afs3-callback	7001/udp   callbacks to cache managers
afs3-prserver	7002/tcp   users & groups database
afs3-prserver	7002/udp   users & groups database
afs3-vlserver	7003/tcp   volume location database
afs3-vlserver	7003/udp   volume location database
afs3-kaserver	7004/tcp   AFS/Kerberos authentication service
afs3-kaserver	7004/udp   AFS/Kerberos authentication service
afs3-volser	7005/tcp   volume managment server
afs3-volser	7005/udp   volume managment server
afs3-errors	7006/tcp   error interpretation service
afs3-errors	7006/udp   error interpretation service
afs3-bos	7007/tcp   basic overseer process
afs3-bos	7007/udp   basic overseer process
afs3-update	7008/tcp   server-to-server updater
afs3-update	7008/udp   server-to-server updater
afs3-rmtsys	7009/tcp   remote cache manager service
afs3-rmtsys	7009/udp   remote cache manager service
ups-onlinet     7010/tcp   onlinet uninterruptable power supplies
ups-onlinet     7010/udp   onlinet uninterruptable power supplies
#		           Brian Hammill <brianh@exide.com>
dpserve		7020/tcp   DP Serve
dpserve		7020/udp   DP Serve
dpserveadmin	7021/tcp   DP Serve Admin
dpserveadmin	7021/udp   DP Serve Admin
#			   Allan Stanley <allan@hummingbird.com>
lazy-ptop       7099/tcp   lazy-ptop
lazy-ptop       7099/udp   lazy-ptop
#                          Guy Keren <Guy_Keren@mail.stil.scitex.com>
font-service    7100/tcp   X Font Service
font-service    7100/udp   X Font Service
#			   Stephen Gildea <gildea@expo.lcs.mit.edu>
virprot-lm      7121/tcp   Virtual Prototypes License Manager
virprot-lm      7121/tcp   Virtual Prototypes License Manager
#               Victor Galis <galis@satchmo.virtualprototypes.ca>
clutild		7174/tcp   Clutild
clutild         7174/tcp   Clutild
#			   Cheryl Stoutenburg <cstoutenburg@vnet.ibm.com>
fodms           7200/tcp   FODMS FLIP  
fodms           7200/udp   FODMS FLIP  
#           David Anthony <anthony@power.amasd.anatcp.rockwell.com>
dlip            7201/tcp   DLIP
dlip            7201/udp   DLIP
#           Albert Manfredi <manfredi@engr05.comsys.rockwell.com>
winqedit        7395/tcp    winqedit
winqedit        7395/udp    winqedit
#                           David Greer <david_greer@robelle.com>
pmdmgr		7426/tcp    OpenView DM Postmaster Manager
pmdmgr 		7426/udp    OpenView DM Postmaster Manager
oveadmgr	7427/tcp    OpenView DM Event Agent Manager
oveadmgr	7427/udp    OpenView DM Event Agent Manager
ovladmgr	7428/tcp    OpenView DM Log Agent Manager
ovladmgr	7428/udp    OpenView DM Log Agent Manager
opi-sock	7429/tcp    OpenView DM rqt communication
opi-sock	7429/udp    OpenView DM rqt communication
xmpv7		7430/tcp    OpenView DM xmpv7 api pipe
xmpv7		7430/udp    OpenView DM xmpv7 api pipe
pmd		7431/tcp    OpenView DM ovc/xmpv3 api pipe
pmd		7431/udp    OpenView DM ovc/xmpv3 api pipe
#			    Dave Lamb <rdl@rdl.cnd.hp.com>
telops-lmd      7491/tcp    telops-lmd
telops-lmd      7491/udp    telops-lmd
#                           David Spencer <dspencer@telops.com>
pafec-lm        7511/tcp    pafec-lm
pafec-lm        7511/udp    pafec-lm
#                           Billy Dhillon <bdsos@pafec.co.uk>
aries-kfinder	7570/tcp    Aries Kfinder
aries-kfinder	7570/udp    Aries Kfinder
#			    James King, III <jking@ariessys.com>
cbt             7777/tcp    cbt
cbt             7777/udp    cbt
#                           Tony Ballardie <A.Ballardie@cs.ucl.ac.uk>
accu-lmgr       7781/tcp    accu-lmgr
accu-lmgr       7781/udp    accu-lmgr
#                           Moises E. Hernandez <moises@accugraph.com>
quest-vista	7980/tcp    Quest Vista
quest-vista	7980/udp    Quest Vista
#			    Preston Bannister <pbannister@quests.com>
irdmi2          7999/tcp    iRDMI2
irdmi2          7999/udp    iRDMI2
irdmi           8000/tcp    iRDMI
irdmi           8000/udp    iRDMI
#                           Gil Shafriri <shafriri@ilccm1.iil.intel.com>
vcom-tunnel	8001/tcp    VCOM Tunnel
vcom-tunnel	8001/udp    VCOM Tunnel
#			    Mark Lewandowski <mlewan0@us.ibm.com>
http-alt	8008/tcp    HTTP Alternate
http-alt	8008/udp    HTTP Alternate
#			    James Gettys <jg@w3.org>
pro-ed		8032/tcp    ProEd
pro-ed		8032/udp    ProEd
mindprint	8033/tcp    MindPrint
mindprint	8033/udp    MindPrint
#			    Larry Tusoni <larry@goldrush.com>
http-alt	8080/tcp    HTTP Alternate (see port 80)
http-alt	8080/udp    HTTP Alternate (see port 80)
#			    Stephen Casner <casner@precpt.com>
cruise-enum	8376/tcp    Cruise ENUM
cruise-enum	8376/udp    Cruise ENUM
cruise-swroute	8377/tcp    Cruise SWROUTE
cruise-swroute	8377/udp    Cruise SWROUTE
cruise-config	8378/tcp    Cruise CONFIG
cruise-config	8378/udp    Cruise CONFIG
cruise-diags	8379/tcp    Cruise DIAGS
cruise-diags	8379/udp    Cruise DIAGS
cruise-update	8380/tcp    Cruise UPDATE
cruise-update	8380/udp    Cruise UPDATE
#			    Steve Husak <portmaster@cruisetech.com>   
cvd		8400/tcp    cvd
cvd		8400/udp    cvd
sabarsd		8401/tcp    sabarsd
sabarsd		8401/udp    sabarsd
abarsd		8402/tcp    abarsd
abarsd		8402/udp    abarsd
admind		8403/tcp    admind
admind		8403/udp    admind
#			    Aaron Bilbrey <abilbrey@commvault.com>
npmp            8450/tcp    npmp
npmp            8450/udp    npmp
#                           Ian Chard <ian@tanagra.demon.co.uk>
vp2p		8473/tcp    Vitual Point to Point
vp2p		8473/udp    itual Point to Point
#			    Jerome Grimbert <jgrimbert@clamart.marben.fr>
rtsp-alt	8554/tcp    RTSP Alternate (see port 554)
rtsp-alt	8554/udp    RTSP Alternate (see port 554)
#			    Stephen Casner <casner@precept.com>
ultraseek-http	8765/tcp   Ultraseek HTTP
ultraseek-http	8765/udp   Ultraseek HTTP
#			   Walter Underwood <wunder@infoseek.com>
cddbp-alt	8880/tcp    CDDBP
cddbp-alt	8880/udp    CDDBP
#			    Steve Scherf <steve@moonsoft.com>
ddi-tcp-1       8888/tcp    NewsEDGE server TCP (TCP 1)
ddi-udp-1       8888/udp    NewsEDGE server UDP (UDP 1)
ddi-tcp-2       8889/tcp    Desktop Data TCP 1
ddi-udp-2       8889/udp    NewsEDGE server broadcast
ddi-tcp-3       8890/tcp    Desktop Data TCP 2
ddi-udp-3       8890/udp    NewsEDGE client broadcast
ddi-tcp-4       8891/tcp    Desktop Data TCP 3: NESS application
ddi-udp-4       8891/udp    Desktop Data UDP 3: NESS application
ddi-tcp-5       8892/tcp    Desktop Data TCP 4: FARM product
ddi-udp-5       8892/udp    Desktop Date UDP 4: FARM product
ddi-tcp-6       8893/tcp    Desktop Data TCP 5: NewsEDGE/Web application
ddi-udp-6       8893/udp    Desktop Date UDP 5: NewsEDGE/Web application
ddi-tcp-7       8894/tcp    Desktop Data TCP 6: COAL application
ddi-udp-7       8894/udp    Desktop Date UDP 6: COAL application
#                           Fred Yao <Fred_Yao@DDIGATE2.desktopdata.com>
cslistener      9000/tcp    CSlistener
cslistener      9000/udp    CSlistener
#                           David Jones <djones@cincom.com>
sctp		9006/tcp    SCTP
sctp		9006/udp    SCTP
#			    Gary Regan <gregan@tagnet.org>
websm		9090/tcp    WebSM
websm		9090/udp    WebSM
#			    I-Hsing Tsao <itsao@austin.ibm.com>
man		9535/tcp
man		9535/udp
sd              9876/tcp    Session Director
sd              9876/udp    Session Director
#                           Van Jacobson <van@ee.lbl.gov>
monkeycom	9898/tcp    MonkeyCom
monkeycom	9898/udp    MonkeyCom
#			    Yuji Kuwabara <HHG01200@niftyserve.or.jp>
#		9899-9991   Unassigned
palace          9992/tcp    Palace
palace          9992/udp    Palace
palace          9993/tcp    Palace
palace          9993/udp    Palace
palace          9994/tcp    Palace
palace          9994/udp    Palace
palace          9995/tcp    Palace
palace          9995/udp    Palace
palace          9996/tcp    Palace
palace          9996/udp    Palace
palace		9997/tcp    Palace
palace		9997/udp    Palace
#			    Charles Kawasaki <CK@thepalace.com>
distinct32      9998/tcp    Distinct32
distinct32      9998/udp    Distinct32
distinct        9999/tcp   distinct
distinct        9999/udp   distinct
#                          Anoop Tewari <anoop@next.distinct.com>
ndmp            10000/tcp  Network Data Management Protocol
ndmp            10000/udp  Network Data Management Protocol
#                          Brian Ehrmantraut <bae@netapp.com>
#		10001-10006 Unassigned
mvs-capacity	10007/tcp  MVS Capacity
mvs-capacity	10007/udp  MVS Capacity
#			   Donna Dillenberger <engd@us.ibm.com>
#		10008-11000 Unassigned
metasys		11001/tcp  Metasys
metasys		11001/udp  Metasys
#			   Tobin Schuster <tobin.j.schuster@jci.com>
atm-uhas	11367/tcp  ATM UHAS
atm-uhas	11367/udp  ATM UHAS
#			   Todd Barker <toddba@attachmate.com>
entextxid	12000/tcp  IBM Enterprise Extender SNA XID Exchange
entextxid	12000/udp  IBM Enterprise Extender SNA XID Exchange
entextnetwk	12001/tcp  IBM Enterprise Extender SNA COS Network Priority
entextnetwk	12001/udp  IBM Enterprise Extender SNA COS Network Priority
entexthigh	12002/tcp  IBM Enterprise Extender SNA COS High Priority
entexthigh	12002/udp  IBM Enterprise Extender SNA COS High Priority
entextmed	12003/tcp  IBM Enterprise Extender SNA COS Medium Priority
entextmed	12003/udp  IBM Enterprise Extender SNA COS Medium Priority
entextlow	12004/tcp  IBM Enterprise Extender SNA COS Low Priority
entextlow	12004/udp  IBM Enterprise Extender SNA COS Low Priority
#			   Eugene Cox <genecox@raleigh.ibm.com>
tsaf            12753/tcp  tsaf port   
tsaf            12753/udp  tsaf port   
#                          Andreas Fehr <100042.2070@CompuServe.COM>
i-zipqd		13160/tcp  I-ZIPQD
i-zipqd		13160/udp  I-ZIPQD
#			   Chuck Runquist <crunquist@quarterdeck.com>
bprd		13720/tcp  BPRD Protocol (VERITAS NetBackup)
bprd		13720/udp  BPRD Protocol (VERITAS NetBackup)
bpbrm		13721/tcp  BPBRM Protocol (VERITAS NetBackup)
bpbrm		13721/udp  BPBRM Protocol (VERITAS NetBackup)
bpcd		13782/tcp  VERITAS NetBackup
bpcd		13782/udp  VERITAS NetBackup
#			   Jeff Holmbeck <Jeff.Holmbeck@veritas.com>
dsmcc-config    13818/tcp  DSMCC Config
dsmcc-config	13818/udp  DSMCC Config
dsmcc-session	13819/tcp  DSMCC Session Messages
dsmcc-session	13819/udp  DSMCC Session Messages
dsmcc-passthru	13820/tcp  DSMCC Pass-Thru Messages
dsmcc-passthru	13820/udp  DSMCC Pass-Thru Messages
dsmcc-download	13821/tcp  DSMCC Download Protocol
dsmcc-download	13821/udp  DSMCC Download Protocol
dsmcc-ccp	13822/tcp  DSMCC Channel Change Protocol
dsmcc-ccp	13822/udp  DSMCC Channel Change Protocol
#			   Tim Addington <Tim.Addington@sciatl.com>
#			   ISO/IEC 13818-6 MPEG-2 DSM-CC
isode-dua	17007/tcp
isode-dua	17007/udp
biimenu         18000/tcp  Beckman Instruments, Inc.
biimenu         18000/udp  Beckman Instruments, Inc.
#                    R. L. Meyering <RLMEYERING@BIIVAX.DP.BECKMAN.COM>
jcp		19541/tcp JCP Client
jcp		19541/udp JCP Client
#			  Yuji Sasaki <sasaki@jci.co.jp>
webphone        21845/tcp webphone
webphone        21845/udp webphone
netspeak-is     21846/tcp NetSpeak Corp. Directory Services
netspeak-is     21846/udp NetSpeak Corp. Directory Services
netspeak-cs     21847/tcp NetSpeak Corp. Connection Services
netspeak-cs     21847/udp NetSpeak Corp. Connection Services
netspeak-acd    21848/tcp NetSpeak Corp. Automatic Call Distribution
netspeak-acd    21848/udp NetSpeak Corp. Automatic Call Distribution
netspeak-cps    21849/tcp NetSpeak Corp. Credit Processing System
netspeak-cps    21849/udp NetSpeak Corp. Credit Processing System
#                         Shane D. Mattaway <root@netspeak.com>
wnn6            22273/tcp wnn6
wnn6            22273/udp wnn6
#                         Yasunari Gon Yamasita <yamasita@omronsoft.co.jp
vocaltec-wconf  22555/tcp Vocaltec Web Conference
vocaltec-phone  22555/udp Vocaltec Internet Phone
#                         Scott Petrack <Scott_Petrack@vocaltec.com>
aws-brf         22800/tcp Telerate Information Platform LAN
aws-brf         22800/udp Telerate Information Platform LAN
#                         Timo Sivonen <timo.sivonen@ccmail.dowjones.com>
brf-gw          22951/tcp Telerate Information Platform WAN
brf-gw          22951/udp Telerate Information Platform WAN
#                         Timo Sivonen <timo.sivonen@ccmail.dowjones.com>
icl-twobase1    25000/tcp icl-twobase1
icl-twobase1    25000/udp icl-twobase1
icl-twobase2    25001/tcp icl-twobase2
icl-twobase2    25001/udp icl-twobase2
icl-twobase3    25002/tcp icl-twobase3
icl-twobase3    25002/udp icl-twobase3
icl-twobase4    25003/tcp icl-twobase4
icl-twobase4    25003/udp icl-twobase4
icl-twobase5    25004/tcp icl-twobase5
icl-twobase5    25004/udp icl-twobase5
icl-twobase6    25005/tcp icl-twobase6
icl-twobase6    25005/udp icl-twobase6
icl-twobase7    25006/tcp icl-twobase7
icl-twobase7    25006/udp icl-twobase7
icl-twobase8    25007/tcp icl-twobase8
icl-twobase8    25007/udp icl-twobase8
icl-twobase9    25008/tcp icl-twobase9
icl-twobase9    25008/udp icl-twobase9
icl-twobase10   25009/tcp icl-twobase10
icl-twobase10   25009/udp icl-twobase10
#               J. A. (Tony) Sever <J.A.Sever@bra0119.wins.icl.co.uk>
vocaltec-hos    25793/tcp  Vocaltec Address Server      
vocaltec-hos    25793/udp  Vocaltec Address Server
#                          Scott Petrack <Scott_Petrack@vocaltec.com>
quake           26000/tcp  quake
quake           26000/tcp  quake
wnn6-ds         26208/tcp  wnn6-ds
wnn6-ds         26208/udp  wnn6-ds
#                          Yasunari Gon Yamasita <yamasita@omronsoft.co.jp>
flex-lm		27000-27009 FLEX LM (1-10)
#			   Daniel Birns <daniel@globes.com>
tw-auth-key	27999/tcp  TW Authentication/Key Distribution and 
tw-auth-key	27999/udp  Attribute Certificate Services
#			   Alex Duncan <Alex.Duncan@sse.ie> 
rockwell-encap	44818/tcp  Rockwell Encapsulation
rockwell-encap	44818/udp  Rockwell Encapsulation
#			   Brian Batke <babatke@ra.rockwell.com>
eba		45678/tcp  EBA PRISE
eba		45678/udp  EBA PRISE
#			   Patrick<Kara <Patrick@EBA.NET>
dbbrowse        47557/tcp  Databeam Corporation
dbbrowse        47557/udp  Databeam Corporation
#                          Cindy Martin <cmartin@databeam.com>
directplaysrvr	47624/tcp  Direct Play Server
directplaysrvr  47624/udp  Direct Play Server
#			   Ajay Jindal <ajayj@microsoft.com>
ap              47806/tcp  ALC Protocol
ap              47806/udp  ALC Protocol
#                          Andrew Newton <alnewton@automatedlogic.com>
bacnet          47808/tcp  Building Automation and Control Networks
bacnet          47808/udp  Building Automation and Control Networks
#                          H. Michael Newman <hmn2@cornell.edu>


DYNAMIC AND/OR PRIVATE PORTS

The Dynamic and/or Private Ports are those from 49152 through 65535


REFERENCES

[RFC768] Postel, J., "User Datagram Protocol", STD 6, RFC 768,
         USC/Information Sciences Institute, August 1980.

[RFC793] Postel, J., ed., "Transmission Control Protocol - DARPA
         Internet Program Protocol Specification", STD 7, RFC 793,
         USC/Information Sciences Institute, September 1981.



[]

